/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vrcsum.c
 >>>>
 >>>>      Program Name: vrcsum
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Compute row and column sums
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Mon Apr 15 22:15:59 1991
 >>>>
 >>>>          Routines: main- the main program for vrcsum
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vrcsum.h"


/****************************************************************
 *
 * Routine Name:  main program for vrcsum
 *
 *       Input:  
 *        -i  input image filename 
 *
 *
 *        [-or] row sum output image filename
 *        [-oc] col sum output image filename
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        struct xvimage *image,*orimage,*ocimage,*readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);
        image = readimage(vrcsum->i_file);
        if (image == NULL) exit(1);
        CHECKINPUT(program, image);
        if (vrcsum->or_flag == 0) orimage = NULL;
        if (vrcsum->oc_flag == 0) ocimage = NULL;
/* -main_before_lib_call_end */

/* -main_library_call */
        if(! lvrcsum(image,&orimage,&ocimage))
          {
            (void) fprintf(stderr, "lvrcsum Failed\n");
            exit(1);
          }
/* -main_library_call_end */

/* -main_after_lib_call */
        if (vrcsum->or_flag) writeimage(vrcsum->or_file,orimage);
        if (vrcsum->oc_flag) writeimage(vrcsum->oc_file,ocimage);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vrcsum 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vrcsum :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCompute row and column sums\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image filename  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-or]  row sum output image filename (outfile) [null]\n");
	fprintf(stderr,"\t[-oc]  col sum output image filename (outfile) [null]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vrcsum\n");
	fprintf(stderr, "\t[-U] Gives the usage for vrcsum\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vrcsum.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vrcsum.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vrcsum
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*or_pstr = 
	"\nEnter: (or) row sum output image filename \n        {outfile}: "; 
char	*oc_pstr = 
	"\nEnter: (oc) col sum output image filename \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vrcsum", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vrcsum.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vrcsum: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vrcsum.ans");
		}

	     }

	}

	/*
	 * allocate the vrcsum structure
	 */
	vrcsum = (vrcsum_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vrcsum_struct));

	/*
	 * get required arguments for vrcsum
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vrcsum->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vrcsum->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vrcsum->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vrcsum->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vrcsum->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vrcsum
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vrcsum->or_flag = vget_outfile(fid, prompt_flag,
	"-or", or_pstr, &(vrcsum->or_file))
;

	vrcsum->oc_flag = vget_outfile(fid, prompt_flag,
	"-oc", oc_pstr, &(vrcsum->oc_file))
;


}



