/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vdrape.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Mon Apr 15 22:19:22 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vdrape_h_
#define _vdrape_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vdrape Argument Structure
*
****************************************************************/

typedef struct _vdrape  {

/*
 *  imagery image (Required infile)
 */
char	*i_file;	/* imagery image FILENAME */
int	 i_flag;	/* imagery image FLAG */

/*
 *  surface image (Required infile)
 */
char	*s_file;	/* surface image FILENAME */
int	 s_flag;	/* surface image FLAG */

/*
 *  output image (Required outfile)
 */
char	*o_file;	/* output image FILENAME */
int	 o_flag;	/* output image FLAG */

/*
 *  X coordinate of imagery reference pixel (Required integer)
 */
int	 xi_int; 	/* X coordinate of imagery reference pixel INT */
int	 xi_flag;	/* X coordinate of imagery reference pixel FLAG */

/*
 *  Y coordinate of imagery reference pixel (Required integer)
 */
int	 yi_int; 	/* Y coordinate of imagery reference pixel INT */
int	 yi_flag;	/* Y coordinate of imagery reference pixel FLAG */

/*
 *  X coordinate of surface reference pixel (Required integer)
 */
int	 xs_int; 	/* X coordinate of surface reference pixel INT */
int	 xs_flag;	/* X coordinate of surface reference pixel FLAG */

/*
 *  Y coordinate of surface reference pixel (Required integer)
 */
int	 ys_int; 	/* Y coordinate of surface reference pixel INT */
int	 ys_flag;	/* Y coordinate of surface reference pixel FLAG */

}  vdrape_struct;

vdrape_struct *vdrape;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
