/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: veplane.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Mon Apr 15 22:19:30 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _veplane_h_
#define _veplane_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    veplane Argument Structure
*
****************************************************************/

typedef struct _veplane  {

/*
 *  input image (Required infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  output image (Required outfile)
 */
char	*o_file;	/* output image FILENAME */
int	 o_flag;	/* output image FLAG */

/*
 *  Angle of plane with respect to X axis (Required float)
 */
float	 xa_float;	/* Angle of plane with respect to X axis FLOAT */
int	 xa_flag;   	/* Angle of plane with respect to X axis FLAG */

/*
 *  Angle of plane with respect to Y axis (Required float)
 */
float	 ya_float;	/* Angle of plane with respect to Y axis FLOAT */
int	 ya_flag;   	/* Angle of plane with respect to Y axis FLAG */

}  veplane_struct;

veplane_struct *veplane;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
