/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vibfsim.c
 >>>>
 >>>>      Program Name: vibfsim
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Simulate General Ion Beam Figuring
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Mon Apr 15 22:20:01 1991
 >>>>
 >>>>          Routines: main- the main program for vibfsim
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vibfsim.h"


/****************************************************************
 *
 * Routine Name:  main program for vibfsim
 *
 *       Input:  
 *         -surface  surface image 
 *         -sputter  sputter yield image 
 *         -dwell  time dwell image 
 *         -dist  ion source distance from reference plane (m)   (0.000 < value < 1.000)
 *         -w  width of beam patch in meters   (0.000 < value < 1.000)
 *         -o  output image 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *surface,*dwell,*sputter,*remove,*readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);

        surface = readimage(vibfsim->surface_file);
        if (surface == NULL) exit(1);                    

        sputter = readimage(vibfsim->sputter_file);
        if (sputter == NULL) exit(1);                    

        dwell = readimage(vibfsim->dwell_file);
        if (dwell == NULL) exit(1);                    

        if (surface->data_storage_type != VFF_TYP_FLOAT)
          {
            fprintf(stderr,"vibf: Surface image must be a FLOAT image\n");
            exit(1);
          }
        if (sputter->data_storage_type != VFF_TYP_FLOAT)
          {
            fprintf(stderr,"vibf: Sputter yield image must be a FLOAT image\n");
            exit(1);
          }
        if (dwell->data_storage_type != VFF_TYP_FLOAT)
          {
            fprintf(stderr,"vibf: Dwell image must be a FLOAT image\n");
            exit(1);
          }
/* -main_before_lib_call_end */

/* -main_library_call */
        if(! lvibfsim(surface,sputter,dwell,vibfsim->dist_float,
                      vibfsim->w_float,&remove) )
        {
            (void) fprintf(stderr, "lvibfsim Failed\n");
            exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        (void) writeimage(vibfsim->o_file, remove);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vibfsim 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vibfsim :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tSimulate General Ion Beam Figuring\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-surface  surface image  (infile)\n");
	fprintf(stderr,"\t-sputter  sputter yield image  (infile)\n");
	fprintf(stderr,"\t-dwell  time dwell image  (infile)\n");
	fprintf(stderr,"\t-dist  ion source distance from reference plane (m)  (float,  0.000 to 1.000)\n");
	fprintf(stderr,"\t-w  width of beam patch in meters  (float,  0.000 to 1.000)\n");
	fprintf(stderr,"\t-o  output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vibfsim\n");
	fprintf(stderr, "\t[-U] Gives the usage for vibfsim\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vibfsim.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vibfsim.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vibfsim
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*surface_pstr = 
	"\nEnter: (surface) surface image \n        {infile}: "; 
char	*sputter_pstr = 
	"\nEnter: (sputter) sputter yield image \n        {infile}: "; 
char	*dwell_pstr = 
	"\nEnter: (dwell) time dwell image \n        {infile}: "; 
char	*dist_pstr = 
	"\nEnter: (dist) ion source distance from reference plane (m) \n        {float,  0.000 to 1.000}: "; 
char	*w_pstr = 
	"\nEnter: (w) width of beam patch in meters \n        {float,  0.000 to 1.000}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vibfsim", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vibfsim.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vibfsim: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vibfsim.ans");
		}

	     }

	}

	/*
	 * allocate the vibfsim structure
	 */
	vibfsim = (vibfsim_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vibfsim_struct));

	/*
	 * get required arguments for vibfsim
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vibfsim->surface_flag = vget_infile(fid, prompt_flag,
			"-surface", surface_pstr, &(vibfsim->surface_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vibfsim->surface_flag))
		{
		    fprintf(stderr, "\t\tsurface is required, please re-enter: \n");
		    vibfsim->surface_flag = vget_infile(fid, prompt_flag,
		    "-surface", surface_pstr, &(vibfsim->surface_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-surface' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vibfsim->sputter_flag = vget_infile(fid, prompt_flag,
			"-sputter", sputter_pstr, &(vibfsim->sputter_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vibfsim->sputter_flag))
		{
		    fprintf(stderr, "\t\tsputter is required, please re-enter: \n");
		    vibfsim->sputter_flag = vget_infile(fid, prompt_flag,
		    "-sputter", sputter_pstr, &(vibfsim->sputter_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-sputter' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vibfsim->dwell_flag = vget_infile(fid, prompt_flag,
			"-dwell", dwell_pstr, &(vibfsim->dwell_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vibfsim->dwell_flag))
		{
		    fprintf(stderr, "\t\tdwell is required, please re-enter: \n");
		    vibfsim->dwell_flag = vget_infile(fid, prompt_flag,
		    "-dwell", dwell_pstr, &(vibfsim->dwell_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-dwell' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vibfsim->dist_flag = vget_float(fid, prompt_flag,
			"-dist", dist_pstr, &(vibfsim->dist_float),
			0.200000, 0.000000, 1.000000)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vibfsim->dist_flag))
		{
		    fprintf(stderr, "\t\tdist is required, please re-enter: \n");
		    vibfsim->dist_flag = vget_float(fid, prompt_flag,
		    "-dist", dist_pstr, &(vibfsim->dist_float),
		    0.200000, 0.000000, 1.000000);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-dist' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vibfsim->w_flag = vget_float(fid, prompt_flag,
			"-w", w_pstr, &(vibfsim->w_float),
			0.070000, 0.000000, 1.000000)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vibfsim->w_flag))
		{
		    fprintf(stderr, "\t\tw is required, please re-enter: \n");
		    vibfsim->w_flag = vget_float(fid, prompt_flag,
		    "-w", w_pstr, &(vibfsim->w_float),
		    0.070000, 0.000000, 1.000000);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-w' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vibfsim->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vibfsim->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vibfsim->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vibfsim->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vibfsim->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



