/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vibfsim.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Mon Apr 15 22:20:01 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vibfsim_h_
#define _vibfsim_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vibfsim Argument Structure
*
****************************************************************/

typedef struct _vibfsim  {

/*
 *  surface image (Required infile)
 */
char	*surface_file;	/* surface image FILENAME */
int	 surface_flag;	/* surface image FLAG */

/*
 *  sputter yield image (Required infile)
 */
char	*sputter_file;	/* sputter yield image FILENAME */
int	 sputter_flag;	/* sputter yield image FLAG */

/*
 *  time dwell image (Required infile)
 */
char	*dwell_file;	/* time dwell image FILENAME */
int	 dwell_flag;	/* time dwell image FLAG */

/*
 *  ion source distance from reference plane (m) (Required float)
 */
float	 dist_float;	/* ion source distance from reference plane (m) FLOAT */
int	 dist_flag;   	/* ion source distance from reference plane (m) FLAG */

/*
 *  width of beam patch in meters (Required float)
 */
float	 w_float;	/* width of beam patch in meters FLOAT */
int	 w_flag;   	/* width of beam patch in meters FLAG */

/*
 *  output image (Required outfile)
 */
char	*o_file;	/* output image FILENAME */
int	 o_flag;	/* output image FLAG */

}  vibfsim_struct;

vibfsim_struct *vibfsim;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
