/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: example2.c
 >>>>
 >>>>      Program Name: example2
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	     This simple program is an example of an xvroutine that  uses
 >>>>	the  xvdisplay  library.   It  simply  displays a VIFF image in a
 >>>>	viewport with a scroll bar, so that in case the viewport  is  too
 >>>>	small  to  display  the  images  (and it deliberately is, in most
 >>>>	cases), you may use the scroll bars to view the other portions of
 >>>>	the image.
 >>>>	
 >>>>	
 >>>>            Author: Danielle Argiro
 >>>>
 >>>> Date Last Updated: Wed Apr 24 09:50:40 1991
 >>>>
 >>>>          Routines: main- the main program for example2
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "example2.h"


/****************************************************************
 *
 * Routine Name:  main program for example2
 *
 *       Input:  
 *
 *
 *          [-i] Input Image
 *          [-w] width of viewport  (value > 0)
 *          [-h] height of viewport  (value > 0)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
/* -main_before_lib_call_end */

/* -main_library_call */
        run_example2(argc, argv, program);
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for example2 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "example2 :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t     This simple program is an example of an xvroutine that  uses\n");
	fprintf(stderr, "\tthe  xvdisplay  library.   It  simply  displays a VIFF image in a\n");
	fprintf(stderr, "\tviewport with a scroll bar, so that in case the viewport  is  too\n");
	fprintf(stderr, "\tsmall  to  display  the  images  (and it deliberately is, in most\n");
	fprintf(stderr, "\tcases), you may use the scroll bars to view the other portions of\n");
	fprintf(stderr, "\tthe image.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-i]  Input Image (infile) [null]\n");
	fprintf(stderr,"\t[-w]  width of viewport (integer, > 0) [1]\n");
	fprintf(stderr,"\t[-h]  height of viewport (integer, > 0) [1]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-fn] specifies the font for example2\n");
	fprintf(stderr, "\t[-V] Gives the version for example2\n");
	fprintf(stderr, "\t[-U] Gives the usage for example2\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called example2.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses example2.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for example2
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) Input Image \n        {infile}: "; 
char	*w_pstr = 
	"\nEnter: (w) width of viewport \n        {integer, > 0 [1] }: "; 
char	*h_pstr = 
	"\nEnter: (h) height of viewport \n        {integer, > 0 [1] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "example2", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "example2.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "example2: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "example2.ans");
		}

	     }

	}

	/*
	 * allocate the example2 structure
	 */
	example2 = (example2_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (example2_struct));

	/*
	 * get optional arguments for example2
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	example2->i_flag = vget_infile(fid, prompt_flag,
	"-i", i_pstr, &(example2->i))
;

	example2->w_flag = vget_int(fid, prompt_flag,
	"-w", w_pstr, &(example2->w),
	1, 2, 2);

	example2->h_flag = vget_int(fid, prompt_flag,
	"-h", h_pstr, &(example2->h),
	1, 2, 2);


}



