/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lexample2.c
 >>>>
 >>>>      Program Name: example2
 >>>>
 >>>> Date Last Updated: Wed Apr 24 09:50:42 1991 
 >>>>
 >>>>          Routines: lexample2 - the library call for example2
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "xvinclude.h"


/* -library_includes */
#include "example2.h"
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lexample2 - library call for example2
*
* Purpose:
*
* Input:
* Output:
*
* Written By: Danielle Argiro
****************************************************************/


/* -library_def */
run_example2(argc, argv, program)
int     argc;
char    *argv[];
char    *program;
/* -library_def_end */

/* -library_code */
{
        xvf_form  *form;
        master example2_info;
        char *form_filestring;
        char *form_pathname;

        Widget canvas;          /* simple widget created with -w */
        Widget viewport;        /* viewport backplane with scroll bar */
        int    i, wksp_width, wksp_height, vp_width, vp_height;
        Arg    arg[MaxArgs];
        struct xvimage   *image;

        /*
         * initialize the display & the forms - 
         * NOTE: assuming a global 'Display *display'
         */
        display = xvf_initialize(ac, av, program);
        if (display == NULL)
        {
             fprintf(stderr, "Could not open connection to server");
             exit(0);
        }

        /*
         * Substitute below the correct filename and directory path
         * of the User Interface Description file to be used
         */
        form_filestring = xvf_strcpy("example2.form");
        form_pathname   = xvf_strcpy("$KHOROS_CONTRIB/repos/xvroutines");
        form_filestring = vfullpath(form_filestring, form_pathname, NULL);

        /*
         * Create the forms 
         */
        if (!(form = xvf_create_form(form_filestring, av, ac, SIMPLE, NULL,
                                     -1, -1)))
           exit(0);

        /*
         * Initialize the auto-generated information structure
         */
        _xvf_init_master(form,  &example2_info);

        /*
         *  the Simple Widget created with [-w] will be the parent of 
         *  the widgets that we will be creating
         */
         canvas = example2_info.sub->pane->canvas;

        /*
         * want to display an image
         */
         xvd_initialize(display);
         
         if (example2->i != NULL) 
            image = readimage(example2->i);
         else
            image = NULL;
         xvdisplay = xvd_init_image(display, image, NULL, NULL, NULL,
                                    False, False, False, NULL);
         /*
          *  determine width & height of viewport
          */
         if (example2->w_flag)
            vp_width = example2->w; 
         else if (image != NULL)
            vp_width    = (int) image->row_size/2;
         else vp_width = 255;

         if (example2->h_flag)
            vp_height = example2->h; 
         else if (image != NULL)
            vp_height   = (int) image->col_size/2;
         else vp_height = 255;

         if (image == NULL)
         {
            wksp_width  = 512;
            wksp_height = 512;
         }
         else 
         {
            wksp_width  = image->row_size;
            wksp_height = image->col_size;
         }

        /*
         * create the viewport widget which will provide backplane 
         * with scroll bar - we'll give it a Form Widget as a child
         */

         i = 0;
         XtSetArg(arg[i], XtNallowVert, True);                          i++;
         XtSetArg(arg[i], XtNallowHoriz, True);                         i++;
         XtSetArg(arg[i], XtNwidth,   vp_width);                        i++;
         XtSetArg(arg[i], XtNheight,  vp_height);                       i++;
         XtSetArg(arg[i], XtNforceBars, True);                          i++;
         viewport = XtCreateManagedWidget("viewport",viewportWidgetClass,
                                          canvas,arg,i);

        /*
         * create the Simple Widget on which actual display will take place -
         * it is a child of the Viewport widget
         */
         i = 0;
         XtSetArg(arg[i],XtNborderWidth,0);           i++;
         XtSetArg(arg[i],XtNdefaultDistance,0);       i++;
         XtSetArg(arg[i],XtNwidth,   wksp_width);     i++;
         XtSetArg(arg[i],XtNheight,  wksp_height);    i++;
         workspace = XtCreateManagedWidget("workspace",formWidgetClass,
                                           viewport,arg,i);

         xvd_create_raster(display, workspace, xvdisplay, False);


        /*
         * Map the forms
         */
        xvf_change_active(form, true);

        do
        {
             /*
              * run the forms
              */
             form = xvf_run_form();
             if (form == NULL) break;

             /*
              * get information from the master
              */
             _xvf_get_master(form, &example2_info);

             /*
              * action came from the 'sub' subform
              */
             if (example2_info.sub_selected)
             {
                  run_sub(form, example2_info.sub);
             }


        xvf_clear_selections(form->db, form->line_num);
        } while (!example2_info.sub->pane->quit);    /* end user interface loop */
        return(TRUE);
}
/* -library_code_end */
