 /*
  * Khoros: $Id: tga.h,v 1.1 1991/05/10 04:13:15 khoros Exp $
  */

 /*
  * $Log: tga.h,v $
 * Revision 1.1  1991/05/10  04:13:15  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: tga.h                                  <<<<
   >>>>                                                       <<<<
   >>>>      contains: contains defines to TGA file format    <<<<
   >>>>                version 2.0                            <<<<
   >>>>                                                       <<<<
   >>>>      written by: Pascal Adam   			      <<<<
   >>>>                                                       <<<<
   >>>>      date: 4/25/90                                    <<<<
   >>>>                                                       <<<<
   >>>>      modifications:				      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _tga_h_
#define _tga_h_

/***************************************************************************
  
  	This section defines the file formats recommended for storing
  	images for the AT&T Truevision product family. These formats 
  	should be used by all software developed for the Truevision
  	product family. This standard is recommended since it allows
  	software products to be compatible with our telecommunications
  	and imaging software.
   
        Truevision Inc. has currently defined eleventypes of data files.
  
        The File Format is the following one:


   BYTE |||               FIELD NAME               | 
____________________________________________________              
----------------------------------------------------       ----- 
     0  |||   I.D. Length                          |           |
____________________________________________________           |  
----------------------------------------------------           | 
     1  |||   Color Map Type                       |           | 
____________________________________________________           |  
----------------------------------------------------           | T G A  File 
     2  |||   Image Type                           |           | (Fixed Length)
____________________________________________________           |  
----------------------------------------------------           |-----
     3  |||   Color Map Specification              |           |
        |||               ( 5 bytes )              |           |
____________________________________________________           |  
----------------------------------------------------           |
     8  |||   Image Specification                  |           |
        |||               ( 10 bytes)              |           |
____________________________________________________           |  
----------------------------------------------------       ----| 
Variable|||   Image I.D.                           |           |
        /\/                                       /\/          | 
____________________________________________________           | Image/Color Map
----------------------------------------------------           | DATA      
Variable|||   Color Map Data                       |           | Variable Length
        /\/                                       /\/          |-----     Fields
____________________________________________________           |  
----------------------------------------------------           |
Variable|||   Image Data                           |           |
        /\/                                       /\/          |
____________________________________________________           |  
----------------------------------------------------           |
Variable|||   Developer Fields                     |           |  
        /\/                                       /\/          |
____________________________________________________           |  
----------------------------------------------------           | 
Variable|||   Developer Directory                  |           |
        |||                                        |           |
        /\/                                       /\/          |
____________________________________________________           |  
----------------------------------------------------       ----|  
    0   |||   Extension Size                       |    Short  |
----------------------------------------------------           |
    2   |||   Author Name                          |    ASCII  |
----------------------------------------------------           |
   43   |||   Authors Comments                     |    ASCII  |
----------------------------------------------------           |
  367   |||   Date / Time Stamp                    |    Shorts |
----------------------------------------------------           |
  379   |||   Job Name / ID                        |    Short  |
----------------------------------------------------           |
  420   |||   Job Time                             |    Shorts |
----------------------------------------------------           |
  426   |||   Software I.D.                        |    ASCII  |
----------------------------------------------------           | Extension Area
  467   |||   Software Version                     |    3 Bytes|
----------------------------------------------------           | Variable Length
  470   |||   Key Color                            |    Long   | (Optional)
----------------------------------------------------           |-----
  474   |||   Pixel Aspect Ratio                   |    Shorts |
----------------------------------------------------           |
  478   |||   Gamma Value                          |    ASCII  | This is only
----------------------------------------------------           | for version 2.0
  482   |||   Color Correction Offset              |    long   | and +
----------------------------------------------------           |
  486   |||   Postage Stamp Offset                 |    long   |
----------------------------------------------------           |
  490   |||   Scan Line Offset                     |    Long   |
----------------------------------------------------           |
  494   |||   Attributes Type                      |    Byte   |
____________________________________________________           |
----------------------------------------------------           |
Variable|||   Scan Line Table                      |           |
----------------------------------------------------           |
Variable|||   Postage Stamp Image                  |           |
----------------------------------------------------           |
2 kbytes|||   Color Correction Table               |           |
____________________________________________________       ____|
----------------------------------------------------       ----|
    0   |||   Extension Area Offset                |    Long   |
----------------------------------------------------           | TGA File Footer
    4   |||   Developper Directory Offset          |    Long   | Fixed Length
----------------------------------------------------           |-----
    8   |||   Extension / Order Signature          |    ASCII  | 
---------------------------------------------------------------- (Optional)

        ************************************************************************
        *     Description of the different Usefull fields   ------------------ *
        ************************************************************************


        Field 1:Number of characters in IDENTIFICATION FIELD (1 byte).
       		This field identifies the number of bytes in field 6,
		the image identification field. The maximum number of
		characters is 255. A value of 0 indicates that no 
		identification field is included.

	Field 2:Color Map Type (1 byte). 

	Field 3:Image Type Code (1 byte).
	
	Field 4:Color Map Specification (5 bytes).
	
		Field 4.1:Color Map Origin (2 bytes). Index of first
			  color map entry.

		Field 4.2:Color Map Length (2 bytes). Number of color
		 	  map entries.

		Field 4.3:Color Map Entry Size (1 byte). Number of bits
			  in color_map entry.

	Field 5:Image Specification (10 bytes).

		Field 5.1:X-origin of image (2 bytes). 5.1 and 5.2 
			  specify the lower left corner of the image.
		Field 5.2:(2 bytes). See previous subfield.
	
		Field 5.3:(2 bytes). Width of the image in pixels.

		Field 5.4:(2 bytes). Height of the image in pixels.

                Field 5.5:Image Pixel Size (1 byte). Number of bits in
			  a stored pixel.

		Field 5.6:Image Descriptor Byte (1byte).
			Bit 3-0: Number of attribute bits associated
				 with each pixel.
			Bit 4  : Reserved. Must be 0.

			Bit 5  : Screen origin bit:
					0 _ Origin in lower left-hand corner
					1 _ Origin in upper left-hand corner
  
                                        Must be set to 0 for Truevision images.
			Bit 7-6: Data storage Interleaving Flag
                                 00 - Non Interleaved.
                                 01 Two way interleaving.
				 10 Four way interleaving.
				 11 Reserved

				 Bits 7 through 4 must be set to 0 for the
                                 Truevision products.

	Field 6:Image Identification Field (variable):
   		Contains an identification field whose length in bytes 
		is specified in field 1. If required, additionnal identifi-
                cation information may be stored after the image data field
                (field 8).

	Field 7:Color Map Data (variable):
		Field 4.3 specifies the width in bits of each color map
		entry while field 4.2 specifies the number of color-map
		entries in this field. Each color map is stored using an
		integral number bytes. The RGB specification for each color
		map entry is stored in successive bit-fields in the multi-
                byte entries are assumed to be (Field 4.3)/3 bits in length.
		Unused bit(s) in the multi-byte entries are assumed to
		specify attribute bits.

	Field 8:Image data field (variable):
		This field specifies (width x height) pixels. Each pixel
		specifies a color map index. The values for Width and Height
		are specified in fields 5.3 and 5.4 respectively.
		The attribute and color definition bits for each picxel are 
		defined in fields 5.5 and 5.6, respectively. Each pixel is 
		stored as an integral number of bytes and the color-map
		index is stored in the least significant bits of the field.

	All fields are assumed to be unsigned. The low-order byte of two-byte
	field is stored first.
       
        ---------------------------------------------------------------------
        | Data  |                         Description                       |
        | Type  |                                                           |
	| Field |                                                           |
        |--------------------------------------------------------------------
        |   0   |   No Image Data Included                                  |
        |--------------------------------------------------------------------
        |   1   |   Uncompressed, Color Mapped (VDA/D and Targa M8) images  |
        |--------------------------------------------------------------------
        |   2   |   Uncompressed, RGB Images                                |
        |--------------------------------------------------------------------
        |   3   |   Uncompressed, Black and White Images                    |
        |--------------------------------------------------------------------
        |   9   |   Run-Length Encoded Color Mapped Images                  |
        |--------------------------------------------------------------------
        |   10  |   Run-Length Encoded RGB                                  |
        |--------------------------------------------------------------------
        |   11  |   Compressed, Black and White Images                      |
        |--------------------------------------------------------------------
        |   32  |   Compressed Color-Mapped Data using Huffman, Delta, and  |
        |       |   Run_Length Encoding.                                    |
        |--------------------------------------------------------------------
        |   33  |   Compressed Color-Mapped Data using Huffman, Delta, and  |
        |       |   Run_Length Encoding. Data encoded for presentation in   |
        |       |   4 passes.                                               |
        |--------------------------------------------------------------------

        Data type codes 0 to 127 (field 3) are reserved for use by Truevision
	Inc. for general applications. Data types 128 to 255 may be used for 
	user-specific applications. Similarly, the first 128 map types codes
	(field 2) are reserved and the second set of 128 map type codes may be
	used for user-specific applications.


The information in this file was derived from Appendix C: TRUEVISION IMAGE
FILE FORMATS of the TRUEVISION manual.

*****************************************************************************/


typedef struct {
       unsigned char num_char_iden;
       unsigned char col_map_typ;
       unsigned char ima_typ_code;
       unsigned short col_map_orig;
       unsigned short col_map_len;
       unsigned char  col_map_entry_size;
       unsigned short X;
       unsigned short Y;
       unsigned short width;
       unsigned short height;
       unsigned char  pix_size;
       unsigned char  ima_descript;
       } tga_header;

typedef struct {
       unsigned long ext_area_offset;
       unsigned long dev_dir_offset;
       unsigned char ext_ord_sign;
       } tga_footer;

typedef struct {
       unsigned char ext_size;        /* should be 494 for version 2.0*/
                                      /* def the length of fixed part */
                                      /* of the extension area ...... */
       unsigned char author_name[41]; /* the 41st byte must be a null */
       unsigned char comments[324];   /* organized as 4 lines of 80   */
                                      /* characters. The 81st byte of */
                                      /* each of the four lines must  */
                                      /* be a null .................. */ 
      short date_time_stamp[6];       /* def time&date image storage  */
      unsigned char job_name_id[41];  /* Job name or ID               */ 
      short job_time[3];              /* ....                         */
      unsigned char soft_id[41];
      unsigned char soft_version[3];  /* ex: version 4.17 -> 417      */
      unsigned char key_col[4];       /* ..........                   */
      short pixel_ration[2];          /* specify a pixel size ratio   */
      short gamma_value[2];
      long col_correct_offset;     
      long post_stamp_offset;
      long scan_line_offset;
      unsigned char attributes_type;
      } tga_fixed_ext_area;

typedef struct {
      tga_header tgaheader;
      char *imageidentifier;
      unsigned char *colormapdata;
      unsigned char *imagedata;
      unsigned char *dev_fields;
      unsigned char *dev_dir;
      tga_fixed_ext_area tgafixedextarea;
      unsigned char *scan_line_table;
      unsigned char *post_stamp_image;
      unsigned char *col_corr_table;
      tga_footer tgafooter;
      }  tga; 

/* the developper area and the Extension Area are not defined completely 
 * but could be if anybody needs it ....................................
 */

#define NODATA               0
#define UNCOMP_COL_MAP       1
#define UNCOMP_RGB           2
#define UNCOMP_B_W           3
#define R_L_ENCODED_COL_MAP  9
#define R_L_ENCODED_RGB     10
#define COMP_B_W            11
#define COMP_COL_MAP        32
#define COMP_COL_MAP_4      33

#endif
/* Don't add after the endif */

