 /*
  * Khoros: $Id: Stream.h,v 1.3 1992/03/20 23:38:46 dkhoros Exp $
  */

 /*
  * $Log: Stream.h,v $
 * Revision 1.3  1992/03/20  23:38:46  dkhoros
 * VirtualPatch5
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>								<<<<
   >>>>	    file name: Stream.h					<<<<
   >>>>								<<<<
   >>>>   description:						<<<<
   >>>>								<<<<
   >>>> modifications:						<<<<
   >>>>								<<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _Stream_h_
#define _Stream_h_


/*
 *  Internal structures for the following transport
 *
 *		stream	   -  Stream (FIFO) transport
 */

/* stream (FIFO) structure */
typedef struct
{
	int	fid;
} StreamStruct;

#undef  ResourceStruct
#define ResourceStruct StreamStruct


int	stream_tempnam(),
	stream_open(),
	stream_close(),
	stream_read(),
	stream_write(),
	stream_lseek(),
	stream_tell(),
	stream_access(),
	stream_unlink(),
	stream_lock(),
	stream_descriptors();


static TransportInformation stream_routines[] =
{
    {
	"Standard Stream (FIFO)",
	"stream",
	FALSE,
	stream_tempnam,
	stream_open,
	stream_close,
	stream_read,
	stream_write,
	stream_lseek,
	stream_tell,
	stream_access,
	stream_unlink,
	stream_lock,
	stream_descriptors,

	NULL,
    }
};

#endif /* _Stream_h_ */
/* don`t add after the endif */
