 /*
  * Khoros: $Id: expandpath.c,v 1.2 1991/10/02 00:32:50 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: expandpath.c,v 1.2 1991/10/02 00:32:50 khoros Exp $";
#endif

 /*
  * $Log: expandpath.c,v $
 * Revision 1.2  1991/10/02  00:32:50  khoros
 * HellPatch2
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */

#ifndef AUX
#include <sys/param.h>
#endif 

#include "vgparm.h"	
#ifdef UNICOS
#define MAXPATHLEN    PATHSIZE
#endif


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: expandpath.c                           <<<<
   >>>>                                                       <<<<
   >>>>   description: File utility                           <<<<
   >>>>                                                       <<<<
   >>>>      routines: vexpandpath()			      <<<<
   >>>>                                                       <<<<
   >>>> modifications:					      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/**************************************************************
*
* MODULE NAME: vexpandpath
*
*     PURPOSE: This function expands a path
*
*       INPUT: filename    - the file to be expanded
*	       global_dir  - the global directory is used as a prefix
*			     to the filename.  If global_dir is
*	       return_file - if the return file is not NULL then
*			     this will be where we place the vfullpath
*			     to the expanded file.  Otherwise we malloc
*			     space and return the fille.
*	       
*        
*      OUTPUT: the full path to the expanded file.
*
* CALLED FROM: 
*
*  WRITTEN BY:  Mark Young & Tom Sauer & Charile Gage
*
**************************************************************/


char *vexpandpath(filename, global_dir, return_file)

char	*filename, *global_dir, *return_file;
{
	struct stat buf;
	char *basename, *dirname, *vdirname(), *vbasename();
	char fullpath[LENGTH], dir[MAXPATHLEN], save[MAXPATHLEN];


	/*
	 *  Get the fullpath to the file so that we may expand it
	 */
	if (global_dir != NULL || filename != NULL)
	{
	   if (filename == NULL)
	   {
	     if (vfullpath(global_dir, NULL, fullpath) == NULL)
	        return(NULL);
	   }
	   else
	   {
	     if (vfullpath(filename, global_dir, fullpath) == NULL)
	        return(NULL);
	   }
	}
	else
	{
	   strcpy(fullpath, "./");
	}

	/*
	 *  Stat the fullpath to see if it is a directory or file.
	 */
	basename = NULL;
	if (stat(fullpath, &buf) == -1)
	{
	   dirname  = vdirname(fullpath);
	   basename = vbasename(fullpath);
	   strcpy(fullpath, dirname);
	   free(dirname);
	   if (stat(fullpath, &buf) == -1)
	   {
	      (void) fprintf(stderr,"\nvexpandpath:\n");
	      (void) fprintf(stderr,"  Error! Unable to expand path:\n\t\
'%s/%s'\n", fullpath, basename);
	      free(basename); return(NULL);
	   }
	}

	if ((buf.st_mode & S_IFMT) != S_IFDIR)
	{
	   /*
	    *  The fullpath is a file not a directory so get the
	    *  path up to the file
	    */
	   dirname  = vdirname(fullpath);
	   basename = vbasename(fullpath);
	   strcpy(fullpath, dirname);
	   free(dirname);
	}

	/*
	 *  Now get the fullpath to the expanded directory.
	 */
	if (getwd(save) == NULL)
	{
	   (void) fprintf(stderr,"\nvexpandpath:\n");
	   (void) fprintf(stderr,"%s\n", save);
	   if (basename != NULL) free(basename);
	   return(NULL);
	}

	if (chdir(fullpath) == -1)
	{
	   (void) fprintf(stderr,"\nvexpandpath:\n");
	   (void) fprintf(stderr,"  Error! Unable to change working directory \
in order to expand path:\n\t'%s'\n", fullpath);
	   fprintf(stderr,"%s\n", save);
	   if (basename != NULL) free(basename);
	   return(NULL);
	}

	if (getwd(dir) == NULL)
	{
	   (void) fprintf(stderr,"\nvexpandpath:\n");
	   (void) fprintf(stderr,"%s\n", save);
	   if (basename != NULL) free(basename);
	   return(NULL);
	}

	if (chdir(save) == -1)
	{
	   (void) fprintf(stderr,"\nvexpandpath:\n");
	   (void) fprintf(stderr,"  Error! Unable to restore working directory \
after expanding the path:\n\t'%s'\n", fullpath);
	   if (basename != NULL) free(basename);
	   return(NULL);
	}

	/*
	 *  If basename is not NULL then we need to cancatenate the basename
	 *  back onto the expanded director.
	 */
	if (basename != NULL)
	{
	   strcat(dir, "/");
	   strcat(dir, basename);
	   free(basename);
	}

	if (return_file != NULL)
	   strcpy(return_file, dir);
	else
	   return_file = VStrcpy(dir);

	return(return_file);
}
