 /*
  * Khoros: $Id: dgsinc.c,v 1.3 1992/03/20 23:18:26 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dgsinc.c,v 1.3 1992/03/20 23:18:26 dkhoros Exp $";
#endif

 /*
  * $Log: dgsinc.c,v $
 * Revision 1.3  1992/03/20  23:18:26  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dgsinc.c
 >>>>
 >>>>      Program Name: dgsinc
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Creates a 1d sinc data set.
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley
 >>>>
 >>>> Date Last Updated: Sat Feb 15 16:31:34 1992
 >>>>
 >>>>          Routines: main- the main program for dgsinc
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dgsinc.h"


/****************************************************************
 *
 * Routine Name:  main program for dgsinc
 *
 *       Input:  
 *        -o  resulting image 
 *
 *
 *        [-i] input value file (xviff file)
 *        [-trigger] trigger input
 *        [-v] number of data sets  (value > 0)
 *        [-n] number of points  (value > 0)
 *        [-s] sampling frequency  (value > 0.0)
 *        [-m] maximum signal level 
 *        [-f] signal frequency  (value > 0.0)
 *        [-b] initial delay  (value >= 0)
 *        [-c] orientation (0 - centered, 1 is left justified
 *        [-d] data processing direction (0 = down vectors, 1 = across bands)
 *        [-t] lets user choose data type of image
 *		'float' (select data type),
 *		 or 'complex' (choose data type)
 *		   [default = float] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */

struct xvimage *image=NULL, *kernel=NULL, *readimage();
int type;

/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  if(check_args())exit(1);
  if(!vget_type(&type,dgsinc->t_toggle)){
     fprintf(stderr,"dgsinc:  Invalid data type specified\n");
     exit(1);
  }

/*
** load kernel if necessary
*/

  if (dgsinc->i_flag) {
    image = readimage(dgsinc->i_file);
    if(image == NULL)
    {
      (void)fprintf(stderr,"dgsinc:  Value file could not be read!\n");
      exit(1);
    }
  }

/* -main_before_lib_call_end */

/* -main_library_call */
  if(!ldgsinc(&image,dgsinc->v_int,dgsinc->n_int,dgsinc->s_float,
             dgsinc->m_float,dgsinc->f_float,dgsinc->b_int,
             dgsinc->c_logic,type,dgsinc->d_logic)){
    (void)fprintf(stderr, "ldgsinc Failed\n");
    exit(1);
  }

/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(dgsinc->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dgsinc 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dgsinc :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCreates a 1d sinc data set.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
fprintf(stderr,"\nThe -t option will accept input in either of two forms:\n");
fprintf(stderr,"  an alphabetic representation, i.e. 'float' or 'complex',\n");
fprintf(stderr,"  or a numeric representation, such as 4 for real.\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-o  resulting image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-i]  input value file (xviff file) (infile) [null]\n");
	fprintf(stderr,"\t[-trigger]  trigger input (infile) [null]\n");
	fprintf(stderr,"\t[-v]  number of data sets (integer, > 0) [1]\n");
	fprintf(stderr,"\t[-n]  number of points (integer, > 0) [256]\n");
	fprintf(stderr,"\t[-s]  sampling frequency (float, > 0.0) [2]\n");
	fprintf(stderr,"\t[-m]  maximum signal level (float) [1]\n");
	fprintf(stderr,"\t[-f]  signal frequency (float, > 0.0) [1]\n");
	fprintf(stderr,"\t[-b]  initial delay (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-c]  orientation (0 - centered, 1 is left justified (boolean) [true]\n");
	fprintf(stderr,"\t[-d]  data processing direction (0 = down vectors, 1 = across bands) (boolean) [true]\n");
	fprintf(stderr, "\t[-t]  lets user choose data type of image\n");
	fprintf(stderr, "\t\t'float'  (select data type),\n");
	fprintf(stderr, "\t\t or 'complex'  (choose data type)\n");
	fprintf(stderr, "\t\t[default = float]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dgsinc\n");
	fprintf(stderr, "\t[-U] Gives the usage for dgsinc\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dgsinc.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dgsinc.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dgsinc
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) resulting image \n        {outfile}: "; 
char	*i_pstr = 
	"\nEnter: (i) input value file (xviff file) \n        {infile}: "; 
char	*trigger_pstr = 
	"\nEnter: (trigger) trigger input \n        {infile}: "; 
char	*v_pstr = 
	"\nEnter: (v) number of data sets \n        {integer, > 0 [1] }: "; 
char	*n_pstr = 
	"\nEnter: (n) number of points \n        {integer, > 0 [256] }: "; 
char	*s_pstr = 
	"\nEnter: (s) sampling frequency \n        {float, > 0.0 [2.000000] }: "; 
char	*m_pstr = 
	"\nEnter: (m) maximum signal level \n        {float [1.000000] }: "; 
char	*f_pstr = 
	"\nEnter: (f) signal frequency \n        {float, > 0.0 [1.000000] }: "; 
char	*b_pstr = 
	"\nEnter: (b) initial delay \n        {integer, >= 0 [0] }: "; 
char	*c_pstr = 
	"\nEnter: (c) orientation (0 - centered, 1 is left justified \n        {boolean, (y/n)  [yes] }: "; 
char	*d_pstr = 
	"\nEnter: (d) data processing direction (0 = down vectors, 1 = across bands) \n        {boolean, (y/n)  [yes] }: "; 
char	*t_pstr = "\nEnter: (t) lets user choose data type of image -- \n      \t\t'float' (select data type)\n\t\tor 'complex' (choose data type)\n  [float]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dgsinc", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dgsinc.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dgsinc: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dgsinc.ans");
		}

	     }

	}

	/*
	 * allocate the dgsinc structure
	 */
	dgsinc = (dgsinc_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dgsinc_struct));

	/*
	 * get required arguments for dgsinc
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dgsinc->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dgsinc->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dgsinc->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dgsinc->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dgsinc->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dgsinc
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dgsinc->i_flag = vget_infile(fid, prompt_flag,
	"-i", i_pstr, &(dgsinc->i_file))
;

	dgsinc->trigger_flag = vget_infile(fid, prompt_flag,
	"-trigger", trigger_pstr, &(dgsinc->trigger_file))
;

	dgsinc->v_flag = vget_int(fid, prompt_flag,
	"-v", v_pstr, &(dgsinc->v_int),
	1, 2, 2);

	dgsinc->n_flag = vget_int(fid, prompt_flag,
	"-n", n_pstr, &(dgsinc->n_int),
	256, 2, 2);

	dgsinc->s_flag = vget_float(fid, prompt_flag,
	"-s", s_pstr, &(dgsinc->s_float),
	2.000000, 2.000000, 2.000000);

	dgsinc->m_flag = vget_float(fid, prompt_flag,
	"-m", m_pstr, &(dgsinc->m_float),
	1.000000, 0.000000, 0.000000);

	dgsinc->f_flag = vget_float(fid, prompt_flag,
	"-f", f_pstr, &(dgsinc->f_float),
	1.000000, 2.000000, 2.000000);

	dgsinc->b_flag = vget_int(fid, prompt_flag,
	"-b", b_pstr, &(dgsinc->b_int),
	0, 1, 1);

	dgsinc->c_flag = vget_logic(fid, prompt_flag,
	"-c", c_pstr, &(dgsinc->c_logic), 1);

	dgsinc->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dgsinc->d_logic), 1);


	/*
	 * get optional toggles for dgsinc
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dgsinc->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(dgsinc->t_toggle),
		"float");

		if (((strcmp(dgsinc->t_toggle, "float") == 0)) || 
		     ((strcmp(dgsinc->t_toggle, "complex") == 0)))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dgsinc->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(dgsinc->t_toggle),
		"float");

		if (((strcmp(dgsinc->t_toggle, "float") != 0)) && 
		     ((strcmp(dgsinc->t_toggle, "complex") != 0)))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



