 /*
  * Khoros: $Id: formatdoc.c,v 1.2 1991/10/01 23:56:49 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: formatdoc.c,v 1.2 1991/10/01 23:56:49 khoros Exp $";
#endif

 /*
  * $Log: formatdoc.c,v $
 * Revision 1.2  1991/10/01  23:56:49  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: formatdoc.c
 >>>>
 >>>>      Program Name: formatdoc
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Format on-line documentation for Khoros
 >>>>	
 >>>>	


 >>>> 
 >>>> Date Last Updated: Wed Sep 25 22:10:39 1991
 >>>>
 >>>>          Routines: main- the main program for formatdoc
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "formatdoc.h"


/****************************************************************
 *
 * Routine Name:  main program for formatdoc
 *
 *       Input:  
 *           -type   
 *		'doc' (Formats a single doc file and places the online document in the current directory),
 *		'alldoc' (Formats all doc files and places the online documents in the current directory),
 *		'help' (Formats a single help files and places the online document in the ./help directory),
 *		 or 'allhelp' (Formats all help files and places the online documents in the ./help directory)
 *		 
 *
 *
 *           [-i] Input documentation file (for -type doc and -type help only)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        char buffer[512];
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (formatdoc->i_flag)
        {
            if ( (strcmp(formatdoc->type, "doc") == 0) ||
                 (strcmp(formatdoc->type, "alldoc") == 0) )
            {
                fprintf(stderr, "formatdoc:\n");
                fprintf(stderr, "ignoring the -i argument\n");
            }
        }
	else
	{
	    formatdoc->i = VStrcpy("_NULL_");
	}
/* -main_before_lib_call_end */

/* -main_library_call */
        sprintf(buffer, "formatdoc_csh %s %s\n", 
                        formatdoc->type, formatdoc->i);
        system(buffer);
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for formatdoc 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "formatdoc :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tFormat on-line documentation for Khoros\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr, "\t-type  ");
	fprintf(stderr, " \n  ");
	fprintf(stderr, "\t\t'doc'  (Formats a single doc file and places the online document in the current directory),\n");
	fprintf(stderr, "\t\t'alldoc'  (Formats all doc files and places the online documents in the current directory),\n");
	fprintf(stderr, "\t\t'help'  (Formats a single help files and places the online document in the ./help directory),\n");
	fprintf(stderr, "\t\t or 'allhelp'  (Formats all help files and places the online documents in the ./help directory)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-i]  Input documentation file (for -type doc and -type help only) (string) [null]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for formatdoc\n");
	fprintf(stderr, "\t[-U] Gives the usage for formatdoc\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called formatdoc.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses formatdoc.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for formatdoc
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*type_pstr = "\nEnter: (type)   -- \n      \t\t'doc' (Formats a single doc file and places the online document in the current directory)\n\t\t'alldoc' (Formats all doc files and places the online documents in the current directory)\n\t\t'help' (Formats a single help files and places the online document in the ./help directory)\n\t\tor 'allhelp' (Formats all help files and places the online documents in the ./help directory)\n     : "; 
char	*i_pstr = 
	"\nEnter: (i) Input documentation file (for -type doc and -type help only) \n        {string}: "; 
char	*i_def = NULL;
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "formatdoc", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "formatdoc.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "formatdoc: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "formatdoc.ans");
		}

	     }

	}

	/*
	 * allocate the formatdoc structure
	 */
	formatdoc = (formatdoc_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (formatdoc_struct));


	/*
	 * get required toggles for formatdoc
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		formatdoc->type_flag = vget_string(fid, prompt_flag,
		"-type", type_pstr, &(formatdoc->type),
		"doc");

		if ((((strcmp(formatdoc->type, "doc") == 0)) || 
		     ((strcmp(formatdoc->type, "alldoc") == 0)) || 
		     ((strcmp(formatdoc->type, "help") == 0)) || 
		     ((strcmp(formatdoc->type, "allhelp") == 0))) &&
		     (formatdoc->type_flag))
		      ok = TRUE;
		else
		{
		    fprintf(stderr, "\ntype is a required argument.\n");
		}
	    }
	}
	else
	{
		formatdoc->type_flag = vget_string(fid, prompt_flag,
		"-type", type_pstr, &(formatdoc->type),
		"doc");

		if ((((strcmp(formatdoc->type, "doc") != 0)) && 
		     ((strcmp(formatdoc->type, "alldoc") != 0)) && 
		     ((strcmp(formatdoc->type, "help") != 0)) && 
		     ((strcmp(formatdoc->type, "allhelp") != 0))) ||
		     (!(formatdoc->type_flag)))
		{
		    fprintf(stderr, "type is a required argument.\n");
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}

	/*
	 * get optional arguments for formatdoc
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	formatdoc->i_flag = vget_string(fid, prompt_flag,
	"-i", i_pstr, &(formatdoc->i),
	i_def);

	if (prompt_flag == FALSE)
	{
	    if ((formatdoc->i_flag == 1)&&(formatdoc->i == NULL))
    	{
		fprintf(stderr, "formatdoc:\n");
		fprintf(stderr, "you must specify a name following '-i'\n");
		gw_usage();
		exit(1);
		}
	}

}



