 /*
  * Khoros: $Id: make.c,v 1.3 1991/12/18 08:54:40 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: make.c,v 1.3 1991/12/18 08:54:40 dkhoros Exp $";
#endif

 /*
  * $Log: make.c,v $
 * Revision 1.3  1991/12/18  08:54:40  dkhoros
 * HellPatch3
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>     file name: make.c                                 <<<<
   >>>>                                                       <<<<
   >>>>   description: The routine in this file creates the   <<<<
   >>>>                Imakefile.                             <<<<
   >>>>                                                       <<<<
   >>>>      routines: imkmf_make                             <<<<
   >>>>                                                       <<<<
   >>>>        author: W. Tait Cyrus -- May 31, 1990          <<<<
   >>>>                                                       <<<<
   >>>> modifications: modified the checks for 
   >>>>                imkmf->name_flag to also check for
   >>>>                imkmf->name_string == NULL. This was
   >>>>                casuing a problem when imkmf was run 
   >>>>                using the -P option. Tom 12/10/91
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "imkmf.h"

imkmf_make() 
{
   char *toolbox_name, *application_name;
   char buffer[512*3];
   
   char *myerror = "You must specify both -type and -name\n";

   if( imkmf->type_flag ) {
      if( strcmp( imkmf->type_toggle, "dir" ) ) {
         if( !imkmf->name_flag || imkmf->name_string == NULL ) {
            Myerror( myerror );
            gw_usage();
            myexit( 1 );
            }
         }
      else {
         if( imkmf->name_flag && imkmf->name_string != NULL ) {
            Myerror( "-name not allowed when -type equals `dir'" );
            gw_usage();
            myexit( 1 );
            }
         }
      }
   else {
      Myerror( myerror );
      gw_usage();
      myexit( 1 );
     }
   fprintf( stderr, "Making %s\n", imkmf->o_file );
   application_name = imkmf->name_string;
   toolbox_name = imkmf->toolbox_string;

   if( !strcmp( imkmf->type_toggle, "dir" ) ) {
      sprintf( buffer, "%s/%s/%s", khoros_home, TEMPLATES, DIRECTORY_TEMPLATE );
      map[ SPECIALLOC ].count++;
      map[ SPECIALLOC ].category = "";

      map[ TBALLOC ].count++;
      map[ TBALLOC ].category = "TOOLBOX";
      addfile( toolbox_name, &(map[ TBALLOC ].files), "" );
      }
   else 
   {
      if( !strcmp( imkmf->type_toggle, "lib" ) ) {
	 sprintf( buffer, "%s/%s/%s", khoros_home, TEMPLATES, LIBRARY_TEMPLATE);
	 map[ SPECIALLOC ].count++;
	 map[ SPECIALLOC ].category = "LIBRARY_NAME";
	 addfile( application_name, &(map[ SPECIALLOC ].files), "" );

         map[ TBALLOC ].count++;
         map[ TBALLOC ].category = "TOOLBOX";
         addfile( toolbox_name, &(map[ TBALLOC ].files), "" );
         }
      else if( !strcmp( imkmf->type_toggle, "prog" ) ) {
	 sprintf( buffer, "%s/%s/%s", khoros_home, TEMPLATES, PROGRAM_TEMPLATE);
	 map[ SPECIALLOC ].count++;
	 map[ SPECIALLOC ].category = "PROGRAM_NAME";
	 addfile( application_name, &(map[ SPECIALLOC ].files), "" );

         map[ TBALLOC ].count++;
         map[ TBALLOC ].category = "TOOLBOX";
         addfile( toolbox_name, &(map[ TBALLOC ].files), "" );
         }
      else if( !strcmp( imkmf->type_toggle, "fprog" ) ) {
	 sprintf( buffer, "%s/%s/%s", khoros_home, TEMPLATES, FOR_PROGRAM_TEMPLATE);
	 map[ SPECIALLOC ].count++;
	 map[ SPECIALLOC ].category = "PROGRAM_NAME";
	 addfile( application_name, &(map[ SPECIALLOC ].files), "" );

         map[ TBALLOC ].count++;
         map[ TBALLOC ].category = "TOOLBOX";
         addfile( toolbox_name, &(map[ TBALLOC ].files), "" );
         }
      else if( !strcmp( imkmf->type_toggle, "xprog" ) ) {
	 sprintf( buffer, "%s/%s/%s", khoros_home, TEMPLATES,XPROGRAM_TEMPLATE);
	 map[ SPECIALLOC ].count++;
	 map[ SPECIALLOC ].category = "PROGRAM_NAME";
	 addfile( application_name, &(map[ SPECIALLOC ].files), "" );

         map[ TBALLOC ].count++;
         map[ TBALLOC ].category = "TOOLBOX";
         addfile( toolbox_name, &(map[ TBALLOC ].files), "" );
         }
      else if( !strcmp( imkmf->type_toggle, "fxprog" ) ) {
	 sprintf( buffer, "%s/%s/%s", khoros_home, TEMPLATES, FOR_XPROGRAM_TEMPLATE);
	 map[ SPECIALLOC ].count++;
	 map[ SPECIALLOC ].category = "PROGRAM_NAME";
	 addfile( application_name, &(map[ SPECIALLOC ].files), "" );

         map[ TBALLOC ].count++;
         map[ TBALLOC ].category = "TOOLBOX";
         addfile( toolbox_name, &(map[ TBALLOC ].files), "" );
         }
      else if( !strcmp( imkmf->type_toggle, "script" ) ) {
	 sprintf( buffer, "%s/%s/%s", khoros_home, TEMPLATES, SCRIPT_TEMPLATE );
	 map[ SPECIALLOC ].count++;
	 map[ SPECIALLOC ].category = "SCRIPT_NAME";
	 addfile( application_name, &(map[ SPECIALLOC ].files), "" );

         map[ TBALLOC ].count++;
         map[ TBALLOC ].category = "TOOLBOX";
         addfile( toolbox_name, &(map[ TBALLOC ].files), "" );
         }
  }
  fprintf( stderr, "Using %s as the template\n", buffer );
  moved = FALSE;
  infile = myfopen( buffer, "r" );
  outfile = myfopen( imkmf->o_file, "w" );
  }



