 /*
  * Khoros: $Id: lvadd.c,v 1.2 1991/10/02 00:22:32 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvadd.c,v 1.2 1991/10/02 00:22:32 khoros Exp $";
#endif

 /*
  * $Log: lvadd.c,v $
 * Revision 1.2  1991/10/02  00:22:32  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvadd.c
 >>>>
 >>>>      Program Name: vadd
 >>>>
 >>>> Date Last Updated: Sat Sep 28 19:01:26 1991 
 >>>>
 >>>>          Routines: lvadd - the library call for vadd
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvadd - library call for vadd
*
* Purpose:
*    
*    Adds two images pixel by  pixel  with  an  operation  gating
*    mask.
*    
*    

* Input:
*    
*    img1           first xvimage structure
*    
*    img2           second xvimage structure
*    
*    img3           gating mask image
*    
*    mflg           a flag set (equal 1) if gating image  mask  avail-
*                   able
*    
*                   Note that all inputs must be of the same data type
*                   and size.
*    
*    

* Output:
*    
*    img1           holds the result of the add operation.  The output
*                   data type is the same as the input data type.
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    

*
* Written By: Scott Wilson
*    
*    Scott Wilson (April 29, 1988)
*    
*    Marcelo Teran, John Rasure, Tom Sauer
*    
*    Scott Wilson (December 28, 1989) - Upgrade to multiband.
*    
*    Jeremy Worley (February 25, 1991) - Added double and double  com-
*    plex processing.
*    
*    

****************************************************************/


/* -library_def */
int
lvadd(img1,img2,img3,mflg)
struct xvimage *img1, *img2, *img3;
int   mflg;
/* -library_def_end */

/* -library_code */
{
    int    j, k;
    int    *i1,*i2,*i3,*i4;
    short  *s1,*s2,*s3,*s4;
    float  *f1,*f2,*f3,*f4;
    double *d1,*d2,*d3,*d4;
    unsigned char *c1,*c2,*c3,*c4;

    switch (img1->data_storage_type)
      {
        case VFF_TYP_BIT :
          fprintf(stderr,"lvadd: Don't know how to add BIT images\n");
          return(0);
          break;

        case VFF_TYP_1_BYTE : 
          k = img1->row_size*img1->col_size*img1->num_data_bands;
          c1 = (unsigned char *)(img1->imagedata);
          c2 = (unsigned char *)(img2->imagedata);
          c3 = (unsigned char *)(img1->imagedata);
          if (mflg) c4 = (unsigned char *)(img3->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++) *c3++ = *c1++ + *c2++;
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*c4++) *c3++ = *c1++ + *c2++;
                  else
                    {
                      c1++; c2++; c3++;
                    }
                }
            }
          break;
 
        case VFF_TYP_2_BYTE :
          k = img1->row_size*img1->col_size*img1->num_data_bands;
          s1 = (short *)(img1->imagedata);
          s2 = (short *)(img2->imagedata);
          s3 = (short *)(img1->imagedata);
          if (mflg) s4 = (short *)(img3->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++) *s3++ = *s1++ + *s2++;
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*s4++) *s3++ = *s1++ + *s2++;
                  else
                    {
                      s1++; s2++; s3++;
                    }
                }
            }
          break;

        case VFF_TYP_4_BYTE :
          k = img1->row_size*img1->col_size*img1->num_data_bands;
          i1 = (int *)(img1->imagedata);
          i2 = (int *)(img2->imagedata);
          i3 = (int *)(img1->imagedata);
          if (mflg) i4 = (int *)(img3->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++) *i3++ = *i1++ + *i2++;
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*i4++) *i3++ = *i1++ + *i2++;
                  else
                    {
                      i1++; i2++; i3++;
                    }
                }
            }
          break;

        case VFF_TYP_FLOAT :
          k = img1->row_size*img1->col_size*img1->num_data_bands;
          f1 = (float *)(img1->imagedata);
          f2 = (float *)(img2->imagedata);
          f3 = (float *)(img1->imagedata);
          if (mflg) f4 = (float *)(img3->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++) *f3++ = *f1++ + *f2++;
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*f4++) *f3++ = *f1++ + *f2++;
                  else
                    {
                      f1++; f2++; f3++;
                    }
                }
            }
          break;

        case VFF_TYP_COMPLEX :
          k = img1->row_size*img1->col_size*img1->num_data_bands;

          f1 = (float *)(img1->imagedata);
          f2 = (float *)(img2->imagedata);
          f3 = (float *)(img1->imagedata);
          if (mflg) f4 = (float *)(img3->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  *f3 = *f1 + *f2;
                  *(f3+1) = *(f1+1) + *(f2+1);
                  f1 += 2; f2 += 2; f3 += 2;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*f4++)
                    {
                      *f3 = *f1 + *f2;
                      *(f3+1) = *(f1+1) + *(f2+1);
                      f1 += 2; f2 += 2; f3 += 2;
                    }
                  else 
                    {
                      f1 += 2; f2 += 2; f3 += 2;
                    }
                  f4++; /* Skip to next real part! */
                }
            }
          break;
        case VFF_TYP_DOUBLE :
          k = img1->row_size*img1->col_size*img1->num_data_bands;
          d1 = (double *)(img1->imagedata);
          d2 = (double *)(img2->imagedata);
          d3 = (double *)(img1->imagedata);
          if (mflg) d4 = (double *)(img3->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++) *d3++ = *d1++ + *d2++;
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*d4++) *d3++ = *d1++ + *d2++;
                  else
                    {
                      d1++; d2++; d3++;
                    }
                }
            }
          break;
        case VFF_TYP_DCOMPLEX :
          k = img1->row_size*img1->col_size*img1->num_data_bands;

          d1 = (double *)(img1->imagedata);
          d2 = (double *)(img2->imagedata);
          d3 = (double *)(img1->imagedata);
          if (mflg) d4 = (double *)(img3->imagedata);
          if (!mflg)
            {
              for (j=0; j<k; j++)
                {
                  *d3 = *d1 + *d2;
                  *(d3+1) = *(d1+1) + *(d2+1);
                  d1 += 2; d2 += 2; d3 += 2;
                }
            }
          else
            {
              for (j=0; j<k; j++)
                {
                  if (*d4++)
                    {
                      *d3 = *d1 + *d2;
                      *(d3+1) = *(d1+1) + *(d2+1);
                      d1 += 2; d2 += 2; d3 += 2;
                    }
                  else 
                    {
                      d1 += 2; d2 += 2; d3 += 2;
                    }
                  d4++; /* Skip to next real part! */
                }
            }
          break;

        default:
          fprintf(stderr,"lvadd: Unknown data storage type, %d\n",img1->data_storage_type);
          return(0);
          break;
      }
      return(1);
}
/* -library_code_end */
