 /*
  * Khoros: $Id: lvmediaxis.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvmediaxis.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvmediaxis.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvmediaxis.c
 >>>>
 >>>>      Program Name: vmediaxis
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:39:58 1991 
 >>>>
 >>>>          Routines: lvmediaxis - the library call for vmediaxis
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvmediaxis - library call for vmediaxis
*
* Purpose:
*    
*    Computes the medial axis transform
*    
*    
* Input:
*    
*         image _ an xvimage structure.
*         wflag _ logical integer.  if  TRUE  the  median  axis  pixel
*         values  is  255, if FALSE the value is the shortest distance
*         to the region outline itself. will
*    
*    
* Output:
*    
*         image _ holds the result median axis image.
*    
*    
*
* Written By: Pascal ADAM
*    
*    Ghosted by Pascal ADAM  -  Mon  Jun   4  09:22:26  MDT  1990
*    Modification    of    description   in   lvmediaxis(3)   and
*    vmediaxis(1)
*    
*    
****************************************************************/


/* -library_def */
int
lvmediaxis(image,wflag)
struct xvimage *image;
int wflag;
/* -library_def_end */

/* -library_code */
{
    unsigned char *im0;
    unsigned char *cptr, *cptr0;

    int i, j, nc, nr, val;

    int max;
 
    char   *program = "lvmediaxis";

    /* Check type,... of image */
    if (!(propertype(program, image, VFF_TYP_1_BYTE, FALSE))) {
        (void) fprintf (stderr, "\n\n%s:   ", program);
        (void) fprintf (stderr, "lvmskeleton: image must be of type byte\n");
        return (0);
    }
    if (!(proper_num_images (program, image, 1, FALSE))) {
        (void) fprintf (stderr, "\n\n%s:   ", program);
        (void) fprintf (stderr, "Can only work on files with one image\n\n");
        return (0);
    }
    if (!(proper_num_bands (program, image, 1, FALSE))) {
        (void) fprintf (stderr,"\n\n%s:   ", program);
        (void) fprintf (stderr,"Can only work on images with 1 data band\n\n");
        return (0);
    }

    nr = image->col_size;
    nc = image->row_size;


    /* dynamic memory allocation for temporary im0 stockage */
    im0 = (unsigned char *) malloc( nc * nr *sizeof(unsigned char));
    if (im0 == NULL) {
        (void) fprintf (stderr, "\n%s:   ", program);
        (void) fprintf (stderr, "Insufficient Space avaliable\n");
        return(0);
    }

 
    if(! lvdistance(image))
    {
        (void) fprintf(stderr, "vmediaxis : lvdistance Failed\n");
        return(0);
    }

    cptr   = (unsigned char *) image->imagedata;
    cptr0  = im0;
 
    for (i=1;i<nr-1;i++)
    {
        for (j=1;j<nc-1;j++)
        { 
            val = *(cptr+i*nc+j);
            if (val == 0) *(cptr+i*nc+j) = 0;
            else
            {
               max = *(cptr+(i-1)*nc+j);
               if (max < *(cptr+(i+1)*nc+j)) max = *(cptr+(i+1)*nc+j);
               if (max < *(cptr+i*nc+j+1))   max = *(cptr+i*nc+j+1);
               if (max < *(cptr+i*nc+j-1))   max = *(cptr+i*nc+j-1);
            
               if  (max <= val)  
                   *(cptr0+i*nc+j)=(wflag==1)? 255: *(cptr+i*nc+j);

               else  *(cptr0+i*nc+j) = 0; 
            }

        }
    }
    
    for (i=0;i<nr;i++) *(cptr0+i*nc) = *(cptr0+i*nc+nc-1)   = 0;
    for (j=0;j<nc;j++) *(cptr0+j)    = *(cptr0+(nr-1)*nc+j) = 0;
        
    cptr   = (unsigned char *) image->imagedata;
    cptr0  = im0;

    for (i=0; i< nc*nr ;i++)  *cptr++ = *cptr0++;

    free(im0);

    return(1);
        
}
/* -library_code_end */
