 /*
  * Khoros: $Id: lvpolygon.c,v 1.3 1992/03/20 23:07:10 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvpolygon.c,v 1.3 1992/03/20 23:07:10 dkhoros Exp $";
#endif

 /*
  * $Log: lvpolygon.c,v $
 * Revision 1.3  1992/03/20  23:07:10  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvpolygon.c
 >>>>
 >>>>      Program Name: vpolygon
 >>>>
 >>>> Date Last Updated: Thu Mar 12 09:36:29 1992 
 >>>>
 >>>>          Routines: lvpolygon - the library call for vpolygon
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
#include "vipl/lvpolygon.h"
#include "vmath.h"
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvpolygon - library call for vpolygon
*
* Purpose:
*    
*    Creates  a  vector  image   resulting   from   a   polygonal
*    approximation.
*    
*    

* Input:
*    
*         image -- xvimage structure of edge image (input image)
*    
*         seuil -- double of threshold value for approximation error.
*    
*         coef -- double of percentage line length that is rejected.
*    
*         longmin -- integer of minimal length for skipping  over  too
*         small straigth lines.
*    
*    

* Output:
*    
*         image -- xvimage structure of 2D image to display the result
*         of linear approximation.
*    
*         vector -- xvimage structure of output vector image.
*    
*    

*
* Written By: Jean-Pierre COCQUEREZ, Marc VIALA, Pascal ADAM
*    
*    This code needs a lot of work.  I modified the drawligne  routine
*    as  suggested  by Bruno Orsier.  I sabered the code and removed a
*    lot of unused variables.  The driver was also modified to  remove
*    un needed code.  John Rasure Thu Nov 14 16:31:22 MST 1991
*    
*    

****************************************************************/


/* -library_def */
int lvpolygon(image,vector,seuil,coef,longmin)
struct xvimage *image,
               **vector;

int            longmin;
double         coef,
               seuil;
/* -library_def_end */

/* -library_code */
{
#define WHITE  (unsigned char)255

unsigned char  *im;

int            dimx,
               dimy,
               x,
               y,
               nb_seg,
               *vect;
int            test;
int            automate();
S_SEGMENT      *tab_seg, *cur_seg;

struct xvimage *createimage();
void           drawligne();


   dimx = (int)image->row_size;
   dimy = (int)image->col_size;

   im = (unsigned char *)image->imagedata;
   /* dynamic memory allocation for the first segment */
   tab_seg = (S_SEGMENT *) malloc(sizeof(S_SEGMENT));
   if (tab_seg == (S_SEGMENT *)NULL)
   {
      (void) fprintf (stderr,
      "lvpolygon: Couldn't Allocate Memory for Tab_seg!\n\n");
      return(1);
   }
   tab_seg->next = NULL;

   cur_seg = tab_seg;
   nb_seg = 0;

   /* balayage horizontal */

   for(y=1;y<=dimy;y++)
   {
      for(x=1;x<=dimx;x++)
      {
         if (im[(x-1)+(y-1)*dimx] == WHITE)
         {
            test = automate(image, &cur_seg, &nb_seg,
                     x, y, (int)5,
                     (int)1, seuil,
                     longmin, coef);
            if (test)
            {
               (void) fprintf (stderr,
               "lvpolygon: automate() Couldn't Allocate Memory for pile structure!\n\n");
               return(1);
            }
            test = automate(image, &cur_seg, &nb_seg,
                     x, y, (int)6,
                     (int)1, seuil,
                     longmin ,coef);
            if (test)
            {
               (void) fprintf (stderr,
               "lvpolygon: automate() Couldn't Allocate Memory for pile structure!\n\n");
               return(1);
            }
            test = automate(image, &cur_seg, &nb_seg,
                     x, y, (int)7,
                     (int)1, seuil,
                     longmin, coef);
            if (test)
            {
               (void) fprintf (stderr,
               "lvpolygon: automate() Couldn't Allocate Memory for pile structure!\n\n");
               return(1);
            }
         }
      }
   }

   /* balayage vertical */

   for(x=1;x<=dimx;x++)
   {
      for(y=1;y<=dimy;y++)
      {
         if (im[(x-1)+(y-1)*dimx] == WHITE )
         {
            test = automate(image,&cur_seg,&nb_seg,
                     x,y,(int)7,
                     (int)2,seuil,
                     longmin,coef);
            if (test)
            {
               (void) fprintf (stderr,
               "lvpolygon: automate() Couldn't Allocate Memory for pile structure!\n\n");
               return(1);
            }
            test = automate(image,&cur_seg,&nb_seg,
                     x,y,(int)0,
                     (int)2,seuil,
                     longmin,coef);
            if (test)
            {
               (void) fprintf (stderr,
               "lvpolygon: automate() Couldn't Allocate Memory for pile structure!\n\n");
               return(1);
            }
            test = automate(image,&cur_seg,&nb_seg,
                     x,y,(int)1,
                     (int)2,seuil,
                     longmin,coef);
            if (test)
            {
               (void) fprintf (stderr,
               "lvpolygon: automate() Couldn't Allocate Memory for pile structure!\n\n");
               return(1);
            }
         }
      }
   }

   /* create vector image */
   *vector = createimage(nb_seg,
                        1,
                        VFF_TYP_4_BYTE,
                        1,
                        4,
                        "Segment FILE",
                        0,
                        0,
                        VFF_MS_NONE,
                        VFF_MAPTYP_NONE,
                        VFF_LOC_IMPLICIT,
                        1);
   if (*vector == NULL)
   {
      (void) fprintf (stderr,
      "lvpolygon: Couldn't Allocate Memory for vector image!\n\n");
      return(1);
   }

   /* Create image with black background and white polygons */
   /* in the same xvimage struct : image .................. */
   for (x = 0; x < image->row_size *image->col_size;x++)
       image->imagedata[x]= 0;

   cur_seg = tab_seg;
   vect = (int *) (*vector)->imagedata;

   for (x=0;x < nb_seg;x++)
   {
       vect[x]          = cur_seg->x1;
       vect[x+nb_seg]   = cur_seg->y1;
       vect[x+2*nb_seg] = cur_seg->x2;
       vect[x+3*nb_seg] = cur_seg->y2;

       (void) drawligne((unsigned short)(cur_seg->x1),
                        (unsigned short)(cur_seg->y1),
                        (unsigned short)(cur_seg->x2),
                        (unsigned short)(cur_seg->y2),
                        (unsigned char *)(image->imagedata),
                        (unsigned short)(image->row_size),
                        (unsigned short)(image->col_size),
                        WHITE);
       cur_seg          = cur_seg->next;
   }



   return(0);
}

/***************************************************
*  Subfile: poly.c
*
*  Contains subroutines:
*                drawligne()
*                automate()
*
***************************************************/

#define MOD(x,modulo)\
        (int)(((int)x < (int)modulo) ?   \
                                    (int)x : \
                                    (int)x%(int)modulo)
#define k 2
#define x0 1
#define y0 1


/* draws a line between (a1,b1) and (a2,b2) in the image data pointed */
/* by the color of this line is color ............................... */
void drawligne(a1,b1,a2,b2,ptr,nc,nr,color)
unsigned short a1,b1,a2,b2,nr,nc;
unsigned char color;
unsigned char *ptr;
{
float slope;
float deb;

int row, col;

if (a1 == a2) {
    for (row = (int) MIN(b1,b2); row <= (int) MAX(b1,b2); row++) {
        col = (int) a1;
        ptr[row * (int)nc + col] = color;
    }
}
else {

    /* the equation of the line segment is : y = slope * x + deb . */
    slope = ((float)b1 - (float)b2) / ((float)a1 - (float)a2);
    deb   = ((float) a1 * (float) b2 - (float) a2 * (float) b1) /
               ((float)a1 - (float)a2);

    /* to draw line we must take care of slope .... 2 cases . */
    if ((slope < 1.0) && (slope > -1.0)) {
        for (col = (int) MIN(a1,a2); col <= (int) MAX(a1,a2); col++) {
            row  = (int) ( (float) ( (float)(col) * slope  + deb ) );
            ptr[row *(int) nc + col] = color;
        }
    }
    else {
        for (row = (int) MIN(b1,b2); row <= (int) MAX(b1,b2); row++ ) {
            col = (int) (((float)row - deb) / slope) ;
            ptr[row * (int)nc + col] = color;
        }
    }
}
}

int automate(image,ptr_seg,nbseg,x,y,dirp,balay,seuil,longmin,coef)
   struct xvimage *image;
   S_SEGMENT **ptr_seg;
   int x, y, dirp, balay, longmin, *nbseg;
   double         seuil, coef;
{
   unsigned char   *im;
   unsigned char   point_sui;
   int             x_depart, y_depart, xj, yj, cpt[8], cpt_dir[8],
                   direc[4], succ[5], dirs1, dirs2, dirs3, dir_auto,
                    dir1_cont, dir2_cont, long_chemin, securite, i,
                    lgchemin, nbdir_i, alfa, sup_dir, point_im,
                    ctrl_0, ctrl_1, ctrl_2, ctrl_3, dimx, dimy, bout;

   double          sumx,sumy,sumx2,sumy2,sumxy;

   static int    dx[8]={ 1, 1, 0, -1, -1, -1, 0, 1};
   static int    dy[8]={ 0, -1, -1, -1, 0, 1, 1, 1};
   double          A,B,s,sigema_x,sigema_y,lon;
   double          teta1,teta2,ro1,ro2,d1,d2,d,ro,teta,d_point;
   S_PILE_XY       *pile_auto, *cur_pile, *tmp_pile;


   /* initialisation of image data pointer */
   im = (unsigned char *)image->imagedata;
   dimx = (int) image->row_size;
   dimy = (int) image->col_size;

   /* initialisation des variables de controle du programme */
   ctrl_0= ctrl_2= ctrl_1= ctrl_3= 1;

   /* sauvegarde du point de depart */
   x_depart=(int)x;
   y_depart=(int)y;

   /* initialisation de cpt,cpt_dir,long_chemin du parcours */
   /* des erreurs moyennes quadratiques                     */
   pile_auto=(S_PILE_XY *) malloc(sizeof(S_PILE_XY));
   if (pile_auto == NULL) return(1);
   pile_auto -> next = NULL;

   cur_pile = pile_auto;

   long_chemin=0;

   sumx= sumy= sumx2= sumy2= sumxy=0.0;

   for (i=0;i<=7;i++)
   {
      cpt[i]= cpt_dir[i]=0;
   }

   /* debut de la pile */
   cur_pile->x=x;
   cur_pile->y=y;

   alfa=1;
   i=0;

   /*  calcul de dirs1 et dirs2 */
   dirs1=MOD((dirp+1),8);
   dirs2=MOD((dirp+7),8);
   dirs3= -1;


   while (long_chemin < k  && ctrl_0 != -1)
   {
      /* il existe un successeur (xj,yj) de (x,y) ? */
      direc[0]=dirp;
      direc[1]=dirs1;
      direc[2]=dirs2;
      direc[3]=dirs3;
      ctrl_1=1;
      while ( ctrl_1 != -1 )
      {
         xj=x+dx[direc[i]];
         yj=y+dy[direc[i]];
         point_sui=im[(xj-1)+(yj-1)*dimx];
         securite= ((xj >= (int)x0)   &&
                    (xj <= dimx)        &&
                    (yj >= (int)y0)   &&
                    (yj <= dimy)        );
         if ((securite) && (point_sui == (unsigned char)255) )
         {
            dir_auto=direc[i];
            dir1_cont=direc[i];
            dir2_cont=MOD((direc[i]+4),8);
            sumx  =  sumx+(double)xj-(double)dimx/(double)2.0+(double)x0;
            sumy  =  sumy+(double)yj-dimy/(double)2.0+(double)y0;
            sumx2 =  sumx2+((double)xj-(double)dimx/(double)2.0+
                      (double)x0)*((double)xj-(double)dimx/(double)2.0+(double)x0);
            sumy2 =  sumy2+((double)yj-(double)dimy/(double)2.0+
                      (double)y0)*((double)yj-(double)dimy/(double)2.0+(double)y0);
            sumxy =  sumxy+((double)xj-(double)dimx/(double)2.0+
                      (double)x0)*((double)yj-(double)dimy/(double)2.0+(double)y0);
            ++cpt_dir[dir_auto];
            ++cpt[dir1_cont];
            ++cpt[dir2_cont];
            ++long_chemin;
            cur_pile->next = (S_PILE_XY *)malloc(sizeof(S_PILE_XY));
            if (cur_pile->next == NULL) return(1);
            cur_pile = cur_pile->next;
            cur_pile->next = NULL;
            cur_pile->x=xj;
            cur_pile->y=yj;
            x=xj;
            y=yj;
            ctrl_1 = -1;
            i = 0;
         }
         else
         {
            ++i;
            if( i > 2 ) ctrl_1 = ctrl_0 = ctrl_2 = -1;
         }
      }
   }

   /* calcul de dirs3 au k ieme point */
    if (long_chemin == k )
    {
       if(cpt_dir[dirs1] > cpt_dir[dirs2]) dirs3=MOD((dirs1+1),8);
       else dirs3=MOD((dirs2+7),8);
       direc[3]=dirs3;
    }

    /* long_chemin >=k */
    direc[0]=dirp;
    direc[1]=dirs1;
    direc[2]=dirs2;
    direc[3]=dirs3;

    while ( ctrl_2 != -1 )
    {
       /* selection du successeurs dans la direction + rencontre */
       while ( ctrl_3 != -1 )
       {
          nbdir_i = 0;
          for (i=0;i<=3;i++)
          {
             xj=x+dx[direc[i]];
             yj=y+dy[direc[i]];
             point_sui=im[(xj-1)+(yj-1)*dimx];
             securite= ((xj >= (int)x0) &&
                        (xj <= dimx)      &&
                        (yj >= (int)y0) &&
                        (yj <= dimy)        );
             if ((securite) && (point_sui == (unsigned char)255))
             {
                ++nbdir_i;
                succ[nbdir_i]=direc[i];
             }
             else if (i==3 && nbdir_i==0 ) ctrl_3 = -1;
          }
          if (nbdir_i >= 1)
          {
             sup_dir=cpt[succ[1]];
             for (i=1;i<=nbdir_i;i++)
             {
                if (cpt[succ[i]] >= sup_dir )
                {
                   sup_dir=cpt[succ[i]];
                   dir1_cont=succ[i];
                }
             }
             dir_auto=dir1_cont;

             /* successeur associe */
             xj=x+dx[dir_auto];
             yj=y+dy[dir_auto];

             /* linearisation du parcours. calcul de l'EMQ (s) */
             sumx  =  sumx+(double)xj-(double)dimx/2.0+(double)x0;
             sumy  =  sumy+(double)yj-dimy/2.0+(double)y0;
             sumx2 =  sumx2+((double)xj-(double)dimx/2.0+
                      (double)x0)*((double)xj-(double)dimx/2.0+(double)x0);
             sumy2 =  sumy2+((double)yj-(double)dimy/2.0+
                      (double)y0)*((double)yj-(double)dimy/2.0+(double)y0);
             sumxy =  sumxy+((double)xj-(double)dimx/2.0+
                      (double)x0)*((double)yj-(double)dimy/2.0+(double)y0);
             lon=(double)(long_chemin+1);
             A = sumxy-sumx*sumy/lon;
             if (A == 0.0)
             {
                sigema_x= sumx2/lon-(sumx/lon)*(sumx/lon);
                sigema_y= sumy2/lon-(sumy/lon)*(sumy/lon);
                if (sigema_x > sigema_y )
                {
                   teta1= XV_PI_2;
                   teta2= -teta1;
                }
                else
                {
                   teta1= 0;
                   teta2= 0;
                }
             }
             else
             {
                B= sumy2-sumx2+(sumx*sumx-sumy*sumy)/lon;
                teta1= atan((B+sqrt(B*B+4.0*A*A))/(2.0*A));
                teta2= atan((B-sqrt(B*B+4.0*A*A))/(2.0*A));
             }
             ro1= (sumx*cos(teta1)+sumy*sin(teta1))/lon;
             ro2= (sumx*cos(teta2)+sumy*sin(teta2))/lon;

             d1= fabs(lon*ro1*ro1+cos(teta1)*cos(teta1)*sumx2
                      +sin(teta1)*sin(teta1)*sumy2-2.0*ro1*cos(teta1)*sumx
                      -2.0*ro1*sin(teta1)*sumy+2*sin(teta1)*cos(teta1)*sumxy);
             d2= fabs(lon*ro2*ro2+cos(teta2)*cos(teta2)*sumx2
                      +sin(teta2)*sin(teta2)*sumy2-2.0*ro2*cos(teta2)*sumx
                      -2.0*ro2*sin(teta2)*sumy+2*sin(teta2)*cos(teta2)*sumxy);

             if (d1 < d2)
             {
                d=d1;
                ro=ro1;
                teta=teta1;
             }
             else
             {
                d=d2;
                ro=ro2;
                teta=teta2;
             }
             /* qualification de l'orientation au (k+1) ieme point */
             if (long_chemin == (k+1))
             {
                if (balay == 1)
                {
                   if( teta >= (-XV_PI_4) && teta<=(XV_PI_4) ) alfa=1;
                   else alfa=0;
                }
                else
                {
                   if ((teta>=(-XV_PI_2) && teta<(-XV_PI_4)) ||
                       (teta>(XV_PI_4) && teta<=(XV_PI_2)) )     alfa=1;
                   else alfa=0;
                }
             }
             if (alfa==0)
             {
                ctrl_2= -1;
                ctrl_3= -1;
             }
             /* calcul des erreurs moyennes */
             s= sqrt(d/lon);

             /* erreur s <= seuil ? si oui,sauvegarde dans la pile  */
             /* et mise a jour des compteurs                        */
             if (s<=seuil)
             {
                dir2_cont=MOD((dir1_cont+4),8);
                ++long_chemin;
                cur_pile->next = (S_PILE_XY *)malloc(sizeof(S_PILE_XY));
                if (cur_pile->next == NULL) return(1);
                cur_pile = cur_pile->next;
                cur_pile->next = NULL;
                cur_pile->x =xj;
                cur_pile->y =yj;
                ++cpt[dir1_cont];
                ++cpt[dir2_cont];
                ++cpt_dir[dir_auto];
                x=xj;
                y=yj;
             }
             else ctrl_3= -1;
          }
       }
       /* qualification du chemin */
       if (long_chemin>=longmin && ctrl_2 != -1)
       {

          /***** recalcul de ro et teta **************************/
          bout=long_chemin*coef; /* bout:bout segment a suprimer */

          sumx= sumy= sumx2= sumy2= sumxy=0.0;
          lgchemin=0;
          cur_pile = pile_auto;
          for (i = 0; i < bout; i++) cur_pile = cur_pile->next;
          for (i=bout;i<long_chemin-bout;++i)
          { /*deb a*/
             xj = cur_pile->x -1; yj = cur_pile->y -1;
             sumx  =  sumx+(double)xj-(double)dimx/2.0+(double)x0;
             sumy  =  sumy+(double)yj-dimy/2.0+(double)y0;
             sumx2 =  sumx2+((double)xj-(double)dimx/2.0+
                      (double)x0)*((double)xj-(double)dimx/2.0+(double)x0);
             sumy2 =  sumy2+((double)yj-(double)dimy/2.0+
                      (double)y0)*((double)yj-(double)dimy/2.0+(double)y0);
             sumxy =  sumxy+((double)xj-(double)dimx/2.0+
                      (double)x0)*((double)yj-(double)dimy/2.0+(double)y0);
             lon=(double)(lgchemin+1);    /*??????????????*/
             A= sumxy-sumx*sumy/lon;
             if (A == 0 )
             {
                sigema_x= sumx2/lon-(sumx/lon)*(sumx/lon);
                sigema_y= sumy2/lon-(sumy/lon)*(sumy/lon);
                if (sigema_x > sigema_y )
                {
                   teta1= XV_PI_2;
                   teta2= -teta1;
                }
                else
                {
                   teta1= 0;
                   teta2= 0;
                }
             }
             else
             {
                B= sumy2-sumx2+(sumx*sumx-sumy*sumy)/lon;
                teta1= atan((B+sqrt(B*B+4.0*A*A))/(2.0*A));
                teta2= atan((B-sqrt(B*B+4.0*A*A))/(2.0*A));
             }
             ro1= (sumx*cos(teta1)+sumy*sin(teta1))/lon;
             ro2= (sumx*cos(teta2)+sumy*sin(teta2))/lon;
             d1= fabs(lon*ro1*ro1+cos(teta1)*cos(teta1)*sumx2
                      +sin(teta1)*sin(teta1)*sumy2-2.0*ro1*cos(teta1)*sumx
                      -2.0*ro1*sin(teta1)*sumy+2*sin(teta1)*cos(teta1)*sumxy);
             d2= fabs(lon*ro2*ro2+cos(teta2)*cos(teta2)*sumx2
                       +sin(teta2)*sin(teta2)*sumy2-2.0*ro2*cos(teta2)*sumx
                      -2.0*ro2*sin(teta2)*sumy+2.0*sin(teta2)*cos(teta2)*sumxy);

             if (d1 < d2)
             {
                /* qualification du chemin */
                d=d1;
                ro=ro1;
                teta=teta1;
             }
             else
             {
                d=d2;
                ro=ro2;
                teta=teta2;
             }

             ++lgchemin;
             cur_pile = cur_pile->next;
          } /* fin a */

          /*** fin de recalcul de ro et teta ***********************/

          /* marquage */
          cur_pile = pile_auto;
          cur_pile = cur_pile->next->next;
          for (i=2;i<long_chemin-1;i++)
          {
             point_im=(cur_pile->x -1)+(cur_pile->y -1)*dimx;
             im[point_im] = (unsigned char)0;
             cur_pile = cur_pile->next;
          }

          /* projection du segment de droite */
          cur_pile = pile_auto->next;
          d_point  = ro-(cur_pile->x-(double)dimx/2.0+(double)x0)*cos(teta)
                    -(cur_pile->y-(double)dimy/2.0+(double)y0)*sin(teta);
          (*ptr_seg)->x1= cur_pile->x + (int)(d_point*cos(teta)+(double)0.5);
          (*ptr_seg)->y1= cur_pile->y + (int)(d_point*sin(teta)+(double)0.5);

          cur_pile = pile_auto;
          while (cur_pile->next != NULL) cur_pile = cur_pile->next;

          d_point = ro-((double)cur_pile->x-(double)dimx/2.0+(double)x0)*cos(teta)
                   -((double)cur_pile->y-(double)dimy/2.0+(double)y0)*sin(teta);
          (*ptr_seg)->x2= cur_pile->x+(int)(d_point*cos(teta)+(double)0.5);
          (*ptr_seg)->y2= cur_pile->y+(int)(d_point*sin(teta)+(double)0.5);

          (*nbseg)++;

          (*ptr_seg)->next = (S_SEGMENT *) malloc(sizeof(S_SEGMENT));
          (*ptr_seg) = (*ptr_seg)->next;
          if ((*ptr_seg) == NULL) return(1);
          (*ptr_seg)->next = NULL;
          ctrl_2= -1;
       }
       ctrl_2= -1;
    }

    cur_pile = pile_auto;
    while (cur_pile->next != NULL)
    {
       tmp_pile = cur_pile->next;
       free((char *)cur_pile);
       cur_pile = tmp_pile;
    }
    free((char *)cur_pile);
    x=x_depart;
    y=y_depart;

    return(0);
}
/****************** End of Subfile: poly.c ********************/

/* -library_code_end */
