 /*
  * Khoros: $Id: lvtexture.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvtexture.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvtexture.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvtexture.c
 >>>>
 >>>>      Program Name: vtexture
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:27:28 1991 
 >>>>
 >>>>          Routines: lvtexture - the library call for vtexture
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
#include "vipl/lvtexture.h"
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvtexture - library call for vtexture
*
* Purpose:
*    
*    Texture feature extraction using LAW metrics.
*    
*    
* Input:
*    
*    image          the input xvimage image structure.
*    
*    
* Output:
*    
*    image          the resulting output image structure.
*    
*    
*
* Written By: Charlie Gage
*    
*    
****************************************************************/


/* -library_def */
int
lvtexture(img1, L5L5, L5E5, L5S5, L5W5, L5R5, E5L5, E5E5, E5S5, E5W5, E5R5, S5L5, S5E5, S5S5, S5W5, S5R5, W5L5, W5E5, W5S5, W5W5, W5R5, R5L5, R5E5, R5S5, R5W5, R5R5)
struct xvimage *img1;
int  
L5L5, L5E5, L5S5, L5W5, L5R5, E5L5, E5E5, E5S5, E5W5, E5R5, S5L5, S5E5, S5S5, S5W5, S5R5, W5L5, W5E5, W5S5, W5W5, W5R5, R5L5, R5E5, R5S5, R5W5, R5R5;
/* -library_def_end */

/* -library_code */
{
    struct xvimage  *img2, *kernal, *createimage();

    int   i,
          nb,
          nr,
          nc,
          band_num,
          img_size;

    int   dsize, dcount, msize, mcount, lsize, lcount;

    unsigned char  *result,
                   *data_ptr;
    
    unsigned int   flag[25];

    char  *malloc(),                   /* function definition */
          *program = "lvtexture";      /* contains the library name */

     /* check for proper input image type */
if ((img1->data_storage_type == VFF_TYP_BIT) || (img1->data_storage_type == VFF_TYP_COMPLEX) ) 
 {
   (void) fprintf (stderr,"lvtexture: ERROR Input image must be of data type BYTE or FLOAT\n");
   return (0);
 }

     /* input image can only have one image */
if (! (proper_num_images(program, img1, 1, FALSE))) {
   (void) fprintf (stderr,"%s: ERROR All inputs must contain only one image\n", program);
   return(0);
 }

     /* input image can only have one data band */
if (! (proper_num_bands(program, img1, 1, FALSE))) {
   (void) fprintf(stderr,"%s: ERROR Input image must contain only one data band\n", program);
   return(0);
 }

     /* must have map enable set to OPTIONAL */
if (! (proper_map_enable(program, img1, VFF_MAP_OPTIONAL, FALSE))) {
   (void) fprintf(stderr, "%s: ERROR Input image must have map enable type OPTIONAL\n", program);
    return(0);
 }

     /* convert input image to INTEGER if it is BYTE or SHORT */
if ((img1->data_storage_type == VFF_TYP_1_BYTE) || (img1->data_storage_type == VFF_TYP_2_BYTE))
{
  if (!lvconvert(img1, 4, 0, 1, 0.0, 1.0,0))
  {
      (void) fprintf (stderr,"lvtexture: ERROR, Input image could not be ");
      (void) fprintf (stderr,"converted to data type INTEGER\n");
      return(0);
  }
}

  /* Determine image size */
 nr = img1->col_size;                    /* number of rows in image */
 nc = img1->row_size;                    /* number of cols in image */

 /* zero out flags */
 bzero(flag, 25 * sizeof(unsigned int));
 nb = 0;
 band_num = 0;

 /* Determine number of output bands and which bands are requested */
 if (L5L5 == 1) {
    nb++;
    flag[0] = 1;                    /* set flag for mask L5L5 */
 }
 if (L5E5 == 1) {
    nb++;
    flag[1] = 1;                    /* set flag for mask L5E5 */
 }
 if (L5S5 == 1) {
    nb++;
    flag[2] = 1;                    /* set flag for mask L5S5 */
 }
 if (L5W5 == 1) {
    nb++;
    flag[3] = 1;                    /* set flag for mask L5W5 */
 }
 if (L5R5 == 1) {
    nb++;
    flag[4] = 1;                    /* set flag for mask L5R5 */
 }
 if (E5L5 == 1) {
    nb++;
    flag[5] = 1;                    /* set flag for mask E5L5 */
 }
 if (E5E5 == 1) {
    nb++;
    flag[6] = 1;                    /* set flag for mask E5E5 */
 }
 if (E5S5 == 1) {
    nb++;
    flag[7] = 1;                    /* set flag for mask E5S5 */
 }
 if (E5W5 == 1) {
    nb++;
    flag[8] = 1;                    /* set flag for mask E5W5 */
 }
 if (E5R5 == 1) {
    nb++;
    flag[9] = 1;                    /* set flag for mask E5R5 */
 }
 if (S5L5 == 1) {
    nb++;
    flag[10] = 1;                    /* set flag for mask S5L5 */
 }
 if (S5E5 == 1) {
    nb++;
    flag[11] = 1;                    /* set flag for mask S5E5 */
 }
 if (S5S5 == 1) {
    nb++;
    flag[12] = 1;                    /* set flag for mask S5S5 */
 }
 if (S5W5 == 1) {
    nb++;
    flag[13] = 1;                    /* set flag for mask S5W5 */
 }
 if (S5R5 == 1) {
    nb++;
    flag[14] = 1;                    /* set flag for mask S5R5 */
 }
 if (W5L5 == 1) {
    nb++;
    flag[15] = 1;                    /* set flag for mask W5L5 */
 }
 if (W5E5 == 1) {
    nb++;
    flag[16] = 1;                    /* set flag for mask W5E5 */
 }
 if (W5S5 == 1) {
    nb++;
    flag[17] = 1;                    /* set flag for mask W5S5 */
 }
 if (W5W5 == 1) {
    nb++;
    flag[18] = 1;                    /* set flag for mask W5W5 */
 }
 if (W5R5 == 1) {
    nb++;
    flag[19] = 1;                    /* set flag for mask W5R5 */
 }
 if (R5L5 == 1) {
    nb++;
    flag[20] = 1;                    /* set flag for mask R5L5 */
 }
 if (R5E5 == 1) {
    nb++;
    flag[21] = 1;                    /* set flag for mask R5E5 */
 }
 if (R5S5 == 1) {
    nb++;
    flag[22] = 1;                    /* set flag for mask R5S5 */
 }
 if (R5W5 == 1) {
    nb++;
    flag[23] = 1;                    /* set flag for mask R5W5 */
 }
 if (R5R5 == 1) {
    nb++;
    flag[24] = 1;                    /* set flag for mask R5R5 */
 }


  /* Determine storage type of input image and allocate space for resulting
       output image according to input image data_storage_type  */
  if(!(imagesize(img1, &dsize, &dcount, &msize, &mcount, &lsize, &lcount)))
  {
    (void) fprintf(stderr,"lvtexture: Error, imagesize failed\n");
    return(0);
  }
  img_size = dsize;     /* set size of image according to data_storage_type */

  result = (unsigned char *) malloc((unsigned int)img_size * nb);
  if (result == NULL)
  {
    (void) fprintf(stderr,"lvtexture: Error, insufficient memory available\n");
    return(0);
  }

  /* Call lvextract to make a copy of the input image */
  if (lvextract(img1, &img2, nc, nr, 0, 0, TRUE) == NULL)
  {
    (void)fprintf(stderr,"lvtexture: Unable to extract new image!\n");
    return(0);
  }

  /* Convert the texture mask to an image for convolving with input image */
  /* create an image header for the texture kernal */
kernal = createimage((unsigned long) 5,       /* number of rows in kernal */
                     (unsigned long) 5,       /* number of columns in kernal */
                     (unsigned long)
                     VFF_TYP_4_BYTE,          /* data_storage_type */
                     (unsigned long) 1,       /* num_of_images */ 
                     (unsigned long) 1,       /* num_data_bands */ 
                     "created by vtexture",       /* comment */
                     (unsigned long) 0,       /* map_row_size */
                     (unsigned long) 0,       /* map_col_size */
                     (unsigned long)
                     VFF_MS_NONE,             /* map_scheme */
                     (unsigned long)
                     VFF_MAPTYP_NONE,         /* map_storage_type */
                     (unsigned long)
                     VFF_LOC_IMPLICIT,        /* location_type */
                     (unsigned long) 0);      /* location_dim */

  if (kernal == NULL)
  {
    (void)fprintf(stderr,"lvtexture: Unable to allocate new image!\n");
    return(0);
  }

  /* fill the kernal image with data from the appropriate texture mask */
 for (i = 0; i < 25; i++)
 {
  if (flag[i])
  {
   switch(i)
   {
    case 0:
       bcopy(L5L5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 1:
       bcopy(L5E5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 2:
       bcopy(L5S5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 3:
       bcopy(L5W5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 4:
       bcopy(L5R5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 5:
       bcopy(E5L5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 6:
       bcopy(E5E5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 7:
       bcopy(E5S5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 8:
       bcopy(E5W5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 9:
       bcopy(E5R5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 10:
       bcopy(S5L5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 11:
       bcopy(S5E5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 12:
       bcopy(S5S5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 13:
       bcopy(S5W5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 14:
       bcopy(S5R5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 15:
       bcopy(W5L5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 16:
       bcopy(W5E5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 17:
       bcopy(W5S5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 18:
       bcopy(W5W5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 19:
       bcopy(W5R5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 20:
       bcopy(R5L5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 21:
       bcopy(R5E5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 22:
       bcopy(R5S5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 23:
       bcopy(R5W5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    case 24:
       bcopy(R5R5_m, kernal->imagedata, 25 * sizeof(int));
       break;
    default:
       (void)fprintf(stderr,"lvtexture: ERROR, unknown kernal type.\n");
       return(0);
       break;
   }

   if (!lvconvolve(img1, kernal))  /* convolve kernal with image */
   {
     (void) fprintf(stderr,"lvtexture: ERROR convolving kernal with image\n");
     return(0);
   }
   data_ptr = result + (band_num * img_size);
   bcopy(img1->imagedata, data_ptr, img_size);
   copyimagedata(img2, &img1, 0);           /* restore original image data */
   band_num++;
  }
 }

/* Adjust image header */
(void)free(img1->imagedata);
img1->imagedata = (char *) result;
img1->num_data_bands = nb;
  
  return(1);
}
/* -library_code_end */
