 /*
  * Khoros: $Id: vctor.c,v 1.2 1992/03/20 22:53:36 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vctor.c,v 1.2 1992/03/20 22:53:36 dkhoros Exp $";
#endif

 /*
  * $Log: vctor.c,v $
 * Revision 1.2  1992/03/20  22:53:36  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vctor.c
 >>>>
 >>>>      Program Name: vctor
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Convert COMPLEX data to REAL form
 >>>>	
 >>>>	

 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Mon Mar  9 18:42:21 1992
 >>>>
 >>>>          Routines: main- the main program for vctor
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vctor.h"


/****************************************************************
 *
 * Routine Name:  main program for vctor
 *
 *       Input:  
 *       -i  input image 
 *       -o  resulting output image 
 *
 *
 *       [-t] Choose type of mapping from COMPLEX to REAL
 *		1 (Real part),
 *		2 (Imaginary part),
 *		3 (Magnitude),
 *		or 4 (Phase)
 *		   [default = 1] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        struct xvimage *image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);
        image = readimage(vctor->i_file);
        if (image == NULL) exit(1);
        CHECKINPUT(program,image);
/* -main_before_lib_call_end */

/* -main_library_call */
        if(! lvctor(image, vctor->t_toggle))
          {
            (void) fprintf(stderr, "lvctor Failed\\n");
            exit(1);
          }
/* -main_library_call_end */

/* -main_after_lib_call */
        writeimage(vctor->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vctor 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vctor :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tConvert COMPLEX data to REAL form\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
        fprintf(stderr,"The allowable conversion types are (-t):\n");
        fprintf(stderr,"  1      Output is assigned real part of input\n");
        fprintf(stderr,"  2      Output is assigned imaginary part of input\n");
        fprintf(stderr,"  3      Output is assigned magnitude of input\n");
        fprintf(stderr,"  4      Output is assigned phase of input\n\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-t]  Choose type of mapping from COMPLEX to REAL\n");
	fprintf(stderr, "\t\t1  (Real part),\n");
	fprintf(stderr, "\t\t2  (Imaginary part),\n");
	fprintf(stderr, "\t\t3  (Magnitude),\n");
	fprintf(stderr, "\t\tor 4  (Phase)\n");
	fprintf(stderr, "\t\t[default = 1]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vctor\n");
	fprintf(stderr, "\t[-U] Gives the usage for vctor\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vctor.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vctor.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vctor
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*t_pstr = "\nEnter: (t) Choose type of mapping from COMPLEX to REAL -- \n      \t\t1 (Real part)\n\t\t2 (Imaginary part)\n\t\t3 (Magnitude)\n\t\tor 4 (Phase)\n  [1]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vctor", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vctor.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vctor: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vctor.ans");
		}

	     }

	}

	/*
	 * allocate the vctor structure
	 */
	vctor = (vctor_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vctor_struct));

	/*
	 * get required arguments for vctor
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vctor->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vctor->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vctor->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vctor->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vctor->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vctor->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vctor->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vctor->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vctor->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vctor->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


	/*
	 * get optional toggles for vctor
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		vctor->t_flag = vget_int(fid, prompt_flag,
		"-t", t_pstr, &(vctor->t_toggle),
		1, 0, 0);

		if ((vctor->t_toggle == 1 ) || 
		    (vctor->t_toggle == 2 ) || 
		    (vctor->t_toggle == 3 ) || 
		    (vctor->t_toggle == 4 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		vctor->t_flag = vget_int(fid, prompt_flag,
		"-t", t_pstr, &(vctor->t_toggle),
		1, 0, 0);

		if ((vctor->t_toggle != 1 ) && 
		    (vctor->t_toggle != 2 ) && 
		    (vctor->t_toggle != 3 ) && 
		    (vctor->t_toggle != 4 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



