 /*
  * Khoros: $Id: vresize.h,v 1.1 1991/05/10 15:49:09 khoros Exp $
  */

 /*
  * $Log: vresize.h,v $
 * Revision 1.1  1991/05/10  15:49:09  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vresize.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Wed Mar 27 23:48:12 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vresize_h_
#define _vresize_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vresize Argument Structure
*
****************************************************************/

typedef struct _vresize  {

/*
 *  input image (Required infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  resulting output image (Required outfile)
 */
char	*o_file;	/* resulting output image FILENAME */
int	 o_flag;	/* resulting output image FLAG */

/*
 *  x coordinate of the center of action (Optional float)
 */
float	 x_float;	/* x coordinate of the center of action FLOAT */
int	 x_flag;   	/* x coordinate of the center of action FLAG */

/*
 *  y coordinate of the center of action (Optional float)
 */
float	 y_float;	/* y coordinate of the center of action FLOAT */
int	 y_flag;   	/* y coordinate of the center of action FLAG */

/*
 *  magnification in the horizontal direction (Optional float)
 */
float	 h_float;	/* magnification in the horizontal direction FLOAT */
int	 h_flag;   	/* magnification in the horizontal direction FLAG */

/*
 *  magnification in the vertical direction (Optional float)
 */
float	 v_float;	/* magnification in the vertical direction FLOAT */
int	 v_flag;   	/* magnification in the vertical direction FLAG */

}  vresize_struct;

vresize_struct *vresize;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define CHECKINPUT(program, image) \
        (void) proper_num_images(program,image,1,TRUE); \
        \
        if (propertype(program,image,VFF_TYP_COMPLEX,FALSE)) \
        { \
            (void) fprintf(stderr, "Image data type can NOT be \
VFF_TYP_COMPLEX \n"); \
            exit(1); \
        } \
        \
        (void) proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE); \
        \
        (void) proper_loc_type(program,image,VFF_LOC_IMPLICIT,TRUE)
/* -include_macros_end */

#endif
