 /*
  * Khoros: $Id: vrotate.c,v 1.2 1991/10/02 00:28:28 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vrotate.c,v 1.2 1991/10/02 00:28:28 khoros Exp $";
#endif

 /*
  * $Log: vrotate.c,v $
 * Revision 1.2  1991/10/02  00:28:28  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vrotate.c
 >>>>
 >>>>      Program Name: vrotate
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Rotate an image by an arbitrary angle
 >>>>	
 >>>>	

 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Sun Aug 25 21:10:28 1991
 >>>>
 >>>>          Routines: main- the main program for vrotate
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vrotate.h"


/****************************************************************
 *
 * Routine Name:  main program for vrotate
 *
 *       Input:  
 *         -i  input image 
 *         -o  resulting output image 
 *
 *
 *         [-x] X coord of center of rotation 
 *         [-y] Y coord of center of rotation 
 *         [-d] specifies the clockwise rotation angle in degrees 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        struct xvimage *image,*readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);
        image = readimage(vrotate->i_file);
        if (image == NULL) exit(1);
        CHECKINPUT(program, image);

        /* Default center of rotation is dead center */
        if (vrotate->x_flag == 0) vrotate->x_int = (image->row_size-1)/2.0;
        if (vrotate->y_flag == 0) vrotate->y_int = (image->col_size-1)/2.0;
/* -main_before_lib_call_end */

/* -main_library_call */
        if(! lvrotate(image,vrotate->d_float,vrotate->x_int,vrotate->y_int) )
          {
            (void) fprintf(stderr, "lvrotate Failed\n");
            exit(1);
          }
/* -main_library_call_end */

/* -main_after_lib_call */
        writeimage(vrotate->o_file, image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vrotate 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vrotate :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tRotate an image by an arbitrary angle\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
fprintf(stderr,"Note: The default center of rotation is the center of the image\n\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-x]  X coord of center of rotation (integer) [0]\n");
	fprintf(stderr,"\t[-y]  Y coord of center of rotation (integer) [0]\n");
	fprintf(stderr,"\t[-d]  specifies the clockwise rotation angle in degrees (float) [45]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vrotate\n");
	fprintf(stderr, "\t[-U] Gives the usage for vrotate\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vrotate.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vrotate.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vrotate
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*x_pstr = 
	"\nEnter: (x) X coord of center of rotation \n        {integer [0] }: "; 
char	*y_pstr = 
	"\nEnter: (y) Y coord of center of rotation \n        {integer [0] }: "; 
char	*d_pstr = 
	"\nEnter: (d) specifies the clockwise rotation angle in degrees \n        {float [45.000000] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vrotate", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vrotate.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vrotate: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vrotate.ans");
		}

	     }

	}

	/*
	 * allocate the vrotate structure
	 */
	vrotate = (vrotate_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vrotate_struct));

	/*
	 * get required arguments for vrotate
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vrotate->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vrotate->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vrotate->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vrotate->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vrotate->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vrotate->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vrotate->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vrotate->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vrotate->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vrotate->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vrotate
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vrotate->x_flag = vget_int(fid, prompt_flag,
	"-x", x_pstr, &(vrotate->x_int),
	0, 0, 0);

	vrotate->y_flag = vget_int(fid, prompt_flag,
	"-y", y_pstr, &(vrotate->y_int),
	0, 0, 0);

	vrotate->d_flag = vget_float(fid, prompt_flag,
	"-d", d_pstr, &(vrotate->d_float),
	45.000000, 0.000000, 0.000000);


}



