 /*
  * Khoros: $Id: parser.c,v 1.3 1991/12/18 09:11:57 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: parser.c,v 1.3 1991/12/18 09:11:57 dkhoros Exp $";
#endif

 /*
  * $Log: parser.c,v $
 * Revision 1.3  1991/12/18  09:11:57  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "forms.h"
#include "parser.h"

#define xvf_check_boolean(val)	(((val != 0) && (val != 1))? 0 : 1)
#define xvf_check_pos(pos, width) ((pos > width)? 0 : 1)

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>		       Parsing  Routines                      <<<<
   >>>>                                                       <<<<
   >>>>	       ~ parse lines out of the User Interface	      <<<<
   >>>>                Description (database)		      <<<<
   >>>>   			including:                    <<<<
   >>>>                                                       <<<<
   >>>>                                                       <<<<
   >>>>		xvf_parse_startform_line()		      <<<<   
   >>>>		xvf_parse_startmaster_line()		      <<<<   
   >>>>		xvf_parse_startsubmenu_line()		      <<<<   
   >>>>		xvf_parse_startsubform_line()		      <<<<   
   >>>>		xvf_parse_subformbutton_line()		      <<<<   
   >>>>		xvf_parse_psuedosubform_line()		      <<<<   
   >>>>		xvf_parse_master_action_line()		      <<<<   
   >>>>		xvf_parse_startguide_line()		      <<<<   
   >>>>		xvf_parse_startpane_line()		      <<<<   
   >>>>		xvf_parse_guide_line()			      <<<<   
   >>>>		xvf_parse_quit_line()			      <<<<   
   >>>>		xvf_parse_subform_action_line()		      <<<<   
   >>>>		xvf_parse_help_line()		      	      <<<<   
   >>>>		xvf_parse_input_line()		      	      <<<<   
   >>>>		xvf_parse_output_line()		      	      <<<<   
   >>>>		xvf_parse_int_line()		      	      <<<<   
   >>>>		xvf_parse_float_line()		      	      <<<<   
   >>>>		xvf_parse_logic_line()		      	      <<<<   
   >>>>		xvf_parse_string_line()		    	      <<<<   
   >>>>		xvf_parse_routine_line()	      	      <<<<   
   >>>>		xvf_parse_toggle_line()		      	      <<<<   
   >>>>		xvf_parse_blank_line()		      	      <<<<   
   >>>>		xvf_parse_pane_action_line()		      <<<<   
   >>>>		xvf_parse_includepane_line()		      <<<<   
   >>>>		xvf_parse_includesubform_line()		      <<<<   
   >>>>		xvf_parse_mutexcl_line()		      <<<<   
   >>>>		xvf_parse_workspace_line()		      <<<<   
   >>>>		xvf_parse_ansinfile_line()		      <<<<   
   >>>>		xvf_parse_list_line()		      	      <<<<   
   >>>>		xvf_parse_cycle_line()		      	      <<<<   
   >>>>		xvf_parse_end_line()		      	      <<<<   
   >>>>                                                       <<<<
   >>>>		xvf_create_readerror_mesg()	      	      <<<<   
   >>>>		xvf_create_mesg()		      	      <<<<   
   >>>>		xvf_clear_line_info()		      	      <<<<   
   >>>>                                                       <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */



/************************************************************
*
*      Routine: xvf_parse_startform_line(line, &line_info);
*
*      Purpose: Parses a Start Form line  (-F:  typeflag = StartForm)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int xvf_parse_startform_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_title[MaxLength], tmp_var[MaxLength], flag;
	int  release, version;
	char *mesg, temp[MaxLength];
	int  status;

        status = sscanf(line, startform_scan, &flag, 
			&release, &version,
			&line_info->activate, &line_info->selected,
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			tmp_title, tmp_var);
	

	if (status < 12) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_startform_line",
					  line, status, 12);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
   	} 

	if ((VStrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(tmp_title);
	}
	
	if ((VStrcmp(tmp_var,"")) == 0) 
        {
	    mesg = xvf_create_mesg("xvf_parse_startform_line", line,
			         "'variable' field MUST be specified", 1);
	    xvf_error_wait(mesg, "Warning",NULL); free(mesg);
	    return(false);
        }
	else 
	{ 
	    if (line_info->variable != NULL) free (line_info->variable);
	    line_info->variable = xvf_strcpy(tmp_var);
	}

	sprintf(temp, "%d.%d", release, version);
	if (VStrcmp(temp, "4.2")!= 0) 
	{
	    mesg = xvf_create_mesg("xvf_parse_startform_line", line,
			         	"'version' field MUST be 4.2", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}
	else line_info->version = 4.2;
	
	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_startform_line", line,
			         	"'activate' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}
	

        if (!(xvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = xvf_create_mesg("xvf_parse_startform_line", line, 
			  		"X position is greater than width", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
	    if (status == 0) return(false);
	}

 	if (!(xvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = xvf_create_mesg("xvf_parse_startform_line", line, 
			  		"Y position is greater than height", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
	    if (status == 0) return(false);
	}

	line_info->typeflag = StartForm;

	return(true);
}



/************************************************************
*
*      Routine: xvf_parse_startmaster_line(line, &line_info);
*
*      Purpose: Parses a StartMaster line  (-S:  typeflag = StartMaster)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int xvf_parse_startmaster_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char flag, *mesg;
	int status;
	status = sscanf(line, startmaster_scan, &flag, &line_info->activate,
			      &line_info->logical_val);

	if (status < 3) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_startmaster_line",
					  line, status, 3);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
   	} 

	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_startmaster_line", line,
			         	"'activate' flag must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}
	if (!(xvf_check_boolean(line_info->logical_val)))
	{
	    mesg = xvf_create_mesg("xvf_parse_startmaster_line", line,
			       	"'mutually exclusive' flag must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}
	line_info->typeflag = StartMaster;
	return(true);
}



/************************************************************
*
*      Routine: xvf_parse_startsubmenu_line(line, &line_info);
*
*      Purpose: Parses a Start SubMenu line  (-D:  typeflag = StartSubMenu)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int xvf_parse_startsubmenu_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_title[MaxLength], tmp_var[MaxLength], flag;
	char *mesg;
	int  status;

        status = sscanf(line, startsubmenu_scan, &flag, 
			&line_info->activate, &line_info->selected, 
		        &line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			tmp_title, tmp_var);
	
	if (status < 11) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_startsubmenu_line",
					  line, status, 11);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
   	} 

	if ((VStrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(tmp_title);
	}
	
	if ((VStrcmp(tmp_var," ")) == 0) 
        {
	    mesg = xvf_create_mesg("xvf_parse_startsubmenu_line", line,
			       	"'variable' field MUST be specified", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
        }
	else 
	{ 
	    if (line_info->variable != NULL) free (line_info->variable);
	    line_info->variable = xvf_strcpy(tmp_var);
	}

	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_startsubmenu_line", line,
			         "'activate' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	line_info->typeflag = StartSubMenu;

	return(true);
}



/************************************************************
*
*      Routine: xvf_parse_startsubform_line(line, &line_info);
*
*      Purpose: Parses a Start SubForm line  (-M:  typeflag = StartSubForm)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int xvf_parse_startsubform_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_title[MaxLength], tmp_var[MaxLength], flag;
	char *mesg;
	int  status;

        status = sscanf(line, startsubform_scan, &flag, 
			&line_info->activate, &line_info->selected, 
		        &line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			tmp_title, tmp_var);
	
	if (status < 11) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_startsubform_line",
					  line, status, 11);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
   	} 

	if ((VStrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(tmp_title);
	}
	
	if ((VStrcmp(tmp_var,"")) == 0) 
        {
	    mesg = xvf_create_mesg("xvf_parse_startsubform_line", line,
		         	"'variable' field MUST be specified", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
        }
	else 
	{ 
	    if (line_info->variable != NULL) free (line_info->variable);
	    line_info->variable = xvf_strcpy(tmp_var);
	}

	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_startsubform_line", line,
			         "'activate' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

 	if (!(xvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = xvf_create_mesg("xvf_parse_startsubform_line", line, 
		  		"X position is greater than width", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
	    if (status == 0) return(false);
	}

 	if (!(xvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = xvf_create_mesg("xvf_parse_startsubform_line", line, 
		  		"Y position is greater than height", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
	    if (status == 0) return(false);
	}

	line_info->typeflag = StartSubForm;

	return(true);
}



/************************************************************
*
*      Routine: xvf_parse_subformbutton_line(line, &line_info);
*
*      Purpose: Parses a SubFormButton line  (-d:  typeflag = SubFormButton)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int xvf_parse_subformbutton_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char temp[MaxLength], flag;
	int status;
	char *mesg;

        status = sscanf(line, subformbutton_scan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, temp);

	if (status < 8) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_subformbutton_line",
					 line, status, 10);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if ((VStrcmp(temp," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(temp);
	}
	
	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_subformbutton_line", line,
			  "activate must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
            return(false);
        }

	if (!(xvf_check_boolean(line_info->selected)))
	{
	    mesg = xvf_create_mesg("xvf_parse_subformbutton_line", line,
			  	"'selected' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
 	    return(false);
        }

	line_info->typeflag = SubFormButton;

	return(true);
}




/************************************************************
*
*      Routine: xvf_parse_psuedosubform_line(line, &line_info);
*
*      Purpose: Parses a PsuedoSubForm line  (-u:  typeflag = PsuedoSubForm)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro 
*
*
*************************************************************/

int xvf_parse_psuedosubform_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char temp[MaxLength], flag;
	int status;
	char *mesg;

        status = sscanf(line, psuedosubform_scan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, temp);

	if (status < 8) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_psuedosubform_line",
					 line, status, 8);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if ((VStrcmp(temp," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(temp);
	}
	
	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_psuedosubform_line", line,
			  "activate must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
            return(false);
        }

	if (!(xvf_check_boolean(line_info->selected)))
	{
	    mesg = xvf_create_mesg("xvf_parse_psuedosubform_line", line,
			  	"'selected' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
 	    return(false);
        }

	line_info->typeflag = PsuedoSubForm;

	return(true);
}

/************************************************************
*
*      Routine: xvf_parse_master_action_line(line, &line_info);
*
*      Purpose: Parses a Master Action line  (-n:  typeflag = MasterAction)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int xvf_parse_master_action_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_desc[MaxLength], tmp_title[MaxLength], tmp_var[MaxLength], 
	     flag;
	int status;
	char *mesg;

        status = sscanf(line, master_action_scan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			tmp_title, tmp_desc, tmp_var);
	
	if (status < 10) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_master_action_line",
					 line, status, 10);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
    	}

	if ((VStrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(tmp_title);
	}

	if ((VStrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) free (line_info->description);
	    line_info->description = xvf_strcpy(tmp_desc);
	}

	if ((VStrcmp(tmp_var,"")) == 0) 
        {
	    mesg = xvf_create_mesg("xvf_parse_masteractionline", line,
		         	"'variable' field MUST be specified", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
        }
	else 
	{ 
	    if (line_info->variable != NULL) free (line_info->variable);
	    line_info->variable = xvf_strcpy(tmp_var);
	}


	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_master_action_line", line,
			  "activate must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
            return(false);
        }

	if (!(xvf_check_boolean(line_info->selected)))
	{
	    mesg = xvf_create_mesg("xvf_parse_master_action_line", line,
		  		"selected must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
            return(false);
        }

	line_info->typeflag = MasterAction;

	return(true);
}


/************************************************************
*
*      Routine: xvf_parse_startguide_line(line, &line_info);
*
*      Purpose: Parses a Start Guide line  (-G:  typeflag = StartGuide)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int xvf_parse_startguide_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char temp[MaxLength], flag;
	int status;
	char *mesg;

        status = sscanf(line, startguide_scan, &flag, 
			&line_info->activate, &line_info->width, 
			&line_info->height, &line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, temp);
	
	if (status < 9) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_startguide_line",
                                          line, status, 9);
            xvf_error_wait(mesg, NULL,NULL); free(mesg);
            return(false);
	}

	if ((VStrcmp(temp," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(temp);
	}

	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_startguide_line", line,
				"'activate' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
            return(false);
        }

 	if (!(xvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = xvf_create_mesg("xvf_parse_startguide_line", line, 
		  		"X position is greater than width", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }

 	if (!(xvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = xvf_create_mesg("xvf_parse_startguide_line", line, 
		  		"Y position is greater than height", 2);

	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
	}

	line_info->typeflag = StartGuide;

	return(true);
}


/************************************************************
*
*      Routine: xvf_parse_startpane_line(line, &line_info);
*
*      Purpose: Parses a Start Form line  (-P:  typeflag = StartForm)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int xvf_parse_startpane_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_title[MaxLength], tmp_var[MaxLength], flag;
	int status;
	char *mesg;

        status = sscanf(line, startpane_scan, &flag, 
			&line_info->activate, &line_info->selected,
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			tmp_title, tmp_var);
	

	if (status < 11) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_startpane_line",
					 line, status, 11);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
   	}

	if ((VStrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(tmp_title);
	}

	if ((VStrcmp(tmp_var,"")) == 0) 
        {
	    mesg = xvf_create_mesg("xvf_parse_startpane_line", line,
		         	"'variable' field MUST be specified", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
        }
	else 
	{ 
	    if (line_info->variable != NULL) free (line_info->variable);
	    line_info->variable = xvf_strcpy(tmp_var);
	}

	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_startpane_line", line,
		  	 	"'activate' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
            return(false);
        }

 	if (!(xvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = xvf_create_mesg("xvf_parse_startpane_line", line, 
		  	 	"X position is greater than width", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }

 	if (!(xvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = xvf_create_mesg("xvf_parse_startpane_line", line, 
		  		"Y position is greater than height", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }


	line_info->typeflag = StartPane;

	return(true);
}



/************************************************************
*
*      Routine: xvf_parse_guide_line(line, &line_info);
*
*      Purpose: Parses a Guide line  (-g:  typeflag = GuideButton)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int xvf_parse_guide_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char temp[MaxLength], flag;
	int status;
	char *mesg;

        status = sscanf(line, guidebutton_scan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, temp);

	if (status < 8) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_guide_line",
					 line, status, 8);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if ((VStrcmp(temp," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(temp);
	}

	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_guide_line", line,
			  "activate must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
            return(false);
        }

	if (!(xvf_check_boolean(line_info->selected)))
	{
	    mesg = xvf_create_mesg("xvf_parse_guide_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
 	    return(false);
        }

	line_info->typeflag = GuideButton;

	return(true);
}


/************************************************************
*
*      Routine: xvf_parse_quit_line(line, &line_info);
*
*      Purpose: Parses a Quit line  (-Q:  typeflag = Quit Form)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int xvf_parse_quit_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_title[MaxLength], flag;
	int status;
	char *mesg;

        status = sscanf(line, quitform_scan, &flag, 
			&line_info->activate, &line_info->selected,
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, tmp_title);
	
	if (status < 8) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_quit_line",line, status,8);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if ((VStrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
  	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(tmp_title);
  	}

	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_quit_line", line,
		  		"'activate' field must be 0 or 1", 1);
            xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
        }

	if (!(xvf_check_boolean(line_info->selected)))
	{
	    mesg = xvf_create_mesg("xvf_parse_quit_line", line,
		  		"'selected' field must be 0 or 1", 1);
            xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
        }

	line_info->typeflag = QuitForm;

	return(true);
}


/************************************************************
*
*      Routine: xvf_parse_subform_action_line(line, &line_info);
*
*      Purpose: Parses an Subform Action line  (-m:  typeflag =  SubformAction)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int xvf_parse_subform_action_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_title[MaxLength], tmp_desc[MaxLength], tmp_var[MaxLength], 
	     flag;
	int status;
	char *mesg;

        status = sscanf(line, subform_action_scan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			tmp_title, tmp_desc, tmp_var);
	
	if (status < 10) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_subform_action_line",
					 line, status, 10);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
    	}

	if ((VStrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(tmp_title);
	}

	if ((VStrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) free (line_info->description);
	    line_info->description = xvf_strcpy(tmp_desc);
	}

	if ((VStrcmp(tmp_var,"")) == 0) 
        {
	    mesg = xvf_create_mesg("xvf_parse_subform_action_line", line,
		         	"'variable' field MUST be specified", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
        }
	else 
	{ 
	    if (line_info->variable != NULL) free (line_info->variable);
	    line_info->variable = xvf_strcpy(tmp_var);
	}

	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_subform_action_line", line,
		  		"activate must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
            return(false);
        }

	if (!(xvf_check_boolean(line_info->selected)))
	{
	    mesg = xvf_create_mesg("xvf_parse_subform_action_line", line,
		  		"selected must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
            return(false);
        }

	line_info->typeflag = SubformAction;

	return(true);
}


/************************************************************
*
*      Routine: xvf_parse_help_line(line, &line_info);
*
*      Purpose: Parses a Help line  (-H:  typeflag = HelpSel)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int xvf_parse_help_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_desc[MaxLength], tmp_title[MaxLength], 
	     tmp_file[MaxLength], flag;
	int status;
	char *mesg;

        status = sscanf(line, help_scan, &flag, 
			&line_info->activate, &line_info->width, 
			&line_info->height, &line_info->x, &line_info->y, 
			tmp_title, tmp_desc, tmp_file);

	if (status < 9) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_help_line",
					 line, status, 11);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if ((VStrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
  	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(tmp_title);
	}

	if ((VStrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) free (line_info->description);
	    line_info->description = xvf_strcpy(tmp_desc);
	}

	if ((VStrcmp(tmp_file," ")) == 0) line_info->help_file = NULL;
	else 
	{ 
	    if (line_info->help_file != NULL) free (line_info->help_file);
	    line_info->help_file = xvf_strcpy(tmp_file);
	}

	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_help_line", line,
		  		"activate must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
        }

	line_info->typeflag = HelpSel;
	return(true);
}



/************************************************************
*
*      Routine: xvf_parse_input_line(line, &line_info);
*
*      Purpose: Parses an Input line  (-I:  typeflag = InputFile)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int xvf_parse_input_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_desc[MaxLength], tmp_title[MaxLength], tmp_var[MaxLength], 
	     tmp_filename[MaxLength], tmp_default[MaxLength], 
	     tmp_literal[MaxLength];
	char flag;
	int status;
	char *mesg;

        status = sscanf(line, input_scan, &flag, 
			&line_info->activate, &line_info->selected,  
			&line_info->optional, &line_info->opt_sel,
			&line_info->live, &line_info->file_type,
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			tmp_default, tmp_title, tmp_desc, 
			tmp_var, tmp_filename, tmp_literal);
	
	if (status == 19)
        {
            if ((VStrcmp(tmp_literal," ")) == 0) line_info->literal = NULL;
            else
            {
                if (line_info->literal != NULL) free (line_info->literal);
                line_info->literal = xvf_strcpy(tmp_literal);
            }
	    if ((VStrcmp(tmp_filename," ")) == 0) line_info->filename = NULL;
            else
            {
                if (line_info->filename != NULL) free (line_info->filename);
                line_info->filename = xvf_strcpy(tmp_filename);
            }
            if ((VStrcmp(tmp_default," ")) == 0) line_info->file_def = NULL;
            else
            {
                if (line_info->file_def != NULL) free (line_info->file_def);
                line_info->file_def = xvf_strcpy(tmp_default);
            }
        }

	else if (status == 18) 
	{
	    if ((VStrcmp(tmp_filename," ")) == 0) 
	    {
		line_info->filename = NULL;
		line_info->literal = NULL;
	    }
	    else 
	    { 
	        if (line_info->filename != NULL) free (line_info->filename);
	        line_info->filename = xvf_strcpy(tmp_filename);
	
	        if (line_info->literal != NULL) free (line_info->literal);
                line_info->literal = xvf_strcpy(tmp_filename);

	    }

	    if ((VStrcmp(tmp_default," ")) == 0) line_info->file_def = NULL;
            else
            {
                if (line_info->file_def != NULL) free (line_info->file_def);
                line_info->file_def = xvf_strcpy(tmp_default);
            }

	}

	else if (status == 17) 
	{
	    if ((VStrcmp(tmp_default, " ")) == 0)
	    {
	 	line_info->filename = NULL;
	 	line_info->literal = NULL;
	 	line_info->file_def = NULL;

	    }
	    else 
	    {
		if (line_info->file_def != NULL) free (line_info->file_def);
                line_info->file_def = xvf_strcpy(tmp_default);

		if (line_info->filename != NULL) free (line_info->filename);
                line_info->filename = xvf_strcpy(tmp_default);
	
	  	if (line_info->literal != NULL) free (line_info->literal);
                line_info->literal    = xvf_strcpy(tmp_default);
	    }
	}

	else if (status < 17) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_input_line",
					 line, status, 17);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if ((VStrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(tmp_title);
	}

	if ((VStrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) free (line_info->description);
	    line_info->description = xvf_strcpy(tmp_desc);
	}

	if ((VStrcmp(tmp_var,"")) == 0) 
        {
	    mesg = xvf_create_mesg("xvf_parse_input_line", line,
		         	"'variable' field MUST be specified", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
        }
	else 
	{ 
	    if (line_info->variable != NULL) free (line_info->variable);
	    line_info->variable = xvf_strcpy(tmp_var);
	}

	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_input_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->selected)))
	{
	    mesg = xvf_create_mesg("xvf_parse_input_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->optional)))
	{
	    mesg = xvf_create_mesg("xvf_parse_input_line", line,
		  		"'optional' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->opt_sel)))
	{
	    mesg = xvf_create_mesg("xvf_parse_input_line", line,
		  		"opt_sel must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

        if ((line_info->optional ==0 ) && (line_info->opt_sel != 1))
	{
	    mesg = xvf_create_mesg("xvf_parse_input_line", line,
	    "if the 'optional' field = 0, then  the 'opt_sel' must be = 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->live)))
	{
	    mesg = xvf_create_mesg("xvf_parse_input_line", line,
		  		"'live' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (line_info->file_type < 0) 
	{
	    mesg = xvf_create_mesg("xvf_parse_input_line", line,
		  		"'file_type' field must be > 0 ", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

 	if (!(xvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = xvf_create_mesg("xvf_parse_input_line", line, 
			 	"X position is greater than width", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }

 	if (!(xvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = xvf_create_mesg("xvf_parse_input_line", line, 
		  		"Y position is greater than height", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }

	line_info->typeflag = InputFile;

	return(true);
}



/************************************************************
*
*      Routine: xvf_parse_output_line(line, &line_info);
*
*      Purpose: Parses an Output line  (-O:  typeflag = OutputFile)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*************************************************************/

int xvf_parse_output_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_desc[MaxLength], tmp_title[MaxLength], tmp_var[MaxLength], 
	     tmp_filename[MaxLength], tmp_default[MaxLength], 
	     tmp_literal[MaxLength];
	char flag;
	int  status;
	char *mesg;

        status = sscanf(line, output_scan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->optional, &line_info->opt_sel,
		        &line_info->live, &line_info->file_type,
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			tmp_default, tmp_title, tmp_desc, 
			tmp_var, tmp_filename, tmp_literal);
	
	if (status == 19)
        {
            if ((VStrcmp(tmp_literal," ")) == 0) line_info->literal = NULL;
            else
            {
                if (line_info->literal != NULL) free (line_info->literal);
                line_info->literal = xvf_strcpy(tmp_literal);
            }
	    if ((VStrcmp(tmp_filename," ")) == 0) line_info->filename = NULL;
	    else
	    {
                if (line_info->filename != NULL) free (line_info->filename);
                line_info->filename = xvf_strcpy(tmp_filename);
	    }
	    if ((VStrcmp(tmp_default," ")) == 0) line_info->file_def = NULL;
	    else
	    {
                if (line_info->file_def != NULL) free (line_info->file_def);
                line_info->file_def = xvf_strcpy(tmp_default);
	    }
        }

	else if (status == 18) 
	{
	    if ((VStrcmp(tmp_filename," ")) == 0) 
	    {
		line_info->filename = NULL;
		line_info->literal  = NULL;
	    }
	    else 
	    { 
		if (line_info->filename != NULL) free (line_info->filename);
                line_info->filename = xvf_strcpy(tmp_filename);

		if (line_info->literal != NULL) free (line_info->literal);
                line_info->literal = xvf_strcpy(tmp_filename);

	    }

	    if ((VStrcmp(tmp_default," ")) == 0) line_info->file_def = NULL;
	    else
	    {
                if (line_info->file_def != NULL) free (line_info->file_def);
                line_info->file_def = xvf_strcpy(tmp_default);
	    }
	}

	else if (status == 17) 
	{
	    if ((VStrcmp(tmp_default, " ")) == 0)
	    {
		line_info->filename = NULL;
                line_info->literal = NULL;
                line_info->file_def = NULL;
	    }
	    else 
	    {
		if (line_info->file_def != NULL) free (line_info->file_def);
                line_info->file_def = xvf_strcpy(tmp_default);

                if (line_info->filename != NULL) free (line_info->filename);
                line_info->filename = xvf_strcpy(tmp_default);

                if (line_info->literal != NULL) free (line_info->literal);
                line_info->literal    = xvf_strcpy(tmp_default);
	    }
	}

	else if (status < 17) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_output_line",
				         line, status, 17);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
    	}

	if ((VStrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(tmp_title);
	}

	if ((VStrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) free (line_info->description);
	    line_info->description = xvf_strcpy(tmp_desc);
	}

	if ((VStrcmp(tmp_var,"")) == 0) 
        {
	    mesg = xvf_create_mesg("xvf_parse_output_line", line,
		         	"'variable' field MUST be specified", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
        }
	else 
	{ 
	    if (line_info->variable != NULL) free (line_info->variable);
	    line_info->variable = xvf_strcpy(tmp_var);
	}

	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_output_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->selected)))
	{
	    mesg = xvf_create_mesg("xvf_parse_output_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->optional)))
	{
	    mesg = xvf_create_mesg("xvf_parse_output_line", line,
		  		"'optional' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

        if ((line_info->optional ==0 ) && (line_info->opt_sel != 1))
	{
	    mesg = xvf_create_mesg("xvf_parse_output_line", line,
	    "if the 'optional' field = 0, then  the 'opt_sel' must be = 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->opt_sel)))
	{
	    mesg = xvf_create_mesg("xvf_parse_output_line", line,
				"'opt_sel' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->live)))
	{
	    mesg = xvf_create_mesg("xvf_parse_output_line", line,
		  		"'live' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (line_info->file_type < 0)
	{
	    mesg = xvf_create_mesg("xvf_parse_output_line", line,
		  		"'file_type' field must > 0", 1);
	    xvf_error_wait(mesg, NULL, NULL); free(mesg);
	    return(false);
	}

 	if (!(xvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = xvf_create_mesg("xvf_parse_output_line", line, 
		  		"X position is greater than width", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }

 	if (!(xvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = xvf_create_mesg("xvf_parse_output_line", line, 
		  		"Y position is greater than height", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
	}

	line_info->typeflag = OutputFile;

	return(true);
}



/************************************************************
*
*      Routine: xvf_parse_int_line(line, &line_info);
*
*      Purpose: Parses an Integer line  (-i:  typeflag = IntegerOpt)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*************************************************************/

int xvf_parse_int_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_desc[MaxLength], tmp_title[MaxLength], tmp_var[MaxLength], 
	     tmp_literal[MaxLength], temp[MaxLength];
	char flag;
	int  status, check_int;
	char *mesg, warn_mesg[MaxLength];

        status = sscanf(line, int_scan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->optional, &line_info->opt_sel,
			&line_info->live,
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			&line_info->lower_int, &line_info->upper_int, 
			&line_info->int_def, tmp_title, tmp_desc, 
			tmp_var, &line_info->int_val, tmp_literal);

	if (status == 20)
        {
            if ((VStrcmp(tmp_literal," ")) == 0) line_info->literal = NULL;
            else
            {
                if (line_info->literal != NULL) free (line_info->literal);
                line_info->literal = xvf_strcpy(tmp_literal);
            }
        }

	else if (status == 19)
	{
	     check_int = check_bounds_int(line_info->int_val, 
					  line_info->upper_int,
		                          line_info->lower_int);
	     switch(check_int) 
	     {
		case -3: 
			 sprintf(warn_mesg, "Integer value '%d' must be < 0", 
					   line_info->int_val);
			 mesg = xvf_create_mesg("xvf_parse_int_line", 
				line, warn_mesg, 1); 
                         xvf_error_wait(mesg, NULL,NULL); free(mesg);
                         return(false);
			 break;

		case -2: 
			 sprintf(warn_mesg, "Integer value '%d' must be <= 0", 
					   line_info->int_val);
			 mesg = xvf_create_mesg("xvf_parse_int_line", 
				line, warn_mesg, 1);
                         xvf_error_wait(mesg, NULL,NULL); free(mesg);
                         return(false);
                         break;

		case  -1: 
			 sprintf(warn_mesg, "Integer value '%d' must be greater than %d, less than %d", line_info->int_val, line_info->lower_int, line_info->upper_int);
                         xvf_error_wait(warn_mesg, "xvf_parse_int_line",NULL);
                         return(false);
                         break;

		case  1: 
			 sprintf(warn_mesg, "Integer value '%d' must be >= 0", 
					   line_info->int_val);
			 mesg = xvf_create_mesg("xvf_parse_int_line", 
				line, warn_mesg, 1);
                         xvf_error_wait(mesg, NULL,NULL); free(mesg);
                         return(false);
                         break;

		case  2:
			 sprintf(warn_mesg, "Integer value '%d' must be > 0", 
					   line_info->int_val);
			 mesg = xvf_create_mesg("xvf_parse_int_line", 
				line, warn_mesg, 1);
                         xvf_error_wait(mesg, NULL,NULL); free(mesg);
                         return(false);
                         break;

		case  0:
			 break;
                default:
			 break;
	     }

	   sprintf(temp, "%d", line_info->int_val);
	   line_info->literal = xvf_strcpy(temp);

	}
	else if (status == 18)  
	{

	    check_int = check_bounds_int(line_info->int_def, 
					 line_info->upper_int,
		                         line_info->lower_int);
	    switch(check_int) 
	    {
		case -3: 
			 sprintf(warn_mesg, "Default Integer value '%d' must be < 0", 
					   line_info->int_def);
			 mesg = xvf_create_mesg("xvf_parse_int_line", 
				line, warn_mesg, 1);
                         xvf_error_wait(mesg, NULL,NULL); free(mesg);
                         return(false);
			 break;

		case -2: 
			 sprintf(warn_mesg, "Default Integer value '%d' must be <= 0", 
					   line_info->int_def);
			 mesg = xvf_create_mesg("xvf_parse_int_line", 
				line, warn_mesg, 1);
                         xvf_error_wait(mesg, NULL,NULL); free(mesg);
                         return(false);
                         break;

		case  -1:
			 sprintf(warn_mesg, "Default Integer value '%d' must be greater than %d, less than %d", line_info->int_def, line_info->lower_int, line_info->upper_int);
                         xvf_error_wait(warn_mesg, "xvf_parse_int_line",NULL);
                         return(false);
                         break;

		case  1: 
			 sprintf(warn_mesg, "Default Integer value '%d' must be >= 0", 
					   line_info->int_def);
			 mesg = xvf_create_mesg("xvf_parse_int_line", 
				line, warn_mesg, 1);
                         xvf_error_wait(mesg, NULL,NULL); free(mesg);
                         return(false);
                         break;

		case  2: 
			 sprintf(warn_mesg, "Default Integer value '%d' must be > 0", 
					   line_info->int_def);
			 mesg = xvf_create_mesg("xvf_parse_int_line", 
				line, warn_mesg, 1);
                         xvf_error_wait(mesg, NULL,NULL); free(mesg);
                         return(false);
                         break;
		case  0:
			 break;
		default:
			 break;

	   } /* end switch */

	   line_info->int_val = line_info->int_def;
	   sprintf(temp, "%d", line_info->int_def);
	   line_info->literal = xvf_strcpy(temp);

	} /* end if */

	else if (status < 18) 
	{
	     mesg = xvf_create_readerror_mesg("xvf_parse_int_line",
					  line, status, 19);
	     xvf_error_wait(mesg, NULL,NULL); free(mesg);
	     return(false);
	}

	
	if ((VStrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(tmp_title);
	}

	if ((VStrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) free (line_info->description);
	    line_info->description = xvf_strcpy(tmp_desc);
	}

	if ((VStrcmp(tmp_var,"")) == 0) 
        {
	    mesg = xvf_create_mesg("xvf_parse_int_line", line,
			       	"'variable' field MUST be specified", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
        }
	else 
	{ 
	    if (line_info->variable != NULL) free (line_info->variable);
	    line_info->variable = xvf_strcpy(tmp_var);
	}

	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_int_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->selected)))
	{
	    mesg = xvf_create_mesg("xvf_parse_int_line", line,
		 		"'selected' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->optional)))
	{
	    mesg = xvf_create_mesg("xvf_parse_int_line", line,
			  	   "'optional' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

        if ((line_info->optional ==0 ) && (line_info->opt_sel != 1))
	{
	    mesg = xvf_create_mesg("xvf_parse_int_line", line,
	    "if the 'optional' field = 0, then the 'opt_sel' field must be = 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->opt_sel)))
	{
	    mesg = xvf_create_mesg("xvf_parse_int_line", line,
				"'opt_sel' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->live)))
	{
	    mesg = xvf_create_mesg("xvf_parse_int_line", line,
	    			"'live' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

 	if (!(xvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = xvf_create_mesg("xvf_parse_int_line", line, 
		  		"X position is greater than width", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }

 	if (!(xvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = xvf_create_mesg("xvf_parse_int_line", line, 
		  		"Y position is greater than height", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }



	line_info->typeflag = IntegerOpt;

	return(true);
}



/************************************************************
*
*      Routine: xvf_parse_float_line(line, &line_info);
*
*      Purpose: Parses a Float line  (-f:  typeflag = FloatOpt)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*************************************************************/

int xvf_parse_float_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_desc[MaxLength], tmp_title[MaxLength], tmp_var[MaxLength], 
	     tmp_literal[MaxLength], temp[MaxLength];
	char flag;
	int  status, check_float;
	char *mesg, warn_mesg[MaxLength];
	double atof(); 

        status = sscanf(line, float_scan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->optional,  &line_info->opt_sel,
			&line_info->live,
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			&line_info->lower_float, &line_info->upper_float, 
			&line_info->float_def, tmp_title, tmp_desc, 
			tmp_var, &line_info->float_val, tmp_literal);

	if (status == 20)
        {
            if ((VStrcmp(tmp_literal," ")) == 0) line_info->literal = NULL;
            else
            {
                if (line_info->literal != NULL) free (line_info->literal);
                line_info->literal = xvf_strcpy(tmp_literal);
            }
        }

	else if (status == 19)
	{

	     check_float = check_bounds_float(line_info->float_val, 
		     			      line_info->upper_float,
		                              line_info->lower_float);
	     switch(check_float) 
	     {
	                 
		case -3: 
			 sprintf(warn_mesg, "Float value '%g' must be < 0", 
					   line_info->float_val);
			 mesg = xvf_create_mesg("xvf_parse_float_line", 
				line, warn_mesg, 1);
                         xvf_error_wait(mesg, NULL,NULL); free(mesg);
                         return(false);
			 break;

		case -2: 
			 sprintf(warn_mesg, "Float value '%g' must be <= 0", 
					   line_info->float_val);
			 mesg = xvf_create_mesg("xvf_parse_float_line", 
				line, warn_mesg, 1);
                         xvf_error_wait(mesg, NULL,NULL); free(mesg);
                         return(false);
                         break;

		case  -1: 
			 sprintf(warn_mesg, "Float value '%g' must be greater than %g, less than %g", line_info->float_val, line_info->lower_float, line_info->upper_float);
			 mesg = xvf_create_mesg("xvf_parse_float_line", 
						      line, warn_mesg, 1);
                         xvf_error_wait(mesg, NULL,NULL); 
			 free(mesg);
                         return(false);
                         break;

		case  1: 
			 sprintf(warn_mesg, "Float value '%g' must be >= 0",
					     line_info->float_val);
			 mesg = xvf_create_mesg("xvf_parse_float_line",
				line, warn_mesg, 1);
                         xvf_error_wait(mesg, NULL,NULL); free(mesg);
                         return(false);
                         break;

		case  2: 
			 sprintf(warn_mesg, "Float value '%g' must be >  0",
                                             line_info->float_val);
			 mesg = xvf_create_mesg("xvf_parse_float_line", 
				line, warn_mesg, 1);
                         xvf_error_wait(mesg, NULL,NULL); free(mesg);
                         return(false);
                         break;
		case  0:
			 break;
		default:
			 break;
	     }

	   sprintf(temp, "%g", line_info->float_val);
	   line_info->literal = xvf_strcpy(temp);

	}

	else if (status == 18)  
	{
	    check_float = check_bounds_float(line_info->float_def, 
		 			 line_info->upper_float,
		                         line_info->lower_float);
	    switch(check_float) 
	    {
		case -3: 
			 sprintf(warn_mesg, "Default Float value '%g' must be < 0", 
					   line_info->float_def);
			 mesg = xvf_create_mesg("xvf_parse_float_line", 
				line, warn_mesg, 1);
                         xvf_error_wait(mesg, NULL,NULL); free(mesg);
                         return(false);
			 break;

		case -2: 
			 sprintf(warn_mesg, "Default Float value '%g' must be <= 0", 
					   line_info->float_def);
			 mesg = xvf_create_mesg("xvf_parse_float_line", 
				line, warn_mesg, 1);
                         xvf_error_wait(mesg, NULL,NULL); free(mesg);
                         return(false);
                         break;

		case  -1: 
			 sprintf(warn_mesg, "Default Float value '%g' must be greater than %g, less than %g", line_info->float_def, line_info->lower_float, line_info->upper_float);
			 mesg = xvf_create_mesg("xvf_parse_float_line", 
					      line, warn_mesg, 1);
                         xvf_error_wait(mesg, NULL,NULL); free(mesg);
                         return(false);
                         break;

		case  1:
			 sprintf(warn_mesg, "Default Float value '%g' must be >= 0",
					     line_info->float_def);
			 mesg = xvf_create_mesg("xvf_parse_float_line", 
				line, warn_mesg, 1);
                         xvf_error_wait(mesg, NULL,NULL); free(mesg);
                         return(false);
                         break;

		case  2: 
			 sprintf(warn_mesg, "Default Float value '%g' must be >  0",
                                             line_info->float_def);
			 mesg = xvf_create_mesg("xvf_parse_float_line", 
				line, warn_mesg, 1);
                         xvf_error_wait(mesg, NULL,NULL); free(mesg);
                         return(false);
                         break;
		case  0:
			 break;
		default:
			 break;

	   } /* end switch */

	   line_info->float_val = line_info->float_def;
	   sprintf(temp, "%g", line_info->float_def);
	   line_info->literal = xvf_strcpy(temp);

	} /* end if */


	else if (status < 18) 
	{
	      mesg = xvf_create_readerror_mesg("xvf_parse_float_line",
					   line, status, 19);
	      xvf_error_wait(mesg, NULL,NULL); free(mesg);
	      return(false);
      	}

	
	if ((VStrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
   	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(tmp_title);
	}

	if ((VStrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) free (line_info->description);
	    line_info->description = xvf_strcpy(tmp_desc);
	}

	if ((VStrcmp(tmp_var,"")) == 0) 
        {
	    mesg = xvf_create_mesg("xvf_parse_float_line", line,
			         "'variable' field MUST be specified", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
        }
	else 
	{ 
	    if (line_info->variable != NULL) free (line_info->variable);
	    line_info->variable = xvf_strcpy(tmp_var);
	}

	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_float_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->selected)))
	{
	    mesg = xvf_create_mesg("xvf_parse_float_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->optional)))
	{
	    mesg = xvf_create_mesg("xvf_parse_float_line", line,
		  		"'optional' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

        if ((line_info->optional ==0 ) && (line_info->opt_sel != 1))
	{
	    mesg = xvf_create_mesg("xvf_parse_float_line", line,
	    "if the 'optional' field = 0, then  the 'opt_sel' must be = 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->opt_sel)))
	{
	    mesg = xvf_create_mesg("xvf_parse_float_line", line,
		  		"'opt_sel' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->live)))
	{
	    mesg = xvf_create_mesg("xvf_parse_float_line", line,
		  		"'live' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

 	if (!(xvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = xvf_create_mesg("xvf_parse_float_line", line, 
		  		"X position is greater than width", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }

 	if (!(xvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = xvf_create_mesg("xvf_parse_float_line", line, 
		  		"Y position is greater than height", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }


	line_info->typeflag = FloatOpt;

	return(true);
}



/************************************************************
*
*      Routine: xvf_parse_logic_line(line, &line_info);
*
*      Purpose: Parses a Logic line  (-l:  typeflag = LogicalOpt)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*************************************************************/
int xvf_parse_logic_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_desc[MaxLength], tmp_title[MaxLength], tmp_var[MaxLength];
	char tmp_logic0[MaxLength], tmp_logic1[MaxLength]; 
	char flag;
	int status;
	char *mesg;

        status = sscanf(line, logic_scan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->optional, &line_info->opt_sel,
			&line_info->live,
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			&line_info->logical_def, tmp_title, 
			tmp_logic0, tmp_logic1, tmp_desc, tmp_var, 
			&line_info->logical_val);
	
	if (status == 18) line_info->logical_val = line_info->logical_def;

	else if (status < 18) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_logic_line",
					 line, status, 18);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
       	}

	if ((VStrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(tmp_title);
	}

	if ((VStrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) free (line_info->description);
	    line_info->description = xvf_strcpy(tmp_desc);
	}

	if ((VStrcmp(tmp_logic0," ")) == 0) line_info->val_labels[0] = NULL;
	else 
	{ 
	    if (line_info->val_labels[0] != NULL) 
		free (line_info->val_labels[0]);
	    line_info->val_labels[0] = xvf_strcpy(tmp_logic0);
	}

	if ((VStrcmp(tmp_logic1," ")) == 0) line_info->val_labels[1] = NULL;
	else 
	{ 
	    if (line_info->val_labels[1] != NULL) 
		free (line_info->val_labels[1]);
	    line_info->val_labels[1] = xvf_strcpy(tmp_logic1);
	}

	if ((VStrcmp(tmp_var,"")) == 0) 
        {
	    mesg = xvf_create_mesg("xvf_parse_logic_line", line,
		         	"'variable' field MUST be specified", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
        }
	else 
	{ 
	    if (line_info->variable != NULL) free (line_info->variable);
	    line_info->variable = xvf_strcpy(tmp_var);
	}


	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_logic_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->selected)))
	{
	    mesg = xvf_create_mesg("xvf_parse_logic_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->optional)))
	{
	    mesg = xvf_create_mesg("xvf_parse_logic_line", line,
		  		"'optional' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->opt_sel)))
	{
	    mesg = xvf_create_mesg("xvf_parse_logic_line", line,
		  		"'opt_sel' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->live)))
	{
	    mesg = xvf_create_mesg("xvf_parse_logic_line", line,
		  		"'live' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

 	if (!(xvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = xvf_create_mesg("xvf_parse_logic_line", line, 
		  		"X position is greater than width", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }

 	if (!(xvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = xvf_create_mesg("xvf_parse_logic_line", line, 
		  		"Y position is greater than height", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }

	if (!(xvf_check_boolean(line_info->logical_val)))
	{
	    mesg = xvf_create_mesg("xvf_parse_logic_line", line, 
		  		"Logical value must be 1 or 0", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->logical_def)))
	{
	    mesg = xvf_create_mesg("xvf_parse_logic_line", line, 
		  		"Logical default value must be 1 or 0", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	line_info->typeflag = LogicOpt;

	return(true);
}





/************************************************************
*
*      Routine: xvf_parse_cycle_line(line, &line_info);
*
*      Purpose: Parses a Cycle line  (-c:  typeflag = Cycle)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*************************************************************/
int xvf_parse_cycle_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_desc[MaxLength], tmp_title[MaxLength], tmp_var[MaxLength];
	char tmp_label[MaxLength]; 
	char flag;
	int status, i, j;
	char *mesg, *scanstr;

        status = sscanf(line, cycle_scan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->optional, &line_info->opt_sel,
			&line_info->live,
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			&line_info->cycle_num, &line_info->cycle_val,
			tmp_title, tmp_desc, tmp_var);
	
	if (status < 17) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_cycle_line",
					 line, status, 17);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
       	}

	if ((VStrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(tmp_title);
	}

	if ((VStrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) free (line_info->description);
	    line_info->description = xvf_strcpy(tmp_desc);
	}

	if ((VStrcmp(tmp_var,"")) == 0) 
        {
	    mesg = xvf_create_mesg("xvf_parse_cycle_line", line,
		         	"'variable' field MUST be specified", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
        }
	else 
	{ 
	    if (line_info->variable != NULL) free (line_info->variable);
	    line_info->variable = xvf_strcpy(tmp_var);
	}


	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_cycle_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->selected)))
	{
	    mesg = xvf_create_mesg("xvf_parse_cycle_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->optional)))
	{
	    mesg = xvf_create_mesg("xvf_parse_cycle_line", line,
		  		"'optional' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->opt_sel)))
	{
	    mesg = xvf_create_mesg("xvf_parse_cycle_line", line,
		  		"'opt_sel' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->live)))
	{
	    mesg = xvf_create_mesg("xvf_parse_cycle_line", line,
		  		"'live' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

 	if (!(xvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = xvf_create_mesg("xvf_parse_cycle_line", line, 
		  		"X position is greater than width", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }

 	if (!(xvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = xvf_create_mesg("xvf_parse_cycle_line", line, 
		  		"Y position is greater than height", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }

	if ((line_info->cycle_val < 0) || (line_info->cycle_val > 19))
	{
	    mesg = xvf_create_mesg("xvf_parse_cycle_line", line, 
		  		"Cycle value must be between 0 and 19", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if ((line_info->cycle_num < 2) || (line_info->cycle_num > 20))
	{
	    mesg = xvf_create_mesg("xvf_parse_cycle_line", line, 
		  		"Cycle number must be between 2 and 20", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	
        i = 0;
	if (line_info->title != NULL)
	{
	    while ((strncmp(&line[i], line_info->title, 
		        xvf_strlen(line_info->title))) != 0)
		i++;
	    i+= xvf_strlen(line_info->title); 
	}
	if (line_info->description != NULL)
	{
	    while ((strncmp(&line[i], line_info->description, 
		        xvf_strlen(line_info->description))) != 0)
		i++;
	    i+= xvf_strlen(line_info->description); 
	}
	if (line_info->variable != NULL)
	{
	    while ((strncmp(&line[i], line_info->variable, 
		        xvf_strlen(line_info->variable))) != 0)
		i++;
	    i+= xvf_strlen(line_info->variable);
	}

	scanstr = xvf_strcpy("%*[ ]%*['`]%[^'`]");
	for (j = 0; j < line_info->cycle_num; j++)
	{
	    status = sscanf(&line[i], scanstr, tmp_label);
	    if (status != 1) 
	    {
	        mesg = xvf_create_mesg("xvf_parse_cycle_line", line, 
			"Unable to read correct number of cycle labels", 1);
	        xvf_error_wait(mesg, NULL,NULL); free(mesg);
	        return(false);
	    }
	    line_info->val_labels[j] = xvf_strcpy(tmp_label);
	    i = i + xvf_strlen(line_info->val_labels[j]) + 3;
	    scanstr = xvf_strcpy("%*[ ]%*['`]%[^'`]%*[ '`]");
	}

	line_info->typeflag = Cycle;

	
	return(true);
}




/************************************************************
*
*      Routine: xvf_parse_list_line(line, &line_info);
*
*      Purpose: Parses a List line  (-x:  typeflag = List)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro 
*
*************************************************************/

int xvf_parse_list_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_desc[MaxLength], tmp_title[MaxLength], tmp_var[MaxLength];
	char tmp_label[MaxLength]; 
	char flag;
	int status, i, j;
	char *mesg, *scanstr;

        status = sscanf(line, list_scan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->optional, &line_info->opt_sel,
			&line_info->live,
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			&line_info->list_num, &line_info->list_val,
			tmp_title, tmp_desc, tmp_var);
	
	if (status < 17) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_list_line",
					 line, status, 17);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
       	}

	if ((VStrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(tmp_title);
	}

	if ((VStrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) free (line_info->description);
	    line_info->description = xvf_strcpy(tmp_desc);
	}

	if ((VStrcmp(tmp_var,"")) == 0) 
        {
	    mesg = xvf_create_mesg("xvf_parse_logic_line", line,
		         	"'variable' field MUST be specified", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
        }
	else 
	{ 
	    if (line_info->variable != NULL) free (line_info->variable);
	    line_info->variable = xvf_strcpy(tmp_var);
	}


	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_list_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->selected)))
	{
	    mesg = xvf_create_mesg("xvf_parse_list_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->optional)))
	{
	    mesg = xvf_create_mesg("xvf_parse_list_line", line,
		  		"'optional' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->opt_sel)))
	{
	    mesg = xvf_create_mesg("xvf_parse_list_line", line,
		  		"'opt_sel' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->live)))
	{
	    mesg = xvf_create_mesg("xvf_parse_list_line", line,
		  		"'live' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

 	if (!(xvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = xvf_create_mesg("xvf_parse_list_line", line, 
		  		"X position is greater than width", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }

 	if (!(xvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = xvf_create_mesg("xvf_parse_list_line", line, 
		  		"Y position is greater than height", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }

	if ((line_info->list_val < 1) || 
	    (line_info->list_val > line_info->list_num))
	{
	    mesg = xvf_create_mesg("xvf_parse_list_line", line, 
  		"List value must be less than or equal to number of items in list", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if ((line_info->list_num < 1) || (line_info->list_num > 20))
	{
	    mesg = xvf_create_mesg("xvf_parse_list_line", line, 
		"Number of list elements must be between 1 and 20", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	
        i = 0;
	if (line_info->title != NULL)
	{
	    while ((strncmp(&line[i], line_info->title, 
		        xvf_strlen(line_info->title))) != 0)
		i++;
	    i+= xvf_strlen(line_info->title); 
	}
	if (line_info->description != NULL)
	{
	    while ((strncmp(&line[i], line_info->description, 
		        xvf_strlen(line_info->description))) != 0)
		i++;
	    i+= xvf_strlen(line_info->description); 
	}
	if (line_info->variable != NULL)
	{
	    while ((strncmp(&line[i], line_info->variable, 
		        xvf_strlen(line_info->variable))) != 0)
		i++;
	    i+= xvf_strlen(line_info->variable);
	}

	scanstr = xvf_strcpy("%*[ ]%*['`]%[^'`]");
	for (j = 0; j < line_info->list_num; j++)
	{
	    status = sscanf(&line[i], scanstr, tmp_label);
	    if (status != 1) 
	    {
	        mesg = xvf_create_mesg("xvf_parse_list_line", line, 
			"Unable to read correct number of list labels", 1);
	        xvf_error_wait(mesg, NULL,NULL); free(mesg);
	        return(false);
	    }
	    line_info->val_labels[j] = xvf_strcpy(tmp_label);
	    i = i + xvf_strlen(line_info->val_labels[j]) + 3;
	    scanstr = xvf_strcpy("%*[ ]%*['`]%[^'`]%*[ '`]");
	}

	line_info->typeflag = List;

	
	return(true);
}




/************************************************************
*
*      Routine: xvf_parse_string_line(line, &line_info);
*
*      Purpose: Parses a String line  (-s: typeflag = StringOpt)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*************************************************************/

int xvf_parse_string_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_desc[MaxLength], tmp_title[MaxLength], tmp_var[MaxLength], 
	     tmp_default[10*MaxLength], tmp_string[10*MaxLength], 
	     tmp_literal[10*MaxLength];
	char flag;
	int  status;
	char *mesg;

	/*
	 *  Initialize the tmp strings to be empty so that if we call
	 *  vreplace_char() so that if the field hasn't been initialized by
	 *  sscanf() we don't core dump.
	 */
	tmp_string[0] =
	tmp_default[0] =
	tmp_literal[0] = '\0';

        status = sscanf(line, string_scan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->optional, &line_info->opt_sel,
			&line_info->live,
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			tmp_default, tmp_title, tmp_desc, 
			tmp_var, tmp_string, tmp_literal);
	
	/*
	 *  Replace all 0x1f characters with ' characters.
	 */
	(void) vreplace_char(tmp_string, 0x1f, '\'', tmp_string);
	(void) vreplace_char(tmp_default, 0x1f, '\'', tmp_default);
	(void) vreplace_char(tmp_literal, 0x1f, '\'', tmp_literal);

	if (status == 18)
        {
            if ((VStrcmp(tmp_literal," ")) == 0) line_info->literal = NULL;
            else
            {
                if (line_info->literal != NULL) free (line_info->literal);
                line_info->literal = xvf_strcpy(tmp_literal);
            }
	    if ((VStrcmp(tmp_string," ")) == 0) line_info->string_val = NULL;
            else
	    {
                if (line_info->string_val != NULL) free (line_info->string_val);
                line_info->string_val = xvf_strcpy(tmp_string);
	    }
	    if ((VStrcmp(tmp_default," ")) == 0) line_info->string_def = NULL;
            else
            {
                if (line_info->string_def != NULL) free (line_info->string_def);
                line_info->string_def = xvf_strcpy(tmp_default);
            }

        }

	else if (status == 17) 
	{
	    if ((VStrcmp(tmp_string," ")) == 0) 
	    {
		line_info->string_val = NULL;
		line_info->literal = NULL;
	    }
	    else 
	    { 
	        if (line_info->string_val != NULL) free (line_info->string_val);
	        line_info->string_val = xvf_strcpy(tmp_string);

	        if (line_info->literal != NULL) free (line_info->literal);
	        line_info->literal = xvf_strcpy(tmp_string);
	    }

	    if ((VStrcmp(tmp_default," ")) == 0) line_info->string_def = NULL;
            else
            {
                if (line_info->string_def != NULL) free (line_info->string_def);
                line_info->string_def = xvf_strcpy(tmp_default);
            }

	 }

	else if (status == 16) 
	{
	    if ((VStrcmp(tmp_default, " ")) == 0)
	    {
	 	line_info->string_val = NULL;
	 	line_info->literal = NULL;
	 	line_info->string_def = NULL;
	    }
	    else 
	    {
	        if (line_info->string_def != NULL) free (line_info->string_def);
	        line_info->string_def = xvf_strcpy(tmp_default);

	        if (line_info->string_val != NULL) free (line_info->string_val);
	        line_info->string_val = xvf_strcpy(tmp_default);

	        if (line_info->literal != NULL) free (line_info->literal);
	        line_info->literal    = xvf_strcpy(tmp_default);
	    }
	}

	if (status < 16) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_string_line",
					 line, status, 16);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if ((VStrcmp(tmp_default," ")) == 0) line_info->string_def = NULL;
	else 
	{ 
	    if (line_info->string_def != NULL) free (line_info->string_def);
	    line_info->string_def = xvf_strcpy(tmp_default);
	}

	if ((VStrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(tmp_title);
	}

	if ((VStrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) free (line_info->description);
	    line_info->description = xvf_strcpy(tmp_desc);
	}

	if ((VStrcmp(tmp_var,"")) == 0) 
        {
	    mesg = xvf_create_mesg("xvf_parse_string_line", line,
		         	"'variable' field MUST be specified", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
        }
	else 
	{ 
	    if (line_info->variable != NULL) free (line_info->variable);
	    line_info->variable = xvf_strcpy(tmp_var);
	}

	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_string_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->selected)))
	{
	    mesg = xvf_create_mesg("xvf_parse_string_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->optional)))
	{
	    mesg = xvf_create_mesg("xvf_parse_string_line", line,
		 		"'optional' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

        if ((line_info->optional ==0 ) && (line_info->opt_sel != 1))
	{
	    mesg = xvf_create_mesg("xvf_parse_string_line", line,
	    "if the 'optional' field = 0, then  the 'opt_sel' must be = 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->opt_sel)))
	{
	    mesg = xvf_create_mesg("xvf_parse_string_line", line,
		  		"'opt_sel' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->live)))
	{
	    mesg = xvf_create_mesg("xvf_parse_string_line", line,
		  		"'live' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

 	if (!(xvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = xvf_create_mesg("xvf_parse_string_line", line, 
		  		"X position is greater than width", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }

 	if (!(xvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = xvf_create_mesg("xvf_parse_string_line", line, 
		  		"Y position is greater than height", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }

	line_info->typeflag = StringOpt;


	return(true);
}




/************************************************************
*
*      Routine: xvf_parse_routine_line(line, &line_info);
*
*      Purpose: Parses a Routine line  (-r:  typeflag = Routine)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*************************************************************/

int xvf_parse_routine_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_desc[MaxLength], tmp_title[MaxLength], 
	     tmp_routine[MaxLength], flag;
	int status;
	char *mesg;

        status = sscanf(line, routine_scan, &flag, 
			&line_info->activate, &line_info->selected,
			&line_info->exec_type,
		        &line_info->width, &line_info->height, 
		  	&line_info->x, &line_info->y, 
			tmp_title, tmp_desc, tmp_routine);
	
	if (status < 11) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_routine_line",
					 line, status, 11);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if ((VStrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(tmp_title);
	}

	if ((VStrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) free (line_info->description);
	    line_info->description = xvf_strcpy(tmp_desc);
	}

	if ((VStrcmp(tmp_routine,"")) == 0) 
        {
	    mesg = xvf_create_mesg("xvf_parse_routine_line", line,
		         	"'routine' field MUST be specified", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
        }
	else
	{
	    if (line_info->variable != NULL) free (line_info->variable);
 	    line_info->routine = xvf_strcpy(tmp_routine);
	}

	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_routine_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->selected)))
	{
	    mesg = xvf_create_mesg("xvf_parse_routine_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if ((line_info->exec_type != 0) && 
	    (line_info->exec_type != 1) &&
	    (line_info->exec_type != 2) &&
	    (line_info->exec_type != 3) &&
	    (line_info->exec_type != 4))
	{
	    mesg = xvf_create_mesg("xvf_parse_routine_line", line,
		  		"'exec_type' field must be between 0 and 4", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	line_info->typeflag = Routine;

	return(true);
}




/************************************************************
*
*      Routine: xvf_parse_toggle_line(line, &line_info);
*
*      Purpose: Parses a Toggle line  (-T:  typeflag = Toggle)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*************************************************************/

int xvf_parse_toggle_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_desc[MaxLength], tmp_title[MaxLength], tmp_var[MaxLength],
	     flag;
	int status;
	char *mesg;

        status = sscanf(line, toggle_scan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->optional,  &line_info->opt_sel,
			&line_info->live,
		 	&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			&line_info->toggle_def, tmp_title, tmp_desc, 
			tmp_var, &line_info->toggle_val);
	


	if (status < 16) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_toggle_line",line, status, 15);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if ((VStrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(tmp_title);
	}

	if ((VStrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) free (line_info->description);
	    line_info->description = xvf_strcpy(tmp_desc);
	}

	if ((VStrcmp(tmp_var,"")) == 0) 
        {
	    mesg = xvf_create_mesg("xvf_parse_toggle_line", line,
		         	"'variable' field MUST be specified", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
        }
	else 
	{ 
	    if (line_info->variable != NULL) free (line_info->variable);
	    line_info->variable = xvf_strcpy(tmp_var);
	}

	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_toggle_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->selected)))
	{
	    mesg = xvf_create_mesg("xvf_parse_toggle_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->optional)))
	{
	    mesg = xvf_create_mesg("xvf_parse_toggle_line", line,
		  		"'optional' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

        if ((line_info->optional ==0 ) && (line_info->opt_sel != 1))
	{
	    mesg = xvf_create_mesg("xvf_parse_toggle_line", line,
	    "if the 'optional' field = 0, then  the 'opt_sel' must be = 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->opt_sel)))
	{
	    mesg = xvf_create_mesg("xvf_parse_toggle_line", line,
		  		"'opt_sel' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->live)))
	{
	    mesg = xvf_create_mesg("xvf_parse_toggle_line", line,
		  		"'live' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

 	if (!(xvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = xvf_create_mesg("xvf_parse_toggle_line", line, 
		  		"X position is greater than width", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }

 	if (!(xvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = xvf_create_mesg("xvf_parse_toggle_line", line, 
		  		"Y position is greater than height", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }

	line_info->typeflag = Toggle;


	return(true);
}




/************************************************************
*
*      Routine: xvf_parse_blank_line(line, &line_info);
*
*      Purpose: Parses a blank line  (-b:  typeflag = Blank)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*************************************************************/

int xvf_parse_blank_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_title[MaxLength], flag;
	int status;
	char *mesg;

        status = sscanf(line, blank_scan, &flag, 
			&line_info->xpos, &line_info->ypos, tmp_title); 

	if (status < 4) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_blank_line",
					 line, status, 4);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if ((VStrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(tmp_title);
	}

	line_info->typeflag = Blank;

	return(true);
}




/************************************************************
*
*      Routine: xvf_parse_pane_action_line(line, &line_info);
*
*      Purpose: Parses a Pane Action line  (-a:  typeflag = PaneAction)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*************************************************************/

int xvf_parse_pane_action_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_desc[MaxLength], tmp_title[MaxLength], tmp_var[MaxLength], 
	     flag;
	int status;
	char *mesg;

        status = sscanf(line, pane_action_scan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			tmp_title, tmp_desc, tmp_var);
	
	if (status < 10) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_pane_action_line",
					 line, status, 10);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if ((VStrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(tmp_title);
	}

	if ((VStrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) free (line_info->description);
	    line_info->description = xvf_strcpy(tmp_desc);
	}

	if ((VStrcmp(tmp_var,"")) == 0) 
        {
	    mesg = xvf_create_mesg("xvf_parse_pane_action_line", line,
		         	"'variable' field MUST be specified", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
        }
	else 
	{ 
	    if (line_info->variable != NULL) free (line_info->variable);
	    line_info->variable = xvf_strcpy(tmp_var);
	}

	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_pane_action_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->selected)))
	{
	    mesg = xvf_create_mesg("xvf_parse_pane_action_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	line_info->typeflag = PaneAction;

	return(true);
}



/************************************************************
*
*      Routine: xvf_parse_includepane_line(line, &line_info);
*
*      Purpose: Parses an IncludePane line  (-p:  typeflag = IncludePane)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro 
*
*************************************************************/

int xvf_parse_includepane_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_file[MaxLength], flag, *mesg;
	int status;

        status = sscanf(line, includepane_scan, &flag, tmp_file);

	if (status < 2) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_includepane_line",
					 line, status, 2);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}
	
	if ((VStrcmp(tmp_file," ")) == 0) 
	{
	    line_info->filename = NULL;
	    mesg = xvf_create_mesg("xvf_parse_includepane_line", line,
                                    "-p MUST be followed by filename", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}
	else 
	{ 
	    if (line_info->filename != NULL) free (line_info->filename);
	    line_info->filename = xvf_strcpy(tmp_file);
	}

	line_info->typeflag = IncludePane;

	return(true);
}



/************************************************************
*
*      Routine: xvf_parse_includesubform_line(line, &line_info);
*
*      Purpose: Parses an IncludeSubForm line  (-k:  typeflag = IncludeSubForm)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro 
*
*************************************************************/

int xvf_parse_includesubform_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_file[MaxLength], flag, *mesg;
	int status;

        status = sscanf(line, includesubform_scan, &flag, tmp_file);
	if (status < 2) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_includesubform_line",
					 line, status, 2);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}
	
	if ((VStrcmp(tmp_file," ")) == 0) 
	{
	    line_info->filename = NULL;
	    mesg = xvf_create_mesg("xvf_parse_includesubform_line", line,
                                   "-k MUST be followed by filename", 1);
	    xvf_error_wait(mesg, NULL, NULL); free(mesg);
	    return(false);
	}
	else 
	{ 
	    if (line_info->filename != NULL) free (line_info->filename);
	    line_info->filename = xvf_strcpy(tmp_file);
	}

	line_info->typeflag = IncludeSubForm;

	return(true);
}


/************************************************************
*
*      Routine: xvf_parse_mutexcl_line(line, &line_info);
*
*      Purpose: Parses a Mutually Exclusive line  (-C:  typeflag = MutExcl)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro 
*
*************************************************************/

int xvf_parse_mutexcl_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char flag, *mesg;
	int status;

        status = sscanf(line, "-%c %d", &flag, &line_info->logical_val);
	if (flag != 'C') return(false);
	if (status < 2) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_mutexcl_line",
					 line, status, 2);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}
	
	line_info->typeflag = MutExcl;

	return(true);
}


/************************************************************
*
*      Routine: xvf_parse_workspace_line(line, &line_info);
*
*      Purpose: Parses a Workspace line  (-W:  typeflag = WorkWidget)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro 
*
*************************************************************/


int xvf_parse_workspace_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char flag, *mesg;
	int  status;
	char tmp_desc[MaxLength], tmp_title[MaxLength], tmp_var[MaxLength]; 
	long tmp_wksp_address;

        status = sscanf(line, workspace_scan, &flag,
			&line_info->width, &line_info->height,
                        &line_info->x, &line_info->y,
                        &line_info->xpos, &line_info->ypos,
			tmp_title, tmp_desc, tmp_var, &tmp_wksp_address);
	if (flag != 'w') return(false);

        if (status == 11)
	{
	    line_info->workspace = (Widget) tmp_wksp_address;
	}
	else if (status < 10) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_workspace_line",
					 line, status, 10);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if ((VStrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(tmp_title);
	}
	if ((VStrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) free (line_info->description);
	    line_info->description = xvf_strcpy(tmp_desc);
	}
	if ((VStrcmp(tmp_var,"")) == 0) 
        {
	    mesg = xvf_create_mesg("xvf_parse_workspace_line", line,
		         	"'variable' field MUST be specified", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
        }
	else 
	{ 
	    if (line_info->variable != NULL) free (line_info->variable);
	    line_info->variable = xvf_strcpy(tmp_var);
	}

	if (!(xvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = xvf_create_mesg("xvf_parse_workspace_line", line, 
		  		"X position is greater than width", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }

	if (!(xvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = xvf_create_mesg("xvf_parse_workspace_line", line, 
		  		"Y position is greater than height", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }

	line_info->typeflag = WorkWidget;
	return(true);
}

/************************************************************
*
*      Routine: xvf_parse_libcall_line(line, &line_info);
*
*      Purpose: Parses a LibCall line  (-L:  typeflag = LibCall)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro 
*
*************************************************************/

int xvf_parse_libcall_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_call[MaxLength], flag, *mesg;
	int status;

        status = sscanf(line, libcall_scan, &flag, tmp_call);
	if (status < 2) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_libcall_line",
					 line, status, 2);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}
	
	if ((VStrcmp(tmp_call," ")) == 0) 
	{
	    line_info->lib_call = NULL;
	    mesg = xvf_create_mesg("xvf_parse_libcall_line", line,
                                   "-L MUST be followed by library call", 1);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
	    if (status == 0) return(false);
	}
	else 
	{ 
	    if (line_info->lib_call != NULL) free (line_info->lib_call);
	    line_info->lib_call = xvf_strcpy(tmp_call);
	}

	line_info->typeflag = LibCall;

	return(true);
}



/************************************************************
*
*      Routine: xvf_parse_ansinfile_line(line, &line_info);
*
*      Purpose: Parses an AnswerInfile line  (-A:  typeflag = AnswerInfile)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int xvf_parse_ansinfile_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_title[MaxLength], tmp_var[MaxLength], 
	     tmp_filename[MaxLength], tmp_default[MaxLength], 
	     tmp_literal[MaxLength];
	char flag;
	int status;
	char *mesg;

        status = sscanf(line, ansinfile_scan, &flag, 
			&line_info->activate, &line_info->selected,  
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			tmp_default, tmp_title, tmp_filename, tmp_literal);
	
	if (status == 13)
        {
            if ((VStrcmp(tmp_literal," ")) == 0) line_info->literal = NULL;
            else
            {
                if (line_info->literal != NULL) free (line_info->literal);
                line_info->literal = xvf_strcpy(tmp_literal);
            }
	    if ((VStrcmp(tmp_filename," ")) == 0) line_info->filename = NULL;
            else
            {
                if (line_info->filename != NULL) free (line_info->filename);
                line_info->filename = xvf_strcpy(tmp_filename);
            }
            if ((VStrcmp(tmp_default," ")) == 0) line_info->file_def = NULL;
            else
            {
                if (line_info->file_def != NULL) free (line_info->file_def);
                line_info->file_def = xvf_strcpy(tmp_default);
            }
        }

	else if (status == 12) 
	{
	    if ((VStrcmp(tmp_filename," ")) == 0) 
	    {
		line_info->filename = NULL;
		line_info->literal = NULL;
	    }
	    else 
	    { 
	        if (line_info->filename != NULL) free (line_info->filename);
	        line_info->filename = xvf_strcpy(tmp_filename);
	
	        if (line_info->literal != NULL) free (line_info->literal);
                line_info->literal = xvf_strcpy(tmp_filename);

	    }

	    if ((VStrcmp(tmp_default," ")) == 0) line_info->file_def = NULL;
            else
            {
                if (line_info->file_def != NULL) free (line_info->file_def);
                line_info->file_def = xvf_strcpy(tmp_default);
            }

	}

	else if (status == 11) 
	{
	    if ((VStrcmp(tmp_default, " ")) == 0)
	    {
	 	line_info->filename = NULL;
	 	line_info->literal = NULL;
	 	line_info->file_def = NULL;

	    }
	    else 
	    {
		if (line_info->file_def != NULL) free (line_info->file_def);
                line_info->file_def = xvf_strcpy(tmp_default);

		if (line_info->filename != NULL) free (line_info->filename);
                line_info->filename = xvf_strcpy(tmp_default);
	
	  	if (line_info->literal != NULL) free (line_info->literal);
                line_info->literal    = xvf_strcpy(tmp_default);
	    }
	}

	else if (status < 11) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_ansinfile_line",
					 line, status, 11);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if ((VStrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(tmp_title);
	}

	line_info->description = NULL;
	line_info->variable = NULL;

	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_ansinfile_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->selected)))
	{
	    mesg = xvf_create_mesg("xvf_parse_ansinfile_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

 	if (!(xvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = xvf_create_mesg("xvf_parse_ansinfile_line", line, 
			 	"X position is greater than width", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }

 	if (!(xvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = xvf_create_mesg("xvf_parse_ansinfile_line", line, 
		  		"Y position is greater than height", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }

	line_info->live = true;
	line_info->typeflag = AnswerInfile;

	return(true);
}


/************************************************************
*
*      Routine: xvf_parse_ansoutfile_line(line, &line_info);
*
*      Purpose: Parses an Answer Outfile line (-Z:  typeflag = AnswerOutfile)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int xvf_parse_ansoutfile_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char tmp_title[MaxLength], tmp_var[MaxLength], 
	     tmp_filename[MaxLength], tmp_default[MaxLength], 
	     tmp_literal[MaxLength];
	char flag;
	int status;
	char *mesg;

        status = sscanf(line, ansoutfile_scan, &flag, 
			&line_info->activate, &line_info->selected,  
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			tmp_default, tmp_title, tmp_filename, tmp_literal);
	
	if (status == 13)
        {
            if ((VStrcmp(tmp_literal," ")) == 0) line_info->literal = NULL;
            else
            {
                if (line_info->literal != NULL) free (line_info->literal);
                line_info->literal = xvf_strcpy(tmp_literal);
            }
	    if ((VStrcmp(tmp_filename," ")) == 0) line_info->filename = NULL;
            else
            {
                if (line_info->filename != NULL) free (line_info->filename);
                line_info->filename = xvf_strcpy(tmp_filename);
            }
            if ((VStrcmp(tmp_default," ")) == 0) line_info->file_def = NULL;
            else
            {
                if (line_info->file_def != NULL) free (line_info->file_def);
                line_info->file_def = xvf_strcpy(tmp_default);
            }
        }

	else if (status == 12) 
	{
	    if ((VStrcmp(tmp_filename," ")) == 0) 
	    {
		line_info->filename = NULL;
		line_info->literal = NULL;
	    }
	    else 
	    { 
	        if (line_info->filename != NULL) free (line_info->filename);
	        line_info->filename = xvf_strcpy(tmp_filename);
	
	        if (line_info->literal != NULL) free (line_info->literal);
                line_info->literal = xvf_strcpy(tmp_filename);

	    }

	    if ((VStrcmp(tmp_default," ")) == 0) line_info->file_def = NULL;
            else
            {
                if (line_info->file_def != NULL) free (line_info->file_def);
                line_info->file_def = xvf_strcpy(tmp_default);
            }

	}

	else if (status == 11) 
	{
	    if ((VStrcmp(tmp_default, " ")) == 0)
	    {
	 	line_info->filename = NULL;
	 	line_info->literal = NULL;
	 	line_info->file_def = NULL;

	    }
	    else 
	    {
		if (line_info->file_def != NULL) free (line_info->file_def);
                line_info->file_def = xvf_strcpy(tmp_default);

		if (line_info->filename != NULL) free (line_info->filename);
                line_info->filename = xvf_strcpy(tmp_default);
	
	  	if (line_info->literal != NULL) free (line_info->literal);
                line_info->literal    = xvf_strcpy(tmp_default);
	    }
	}

	else if (status < 11) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_ansinfile_line",
					 line, status, 11);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if ((VStrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) free (line_info->title);
	    line_info->title = xvf_strcpy(tmp_title);
	}

	line_info->description = NULL;
	line_info->variable = NULL;

	if (!(xvf_check_boolean(line_info->activate)))
	{
	    mesg = xvf_create_mesg("xvf_parse_ansoutfile_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (!(xvf_check_boolean(line_info->selected)))
	{
	    mesg = xvf_create_mesg("xvf_parse_ansoutfile_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

 	if (!(xvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = xvf_create_mesg("xvf_parse_ansoutfile_line", line, 
			 	"X position is greater than width", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }

 	if (!(xvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = xvf_create_mesg("xvf_parse_ansoutfile_line", line, 
		  		"Y position is greater than height", 2);
	    status = xvf_warn_wait(mesg, NULL, NULL, NULL); free(mesg);
            if (status == 0) return(false);
        }

	line_info->live = true;
	line_info->typeflag = AnswerOutfile;

	return(true);
}


/************************************************************
*
*      Routine: xvf_parse_end_line(line, &line_info);
*
*      Purpose: Parses an End line  (-E:  typeflag = End)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro 
*
*
*************************************************************/

int xvf_parse_end_line(line, line_info)
char *line;
Line_Info *line_info;
{
	char flag, *mesg;
	int status;

        status = sscanf(line, "-%c", &flag);
	if (status < 1) 
	{
	    mesg = xvf_create_readerror_mesg("xvf_parse_end_line",
					 line, status, 1);
	    xvf_error_wait(mesg, NULL,NULL); free(mesg);
	    return(false);
	}

	if (flag != 'E') return(false);
	
	line_info->typeflag = End;

	return(true);
}



/************************************************************
*
*  Routine Name: xvf_create_readerror_mesg & xvf_create_mesg
*
*      Purpose: Creates an appropriate error message for an incorrect
*		database line or warning for suspected problem
*		in the database line
*
*        Input: routine_name - name of the routine that called it
*		line - the database line
*		mesg - the error message
*
*   Written By: Danielle Argiro & Stephanie Hallett
*
*
*************************************************************/


char *xvf_create_readerror_mesg(routine_name, line, status, expected)
char *routine_name, *line;
int  status, expected;
{
	char *mesg_return; 
	int  length; 
	char errline[MaxLength], mesg[MaxLength];

	sprintf(errline, "     Error in line '%s'", line);
	sprintf(mesg, "     Only able to read %d out of %d required fields.",
                            status, expected);
	length = xvf_strlen(errline) + xvf_strlen(mesg) + 
		 xvf_strlen(routine_name) + 5;

	mesg_return = (char *) calloc (1,length);
	sprintf(mesg_return,  "%s:\n%s\n%s",routine_name, errline, mesg);
	return (mesg_return);
}


char *xvf_create_mesg(routine_name, line, mesg, flag)
char *routine_name, *line, *mesg;
int   flag;  /* 1 for error, 2 for warning */
{
	char *mesg_return;
        char warnline[MaxLength];
        int  length;

	if (flag == 1)
	    sprintf(warnline, "    Error: in line '%s'", line);
        else if (flag == 2)
	    sprintf(warnline, "    Warning: in line '%s'", line);
	else 
        {
	    fprintf(stderr, "Unknown flag passed to xvf_create_mesg\n");
	    return(NULL);
        }
	

	length = xvf_strlen(warnline) + xvf_strlen(mesg) + 
		 xvf_strlen(routine_name) + 5;
	mesg_return = (char *) calloc (1,length);
	sprintf(mesg_return, "%s:\n%s\n%s\n", routine_name, warnline, mesg);
	return(mesg_return);
	
}


/************************************************************
*
*  Routine Name: xvf_clear_line_info 
*
*      Purpose:  takes a line_info structure and initializes all
*		 values:  strings go to null, integers, etc to 0. 
*		 Useful since allocation of line_info structure 
*		 does not guarantee anything but initial garbage
*		 in fields.
*
*        Input: line_info - pointer to the line_info structure
*
*   Written By: Danielle Argiro & Stephanie Hallett
*
*
*************************************************************/

xvf_clear_line_info(line_info)
Line_Info *line_info;
{
	/*
	 *  clear all the line_info structure  except the we need
	 *  to set the version to 4.1
	 */
	bzero((char *) line_info, sizeof(Line_Info));
	line_info->version     = 4.1;

}  /* end xvf_clear_line_info */

