 /*
  * Khoros: $Id: graphics.c,v 1.1 1991/05/10 15:56:56 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: graphics.c,v 1.1 1991/05/10 15:56:56 khoros Exp $";
#endif

 /*
  * $Log: graphics.c,v $
 * Revision 1.1  1991/05/10  15:56:56  khoros
 * Initial revision
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "X3D.h"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: graphics.c 
   >>>>               
   >>>>   description: Device Routines
   >>>>              
   >>>>      routines: 
   >>>>			X3D_close_device()		      <<<<
   >>>>			X3D_inquire_device()		      <<<<
   >>>>              
   >>>> modifications:
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/************************************************************
*
*  MODULE NAME:  X3D_close_device
*
*      PURPOSE:  
*
*        INPUT:  the graphics id 
*		 the opened output file id (if postsrc)
*		 the device langauge to be used (X11, postsrc)
*
*    CALLED BY:  application program
*
*   WRITTEN BY:  Mike Lang & Mark Young
*
*
*************************************************************/

X3D_close_device(id)

int     id;
{
	X3DGraphics	*graphics;
	char		header[512];

        if (!(graphics = _X3D_get_graphics(id)))
        {
           fprintf (stderr,"X3D_close_device:");
           fprintf (stderr,"\t unknown graphics id %d\n",id);
           return;
        }

	X3D_draw[graphics->device].close(graphics);
}



/************************************************************
*
*  MODULE NAME:  X3D_inquire_device
*
*      PURPOSE:  
*
*        INPUT:  id
*
*    CALLED BY:  application program
*
*   WRITTEN BY:  Mike Lang
*
*
*************************************************************/

int X3D_inquire_device(id)
int     id;
{
	X3DGraphics	*graphics;

        if (!(graphics = _X3D_get_graphics(id)))
        {
           fprintf (stderr,"X3D_inquire_device:");
           fprintf (stderr,"\t unknown graphics id %d\n",id);
           return(NULL);
        }
	return(graphics->device);
}
