 /*
  * Khoros: $Id: inquire_2D.c,v 1.1 1991/05/10 15:56:56 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: inquire_2D.c,v 1.1 1991/05/10 15:56:56 khoros Exp $";
#endif

 /*
  * $Log: inquire_2D.c,v $
 * Revision 1.1  1991/05/10  15:56:56  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include 	"X3D.h"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>             file name: inquire_2D.c                   <<<<
   >>>>                                                       <<<<
   >>>>                2D Inquiry Utilities 		      <<<<
   >>>>                                                       <<<<
   >>>>  	       X2D_inquire_window()                   <<<<
   >>>>  	       X2D_inquire_viewport()                 <<<<
   >>>>  	       X2D_inquire_wc_min_max()               <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */
 

/************************************************************
*
*  MODULE NAME: X2D_inquire_window
*
*      PURPOSE: Inquires the minimum and maximum device coordinate
*		for a given X11 Window.
*
*        INPUT: id        - X3D graphics structure ID
*		x, y,
*		width,
*		height	  - the offset and size of the window (in device
*			    coordinates).
*
*       OUTPUT: none
*
*    CALLED BY: application program
*
*   WRITTEN BY: Mark Young
*
*
************************************************************/

X2D_inquire_window (id, x, y, width, height)

int	id;
short	*x, *y, *width, *height;
{
	X3DGraphics 	*graphics;


	if (!(graphics = _X3D_get_graphics(id)))
	{
	   (void) fprintf (stderr,"X2D_inquire_window:");
	   (void) fprintf (stderr,"\t unknown graphics id %d\n",id);
	   return;
	}

	if (graphics->device == X11)
	{
	   *x = graphics->X11_xmin;
	   *y = graphics->X11_ymin;
	   *width  = graphics->X11_xmax - *x;
	   *height = graphics->X11_ymax - *y;
	}
	else if (graphics->device == POSTSCR)
	{
	   *x = graphics->POS_xmin;
	   *y = graphics->POS_ymin;
	   *width  = graphics->POS_xmax - *x;
	   *height = graphics->POS_ymax - *y;
	}
	else if (graphics->device == IMPRESS)
	{
	   *x = graphics->IMP_xmin;
	   *y = graphics->IMP_ymin;
	   *width  = graphics->IMP_xmax - *x;
	   *height = graphics->IMP_ymax - *y;
	}
	else if (graphics->device == HPGL)
	{
	   *x = graphics->HPGL_xmin;
	   *y = graphics->HPGL_ymin;
	   *width  = graphics->HPGL_xmax - *x;
	   *height = graphics->HPGL_ymax - *y;
	}
}



/************************************************************
*
*  MODULE NAME: X2D_inquire_viewport
*
*      PURPOSE: Inquires the minimum and maximum viewport values
*		for a given X3D graphics structure.
*
*        INPUT: id     - X3D graphics structure ID
*		xmin   - A float containing the x minimum viewport 
*			 normalized device coordinate value.
*		xmax   - A float containing the x maximum world 
*			 normalized device coordinate value.
*		ymin   - A float containing the y minimum viewport 
*			 normalized device coordinate value.
*		ymax   - A float containing the y maximum world 
*			 normalized device coordinate value.
*
*       OUTPUT: none
*
*    CALLED BY: application program
*
*   WRITTEN BY: Mark Young
*
*
************************************************************/

X2D_inquire_viewport (id, xmin, xmax, ymin, ymax)

int	id;
Real	*xmin, *xmax, *ymin, *ymax;
{
	X3DGraphics *graphics;

	if (!(graphics = _X3D_get_graphics(id)))
	{
	   (void) fprintf (stderr,"X2D_inquire_viewport:");
	   (void) fprintf (stderr,"\t unknown graphics id %d\n",id);
	   return;
	}
	*xmin = graphics->xv_min;
	*xmax = graphics->xv_max;
	*ymin = graphics->yv_min;
	*ymax = graphics->yv_max;
}



/************************************************************
*
*  MODULE NAME: X2D_inquire_wc_min_max
*
*      PURPOSE: Inquires the minimum and maximum world coordinate
*		points for a given X3D graphics structure.
*
*        INPUT: id     - X3D graphics structure ID
*		wc_min - A coord containing the minimum world 
*			 coordinate values
*		wc_max - A coord containing the maximum world 
*			 coordinate values
*
*       OUTPUT: none
*
*    CALLED BY: application program
*
*   WRITTEN BY: Mark Young
*
*
*************************************************************/

X2D_inquire_wc_min_max (id, wc_min, wc_max)

int	id;
Coord	*wc_min, *wc_max;
{
	X3DGraphics *graphics;

	if (!(graphics = _X3D_get_graphics(id)))
	{
	   (void) fprintf (stderr,"X2D_inquire_wc_min_max:");
	   (void) fprintf (stderr,"\t unknown graphics id %d\n",id);
	   return;
	}

	*wc_min = graphics->wc_min;
	*wc_max = graphics->wc_max;
}
