 /*
  * Khoros: $Id: configtb.h,v 1.2 1992/03/20 22:52:10 dkhoros Exp $
  */

 /*
  * $Log: configtb.h,v $
 * Revision 1.2  1992/03/20  22:52:10  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: configtb.h
 >>>>            Author: Steven Jorgensen 
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _configtb_h_
#define _configtb_h_

typedef struct cfg_entry {
	char *form_var;		/* string as it appears on form */
	char *var_val;		/* substitute pattern for variable & sub_str */
	int var_indx;		/* index value of the form */
	int entry_cnt;		/* count of # of entries for this variable */
	char **entry_list;	/* array of entries for this entry */
	int file_var_indx;	/* coresponding file variable count */
	char **variable;	/* array of file variables that apply */
	char **sub_str;		/* array of file file values that apply */
	} *CFG_ENTRY;

#define ALLOCSIZE	5
#define FORMVAR(x)	(x->form_var)
#define VARVAL(x)	(x->var_val)
#define VARINDX(x)	(x->var_indx)
#define FILEVARINDX(x)	(x->file_var_indx)
#define VARIABLE(x)	(x->variable)
#define IVARIABLE(x,i)	((x)->variable[i])
#define SUBSTR(x)	(x->sub_str)
#define ISUBSTR(x,i)	((x)->sub_str[i])
#define ENTRYCNT(x)	(x->entry_cnt)
#define ENTRYLST(x)	(x->entry_list)
#define IENTRYLST(x,i)  ((x)->entry_list[i])

CFG_ENTRY create_cfg_entry();	/* create an empty cfg entry */
CFG_ENTRY *add_cfg_entry();	/* allocate and set a config entry for
				   one line from the km.config file */
CFG_ENTRY *config2list();	/* routine that parses the string from
				   km.config */
CFG_ENTRY *parsefile();		/* parse input from mach file to determine
				   specific variable values */
void add_var_entry();		/* allocate and set a value entry for
				   a file variable a inside a CFG_ENTRY */
void free_cfg_list();		/* clear out a config list */
void clear_var_vals();		/* clear the variable values */
void add_entry();		/* add a variable entry */
void cfg2output();		/* take info in CFG_ENTRY structs, and
				   put it back in the mach file. */
#endif
