 /*
  * Khoros: $Id: rmdir.c,v 1.4 1992/03/26 00:07:06 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: rmdir.c,v 1.4 1992/03/26 00:07:06 dkhoros Exp $";
#endif

 /*
  * $Log: rmdir.c,v $
 * Revision 1.4  1992/03/26  00:07:06  dkhoros
 * VirtualPatch5
 *
  */
/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 *
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */
#include "kraftsman.h"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>     file name: rmdir.c                                <<<<
   >>>>                                                       <<<<
   >>>>   description: File Utility                           <<<<
   >>>>                                                       <<<<
   >>>>      routines: int vrmdir()                           <<<<
   >>>>                                                       <<<<
   >>>> modifications:                                        <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/***********************************************************************
*
*  Routine Name: vrmdir()
*
*          Date: 12/4/91
*
*       Purpose: To remove the directory specified by "path" with all
*		 files within the directory deleted too.  It calls the system 
*		 routine rmdir() and unlink().
*
*         Input: path -- pathname of directory to delete
*
*        Output: returns 0 on success
*			-1 on fail
*
*    Written By: Steven Jorgensen
*
* Modifications:
*
***********************************************************************/
int vrmdir(path)
  char *path;
  {
    int rtl = 0,cnt, i;
    char *npath,**npaths, *var;
    struct stat buf;

    if (path == NULL)
      return(-1);

    if ((npath = vfullpath(path,NULL,NULL)) == NULL)
      return(-1);
#ifndef SYSV
    if (lstat(npath,&buf) == -1) 
      return(-1);
#else
    if (stat(npath,&buf) == -1) 
      return(-1);
#endif

    if (S_IFREG & buf.st_mode == S_IFREG || S_IFLNK & buf.st_mode == S_IFLNK)
      {
	rtl = unlink(npath);
	free(npath);
	return(rtl);
      }

    npaths = vlistdir(NULL, npath, XV_DIR | XV_PATH, 0, &cnt);
    for (i = 0 ; i < cnt; i++)
      {
	var = strchr(npaths[i],'.');
        if (var != NULL && (strcmp(var,"..") == 0 || strcmp(var,".") == 0))
	  continue;
        else if ((rtl = vrmdir(npaths[i])) == -1)
	  break;
      }
    vfreelist(npaths,cnt);
    if(rtl == -1)
      return(rtl);

    npaths = vlistdir(NULL,npath,XV_DOT|XV_SOCK|XV_PATH|XV_LINK|XV_FILE,0,&cnt);
    for (i = 0 ; i < cnt; i++)
      {
	var = strchr(npaths[i],'.');
	if (var != NULL && (strcmp(var,"..") == 0 || strcmp(var,".") == 0))
	  continue;
        else if ((rtl = unlink(npaths[i])) == -1)
	  break;
      }
    vfreelist(npaths,cnt);
    if (rtl == -1)
      return(rtl);
    rtl = rmdir(npath);
    free(npath);
    return(rtl);
  }
