 /*
  * Khoros: $Id: xprism2.h,v 1.1 1991/05/10 15:59:38 khoros Exp $
  */

 /*
  * $Log: xprism2.h,v $
 * Revision 1.1  1991/05/10  15:59:38  khoros
 * Initial revision
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: xprism2.h
   >>>>                        
   >>>>   description: xprism2 defines and structures
   >>>>               
   >>>> modifications:
   >>>>			John M. Salas Aug 8, 1990
   >>>>			- rearranged and added data structures
   >>>>                 - added structure to handle multiple areas
   >>>>                 - added #define's for defaults and mins-maxs
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xprism2_h_
#define _xprism2_h_

#include	"unmcopyright.h"	  /* Copyright 1990 by UNM */
#include 	"xprism.h"
#include	"form_info.h"

char	**av,		/* argv and argc used by gparams */
	*program, 	/* a pointer to the program name argv[0] */
	*calloc();

int 	ac;

/************************************************************************
 *									*
 *			Xprism2 Args Structure 				*
 *									*
 *									*
 ************************************************************************/

#define PRINTEROUT_HEIGHT		7.0
#define PRINTEROUT_WIDTH		7.0
#define PRINTEROUT_XOFFSET		1.0
#define PRINTEROUT_YOFFSET		3.0

#define PRINTEROUT_OFFSET_MIN		0.0
#define PRINTEROUT_OFFSET_MAX		8.0
#define PRINTEROUT_HEIGHT_MIN		1.0
#define PRINTEROUT_HEIGHT_MAX		17.0
#define PRINTEROUT_WIDTH_MIN		1.0
#define PRINTEROUT_WIDTH_MAX		11.0

#define MAX_AREAS			1
#define MAX_PLOTS			20

#define VECTOR_OUTPUT			1
#define RASTER_OUTPUT			2

#define FLUSH_PRINTEROUTPUT		TRUE
#define INVERT_PRINTEROUTPUT		TRUE
#define LANDSCAPE_PRINTEROUTPUT		FALSE
#define MONO_PRINTEROUTPUT		TRUE

#define MIN_PLOT_TYPE			0
#define MAX_PLOT_TYPE			PLOT_LINEMARKER - PLOT_2D
#define MIN_LINE_TYPE			SOLID
#define MAX_LINE_TYPE			ODD_DASHED
#define MIN_MARKER_TYPE			NO_MARKER
#define MAX_MARKER_TYPE			BOX
#define MIN_COLOR_TYPE			WHITE
#define MAX_COLOR_TYPE			SIENNA
#define MIN_FONT_TYPE			0
#define MAX_FONT_TYPE			6
#define MIN_DATA_FORMAT			1
#define MAX_DATA_FORMAT			2
#define MIN_DATA_TYPE			1
#define MAX_DATA_TYPE			4
#define MIN_MACHINE_TYPE		0
#define MAX_MACHINE_TYPE		NUMBER_MACHINES - 1
#define MIN_TICS			0
#define MAX_TICS			20

#define XPRISM2_FORM			"$KHOROS_HOME/repos/xprism/xprism2.form"
#define INDIR				"./"
#define OUTDIR				"./"

typedef struct _xp2_plot_info {

  char	*i_file;		/* input file STRING */
  char	*func_str;		/* function STRING */
  char	*legend_str;		/* legend string STRING */
  int	plot_type;		/* plot type INT */
  int	marker_type;		/* marker type INT */
  int	line_type;		/* line type INT */
  int	plot_color;		/* color for plot INT */

  int	whichband;		/* band number to plot if multiband viff */
  int	cmplx;		 	/* complex type to plot if complex */

  int	step_size;		/* step size FLOAT*/
  int	begin_point;		/* point to begin plotting INT */
  int	end_point;		/* point to end plotting INT */

  int	data_format;		/* X or XY data is to be plotted INT */
  int	data_type;		/* byte, short, integer, or float data INT */
  int	machine_type;		/* the machine the data was created on INT */
  int	active;			/* Is the plot drawn? LOGIC */

  char	*func_xmin;		/* function xmin FLOAT */
  char	*func_xmax;		/* function xmax FLOAT */
  char	*func_ptnum;		/* #points to be evaluated in function INT*/

} xp2_plot_info_struct;

/*
   This structure contains all the information about the plot area, i.e. default
   values for that plot area and the structure that contains the information
   about each plot in that area.
*/

typedef struct _xp2_area_info {

  char	*title;			/* plot title STRING */
  char	*xaxis;			/* x-axis label STRING */
  char	*yaxis;			/* y-axis label STRING */

  int	xaxis_font;		/* font for xaxis INT */
  int	yaxis_font;		/* font for yaxis INT */
  int	numbers_font;		/* font for numbers INT */
  int	legend_font;		/* font for legend INT */
  int	title_font;		/* font for title INT */

  int	plot_type;		/* plot type INT */
  int	marker_type;		/* marker type INT */
  int	line_type;		/* line type INT */

  int	whichband;		/* band number to plot if multiband viff */
  int	cmplx;		 	/* complex type to plot if complex */

  int	plot_color;		/* color for plot INT */
  int	color;			/* default color for parameters below INT */
  int	title_color;		/* color for title INT */
  int	xaxis_label_color;	/* color for x-axis label INT */
  int	yaxis_label_color;	/* color for y-axis labeI INT */
  int	xaxis_color;		/* color for x-axis INT */
  int	yaxis_color;		/* color for y-axis INT */
  int	num_xaxis_color;	/* color for x-axis numerical labels INT */
  int	num_yaxis_color;	/* color for y-axis numerical labels INT */
  int	grid_color;		/* default color for grid INT */
  int	legend_color;		/* color for legend INT */

  int	legend;			/* legend on or off? LOGIC */
  int	box;			/* box on or off? LOGIC */
  int	numerical_labels;	/* numerical labels on or off? LOGIC */
  int	axes;			/* axes on or off? LOGIC */
  int	grid;			/* grid on or off? LOGIC */
  int	auto_scale;		/* use auto scale true or false? LOGIC */
  int	clear_labels;		/* show all labels true or false? LOGIC */

  int	rescale_relabel;	/* are the labels equal to the data? LOGIC */

  Coord scale;			/* Are the axes linear, log, ...? LOGIC */

  int	step_size;		/* step size FLOAT*/
  int	begin_point;		/* point to begin plotting INT */
  int	end_point;		/* point to end plotting INT */

  int	data_format;		/* X or XY data is to be plotted INT */
  int	data_type;		/* byte, short, integer, or float data INT */
  int	machine_type;		/* the machine the data was created on INT */
  int	active;			/* Is the plot drawn? LOGIC */

  float	xmin;			/* x-axis data minimum FLOAT */
  float	xmax;			/* x-axis data maximum FLOAT */
  float	ymin;			/* y-axis data minimum FLOAT */
  float	ymax;			/* y-axis data maximum FLOAT */
  float	major_xint;		/* x-axis data major interval FLOAT */
  float	major_yint;		/* y-axis data major interval FLOAT */
  float	xlabel_min;		/* x-axis labeled minimum FLOAT */
  float	xlabel_max;		/* x-axis labeled maximum FLOAT */
  float	ylabel_min;		/* y-axis labeled minimum FLOAT */
  float	ylabel_max;		/* y-axis labeled maximum FLOAT */
  float	major_xlabel_int;	/* x-axis labeled major interval FLOAT */
  float	major_ylabel_int;	/* y-axis labeled major interval FLOAT */
  int	x_tics;			/* number of minor x tics INT */
  int	y_tics;			/* number of minor y tics INT */

  char	*func_xmin;		/* function xmin FLOAT */
  char	*func_xmax;		/* function xmax FLOAT */
  char	*func_ptnum;		/* #points to be evaluated in function INT */

  int number_plots;
  int numerical_relabel_specified_xmin;
  int numerical_scale_specified_xmin;
  int numerical_relabel_specified_xmax;
  int numerical_scale_specified_xmax;
  int numerical_relabel_specified_xint;
  int numerical_scale_specified_xint;
  int numerical_relabel_specified_ymax;
  int numerical_scale_specified_ymax;
  int numerical_relabel_specified_ymin;
  int numerical_scale_specified_ymin;
  int numerical_relabel_specified_yint;
  int numerical_scale_specified_yint;

  xp2_plot_info_struct *plot_info[MAX_PLOTS];
				/* All the information about a single plot */

} xp2_area_info_struct;

typedef struct _xprism2 {

  char	*form_file;		/* user interface description STRING */

  char	*title;			/* plot title STRING */
  char	*xaxis;			/* x-axis label STRING */
  char	*yaxis;			/* y-axis label STRING */

  int	font;			/* default font for parameters below INT */
  int	xaxis_font;		/* font for xaxis INT */
  int	yaxis_font;		/* font for yaxis INT */
  int	numbers_font;		/* font for numbers INT */
  int	legend_font;		/* font for legend INT */
  int	title_font;		/* font for title INT */

  int	plot_type;		/* plot type INT */
  int	marker_type;		/* marker type INT */
  int	line_type;		/* line type INT */

  int	whichband;		/* band number to plot if multiband viff */
  int	cmplx;		 	/* complex type to plot if complex */

  int	plot_color;		/* color for plot INT */
  int	color;			/* default color for parameters below INT */
  int	title_color;		/* color for title INT */
  int	xaxis_label_color;	/* color for x-axis label INT */
  int	yaxis_label_color;	/* color for y-axis labeI INT */
  int	xaxis_color;		/* color for x-axis INT */
  int	yaxis_color;		/* color for y-axis INT */
  int	num_xaxis_color;	/* color for x-axis numerical labels INT */
  int	num_yaxis_color;	/* color for y-axis numerical labels INT */
  int	grid_color;		/* default color for grid INT */
  int	legend_color;		/* color for legend INT */

  int	legend;			/* legend on or off? LOGIC */
  int	box;			/* box on or off? LOGIC */
  int	numerical_labels;	/* numerical labels on or off? LOGIC */
  int	axes;			/* axes on or off? LOGIC */
  int	grid;			/* grid on or off? LOGIC */
  int	auto_scale;		/* use auto scale true or false? LOGIC */
  int	clear_labels;		/* show all labels true or false? LOGIC */

  int	rescale_relabel;	/* are the labels equal to the data? LOGIC */

  Coord scale;			/* Are the axes linear, log, ...? LOGIC */

  int	step_size;		/* step size FLOAT*/
  int	begin_point;		/* point to begin plotting INT */
  int	end_point;		/* point to end plotting INT */

  int	data_format;		/* X or XY data is to be plotted INT */
  int	data_type;		/* byte, short, integer, or float data INT */
  int	machine_type;		/* the machine the data was created on INT */
  int	active;			/* Is the plot drawn? LOGIC */

  float	xmin;			/* x-axis data minimum FLOAT */
  float	xmax;			/* x-axis data maximum FLOAT */
  float	ymin;			/* y-axis data minimum FLOAT */
  float	ymax;			/* y-axis data maximum FLOAT */
  float	major_xint;		/* x-axis data major interval FLOAT */
  float	major_yint;		/* y-axis data major interval FLOAT */
  float	xlabel_min;		/* x-axis labeled minimum FLOAT */
  float	xlabel_max;		/* x-axis labeled maximum FLOAT */
  float	ylabel_min;		/* y-axis labeled minimum FLOAT */
  float	ylabel_max;		/* y-axis labeled maximum FLOAT */
  float	major_xlabel_int;	/* x-axis labeled major interval FLOAT */
  float	major_ylabel_int;	/* y-axis labeled major interval FLOAT */
  int	x_tics;			/* number of minor x tics INT */
  int	y_tics;			/* number of minor y tics INT */

  char 	*func_xmin;		/* function xmin FLOAT */
  char 	*func_xmax;		/* function xmax FLOAT */
  char 	*func_ptnum;		/* #points to be evaluated in function INT */

    /*****  Environment Defaults  *****/

  char	*indir;			/* global input directory  STRING */
  char	*outdir;		/* global output directory  STRING */

    /*****  Annotation File Defaults  *****/

  char	*annotation_in_file;	/* annotation input file STRING */
  char	*annotation_out_file;	/* annotation input file STRING */

    /*****  Output File Defaults  *****/

  char	*explicit_imagefile;	/* explicit image filename STRING */
  char	*implicit_imagefile;	/* implicit image filename STRING */
  char	*colormap_imagefile;	/* colormap image filename STRING */
  char	*screendump_file;	/* screen dump filename STRING */
  char	*output_answer_file;	/* output answer filename STRING */

    /*****  Postscript Output Defaults  *****/

  char	*postscr_printer;	/* postscript printer STRING */
  char	*postscr_file;		/* postscript file STRING */
  int	postscr_flush;		/* flush postscript file? LOGIC */
  int	postscr_invert;		/* invert postscript output? LOGIC */
  int	postscr_landscape;	/* landscape postscript output? LOGIC */
  int	postscr_mono;		/* mono postscript output? LOGIC */
  float	postscr_width;		/* postscript output width  FLOAT */
  float	postscr_height;		/* postscript output height  FLOAT */
  float	postscr_xoffset;	/* postscript output x offset FLOAT */
  float	postscr_yoffset;	/* postscript output y offset FLOAT */
  int	postscr_output_type;	/* output type vector or raster INT */

    /*****  Imagen Output Defaults  *****/

  char	*imagen_printer;	/* imagen printer STRING */
  char	*imagen_file;		/* imagen file STRING */
  int	imagen_flush;		/* flush imagen file? LOGIC */
  int	imagen_invert;		/* invert imagen output? LOGIC */
  float	imagen_width;		/* imagen output width  FLOAT */
  float	imagen_height;		/* imagen output height  FLOAT */
  float	imagen_xoffset;		/* imagen output x offset FLOAT */
  float	imagen_yoffset;		/* imagen output y offset FLOAT */
  int	imagen_output_type;	/* output type vector or raster INT */

    /*****  Imagen Output Defaults  *****/

  char	*hpgl_printer;		/* hpgl printer STRING */
  char	*hpgl_file;		/* hpgl file STRING */
  int	hpgl_flush;		/* flush hpgl file? LOGIC */
  int	hpgl_landscape;		/* landscape hpgl output? LOGIC */
  float	hpgl_width;		/* hpgl output width  FLOAT */
  float	hpgl_height;		/* hpgl output height  FLOAT */
  float	hpgl_xoffset;		/* hpgl output x offset FLOAT */
  float	hpgl_yoffset;		/* hpgl output y offset FLOAT */

    /*****  LN03 Output Defaults  *****/

  char	*ln03_file;		/* ln03 file STRING */
  char	*ln03_printer;		/* ln03 printer STRING */
  int	ln03_invert;		/* invert ln03 output? LOGIC */

  int plots_specified;
  int numerical_relabel_specified_xmin;
  int numerical_scale_specified_xmin;
  int numerical_relabel_specified_xmax;
  int numerical_scale_specified_xmax;
  int numerical_relabel_specified_xint;
  int numerical_scale_specified_xint;
  int numerical_relabel_specified_ymin;
  int numerical_scale_specified_ymin;
  int numerical_relabel_specified_ymax;
  int numerical_scale_specified_ymax;
  int numerical_relabel_specified_yint;
  int numerical_scale_specified_yint;
  int number_areas;

  xp2_area_info_struct *area_info[MAX_AREAS];
				/* All the information about a single plot
				   area */

} xprism2_struct;

#define WHITE			0
#define MEDIUMSPRINGGREEN	1
#define YELLOW			2
#define CYAN			3
#define MEDIUMORCHID		4
#define MAGENTA			5
#define ORANGE			6
#define WHEAT			7
#define LIMEGREEN		8
#define TURQUOISE		9
#define PINK			10
#define LIGHTGREY		11
#define PLUM			12
#define FORESTGREEN		13
#define SALMON			14
#define THISTLE			15
#define VIOLET			16
#define ORANGERED		17
#define RED			18
#define SEAGREEN		19
#define BLUE			20
#define GOLDENROD		21
#define CORAL			22
#define SIENNA			23

static char *linenames[] =
{
	"Solid",	"Dotted",	"Dot Dashed",
	"Short Dashed", "Long Dashed",  "Odd Dashed"
};

#define NO_MARKER		0
#define SQUARE			1
#define TRIANGLE		2
#define CROSS			3
#define BOWTIE			4
#define ARC			5
#define DIAMOND			6
#define CIRCLES			7
#define V			8
#define HEXAGON			9
#define X			10
#define DROPLET			11
#define CARET			12
#define POINT			13
#define DAGGER			14
#define BOX			15

static char *markernames[] =
{
	"Square",	"Triangle",	"Cross",	"BowTie",	"Arc",
	"Diamond",	"Circle",	"V",		"Hexagon",	"X",
	"Droplet",	"Caret",	"Point",	"Dagger",	"Box"
};

static char *plotnames[] =
{
	"2D",		"Discrete",	"Histogram",
	"Polymarker",	"Linemarker"
};

static char *data_type_names[] =
{
	"Byte",		"Short",	"Integer",	"Float"
};

static char *data_format_names[] =
{
	"XY Pairs",		"Y only"
};

#endif /* _xprism2_h_ */

/* Do not add after this line */
