/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  b_prio.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




#ifndef BPRIOH
#define BPRIOH

//------------------------------------------------------------------------------
// _b_priority_queues: bounded priority queues implemented by b_heaps 
//------------------------------------------------------------------------------

#include <LEDA/b_heap.h>

typedef b_heap_item b_pq_item;

#define b_priority_queue_body(keytype): public b_heap \
{\
  keytype name2(keytype,X);\
\
public:\
\
  _b_priority_queue(keytype)(int a, int b): (a,b)  {}\
  ~_b_priority_queue(keytype)()  { }\
  b_pq_item insert(keytype k,int info)\
                             { return b_heap::insert(info,Convert(k)); }\
  void decrease_inf(b_pq_item it,int newinf)\
                             { b_heap::decrease_key(it,newinf); }\
  void del_item(b_pq_item x) { b_heap::delete_item(x); }\
  int      inf(b_pq_item x)  { return b_heap::key(x); }\
  keytype  key(b_pq_item x)  { return ACCESS(keytype,b_heap::info(x)); }\
  keytype  del_min()         { return ACCESS(keytype,b_heap::del_min()); }\
  b_pq_item find_min()       { return b_heap::find_min(); }\
  void clear()               { b_heap::clear(); }\
  int empty()                { return (find_min()==0) ? true : false; }\
 };

#ifdef __TEMPLATES__
#define _b_priority_queue(keytype) b_priority_queue
template<class K> class b_priority_queue b_priority_queue_body(K)

#else
#define _b_priority_queue(keytype) name2(keytype,_b_priority_queue)
#define b_priority_queue(keytype) name2(keytype,_b_priority_queue)
#define _b_priority_queuedeclare(keytype)\
class b_priority_queue(K) b_priority_queue_body(K)

#endif
 
#endif

