/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLParagraphElement.h"

#include <wtf/GetPtr.h>

#include "HTMLParagraphElement.h"
#include "KURL.h"

#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLParagraphElement)

/* Hash table */

static const HashTableValue JSHTMLParagraphElementTableValues[3] =
{
    { "align", DontDelete, (intptr_t)jsHTMLParagraphElementAlign, (intptr_t)setJSHTMLParagraphElementAlign },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLParagraphElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLParagraphElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSHTMLParagraphElementTableValues, 0 };
#else
    { 5, 3, JSHTMLParagraphElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLParagraphElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLParagraphElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLParagraphElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLParagraphElementConstructorTableValues, 0 };
#endif

class JSHTMLParagraphElementConstructor : public DOMObject {
public:
    JSHTMLParagraphElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLParagraphElementConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLParagraphElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLParagraphElementConstructor::s_info = { "HTMLParagraphElementConstructor", 0, &JSHTMLParagraphElementConstructorTable, 0 };

bool JSHTMLParagraphElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLParagraphElementConstructor, DOMObject>(exec, &JSHTMLParagraphElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLParagraphElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLParagraphElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLParagraphElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLParagraphElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLParagraphElementPrototype::s_info = { "HTMLParagraphElementPrototype", 0, &JSHTMLParagraphElementPrototypeTable, 0 };

JSObject* JSHTMLParagraphElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLParagraphElement>(exec);
}

const ClassInfo JSHTMLParagraphElement::s_info = { "HTMLParagraphElement", &JSHTMLElement::s_info, &JSHTMLParagraphElementTable, 0 };

JSHTMLParagraphElement::JSHTMLParagraphElement(PassRefPtr<Structure> structure, PassRefPtr<HTMLParagraphElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLParagraphElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLParagraphElementPrototype(JSHTMLParagraphElementPrototype::createStructure(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLParagraphElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLParagraphElement, Base>(exec, &JSHTMLParagraphElementTable, this, propertyName, slot);
}

JSValuePtr jsHTMLParagraphElementAlign(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLParagraphElement* imp = static_cast<HTMLParagraphElement*>(static_cast<JSHTMLParagraphElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->align());
}

JSValuePtr jsHTMLParagraphElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLParagraphElement*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSHTMLParagraphElement::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLParagraphElement, Base>(exec, propertyName, value, &JSHTMLParagraphElementTable, this, slot);
}

void setJSHTMLParagraphElementAlign(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLParagraphElement* imp = static_cast<HTMLParagraphElement*>(static_cast<JSHTMLParagraphElement*>(thisObject)->impl());
    imp->setAlign(valueToStringWithNullCheck(exec, value));
}

JSValuePtr JSHTMLParagraphElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLParagraphElementConstructor>(exec);
}


}
