/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSTreeWalker_h
#define JSTreeWalker_h

#include "JSDOMBinding.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/ObjectPrototype.h>

namespace WebCore {

class TreeWalker;

class JSTreeWalker : public DOMObject {
    typedef DOMObject Base;
public:
    JSTreeWalker(PassRefPtr<JSC::Structure>, PassRefPtr<TreeWalker>);
    virtual ~JSTreeWalker();
    static JSC::JSObject* createPrototype(JSC::ExecState*);
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual void put(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::JSValuePtr, JSC::PutPropertySlot&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;

    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValuePtr prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType));
    }

    virtual void mark();

    static JSC::JSValuePtr getConstructor(JSC::ExecState*);

    // Custom functions
    JSC::JSValuePtr parentNode(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValuePtr firstChild(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValuePtr lastChild(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValuePtr previousSibling(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValuePtr nextSibling(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValuePtr previousNode(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValuePtr nextNode(JSC::ExecState*, const JSC::ArgList&);
    TreeWalker* impl() const { return m_impl.get(); }

private:
    RefPtr<TreeWalker> m_impl;
};

JSC::JSValuePtr toJS(JSC::ExecState*, TreeWalker*);
TreeWalker* toTreeWalker(JSC::JSValuePtr);

class JSTreeWalkerPrototype : public JSC::JSObject {
public:
    static JSC::JSObject* self(JSC::ExecState*);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValuePtr prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType));
    }
    JSTreeWalkerPrototype(PassRefPtr<JSC::Structure> structure) : JSC::JSObject(structure) { }
};

// Functions

JSC::JSValuePtr jsTreeWalkerPrototypeFunctionParentNode(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsTreeWalkerPrototypeFunctionFirstChild(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsTreeWalkerPrototypeFunctionLastChild(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsTreeWalkerPrototypeFunctionPreviousSibling(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsTreeWalkerPrototypeFunctionNextSibling(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsTreeWalkerPrototypeFunctionPreviousNode(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsTreeWalkerPrototypeFunctionNextNode(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
// Attributes

JSC::JSValuePtr jsTreeWalkerRoot(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsTreeWalkerWhatToShow(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsTreeWalkerFilter(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsTreeWalkerExpandEntityReferences(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsTreeWalkerCurrentNode(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSTreeWalkerCurrentNode(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsTreeWalkerConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);

} // namespace WebCore

#endif
