.\" Man page for man (and the former manpath)
.\"
.\" Copyright (c) 1990, 1991, John W. Eaton.
.\"
.\" You may distribute under the terms of the GNU General Public
.\" License as specified in the README file that comes with the man 1.0
.\" distribution.  
.\"
.\" John W. Eaton
.\" jwe@che.utexas.edu
.\" Department of Chemical Engineering
.\" The University of Texas at Austin
.\" Austin, Texas  78712
.\"
.\" Many changes - aeb
.\"
.\" Translated into german by Jochen Hein ( Hein@Student.TU-Clausthal.de )
.\" and Ralf W. Stephan ( ralf@franken.de ).
.\"
.TH man 1 "2. September 1995"
.LO 1
.SH NAME
man \- Formatieren und Anzeigen von Seiten des Online-Handbuches (man pages)
.br
manpath \- Anzeigen des Benutzer-eigenen Suchpfades fr Seiten des Online-Handbuches (man pages)
.SH SYNTAX
man [\-acdfhktw] [\-m system] [\-p string] [\-C config_file] [\-M path]
[\-P pager] [\-S section_list] [section] name ...
.SH BESCHREIBUNG
.B man
formatiert Seiten aus dem Online-Handbuch und zeigt diese an.
Diese Version untersttzt die
.B MANPATH
und
.B (MAN)PAGER
Umgebungsvariablen, so da
Sie ihre eigenen man pages verwenden knnen und selbst whlen knnen, welches
Programm die formatierten Seiten anzeigen soll. Wenn der Parameter
.I section
angegeben wird, so sucht 
.B man 
nur in dieser Sektion des Handbuchs.
Sie knnen auch mit Hilfe von Kommando-Zeilen-Optionen oder Umgebungsvariablen
die Reihenfolge angeben, in der die Sektionen nach
Eintrgen durchsucht werden und welche zustzlichen Programme
die Quelltexte bearbeiten sollen.
Wenn der Parameter
.I name
das Zeichen / enthlt, dann wird zunchst versucht, diese Datei zu
bearbeiten. Damit knnen Sie z.B. 
.B "man ./foo.5"
oder auch
.B "man /cd/foo/bar.1.gz"
eingeben.
.SH OPTIONEN
.TP
.B \-\^C " config_file"
bestimmt welche man.conf-Datei als Steuerdatei verwendet wird.
.TP
.B \-\^M " path"
bestimmt eine Liste von Verzeichnissen, die nach Handbuch-Seiten durchsucht 
werden. Wenn diese Option nicht angegeben ist, so wird die Umgebungsvariable
.B MANPATH
benutzt. Ist diese Variable nicht gesetzt, so wird diese Liste aus der
Datei man.conf erstellt.
.TP
.B \-\^P " pager"
bestimmt welches Programm zur Anzeige der Handbuch-Seiten benutzt wird.
Als default benutzt man
.B @pager@
Diese Option berschreibt die Umgebungsvariable
.B PAGER
.TP
.B \-\^S " section_list"
ist eine durch Doppelpunkte getrennte Liste von Handbuch-Sektionen, die
nach Handbuch-Seiten durchsucht werden soll.
Diese Option berschreibt die Umgebungsvariable
.B MANSECT
.TP
.B \-\^a
Als Default wird
.B man
beendet, nachdem es die erste Handbuchseite angezeigt
hat, die gefunden wurde. Diese Option weist 
.B man 
an, alle Handbuch-Seiten anzuzeigen, die zu
.B name, 
passen, nicht nur die erste.
.TP
.B \-\^d
zeigt nicht die Handbuch-Seiten an, sondern gibt etliche Informationen
zur Fehlersuche aus.
.TP
.B \-\^f
ist quivalent zu
.BR whatis .
.TP
.B \-\^h
gibt eine (einzeilige) Hilfe aus und beendet
.BR man .
.TP
.B \-\^k
ist quivalent zu
.BR apropos .
.TP
.B \-\^m " system"
bestimmt eine andere Menge von Handbuch-Seiten, die aufgrund des 
angegebenen System-Namen durchsucht werden sollen.
.TP
.B \-\^p " string"
bestimmt die Abfolge von Prprozessoren, die vor nroff oder troff
gestartet werden sollen. Nicht alle Installationen verfgen ber alle
Prprozessoren. Einige der Prprozessoren und die dafr verwendeten
Buchstaben sind:
eqn (e), grap (g), pic (p), tbl (t), vgrind (v), refer (r).
Diese Option berschreibt die Umgebungsvariable
.B MANROFFSEQ
.TP
.B \-\^t
benutzt
.B @troff@
um die Handbuch-Seite zu formatieren und leitet die Ausgabe weiter nach
.B stdout.
Die Ausgabe von
.B @troff@
mu mglicherweise durch einen Filter weiterbearbeitet werden, bevor
sie gedruckt werden kann.
.TP
.B \-\^w \fRor\fP \-\-path
die Handbuchseiten werden nicht angezeigt, sondern die Fundorte der Seiten,
die formatiert oder angezeigt wrden. Wenn kein Argument angegeben wurde,
wird die Liste der Verzeichnisse ausgegeben, die von 
.B man
nach Handbuch-Seiten durchsucht werden. Wenn
.B manpath
ein Link zu man ist, dann ist "manpath" quivalent zu "man --path".

.SH ENVIRONMENT
.TP
.B MANPATH
Wenn die Umgebungsvariable
.B MANPATH
gesetzt ist, dann wird dieser Wert als Suchpfad fr Handbuch-Seiten
verwendet.
.TP
.B MANROFFSEQ
Wenn die Umgebungsvariable
.B MANROFFSEQ
gesetzt ist, dann wird dieser Wert benutzt um die Prprozessoren zu bestimmen,
die aufgerufen werden sollen, bevor die Handbuch-Seite mit nroff oder troff
bearbeitet wird. Standardmig werden Handbuch-Seiten durch den Tabellen
Prprozessor bearbeitet bevor nroff gestartet wird.
.TP
.B MANSECT
Wenn die Umgebungsvariable
.B MANSECT
gesetzt ist, dann bestimmt dieser Wert welche Handbuch-Sektionen durchsucht
werden sollen.
.TP
.B MANWIDTH
Wenn die Umgebungsvariable
.B MANWIDTH
gesetzt ist, dann beschreibt deren Wert die Breite auf der die
Handbuch-Seite angezeigt werden soll. Ansonsten wird die Seite u.U.
ber die gesamte Breite des Bildschirmes gezogen.
.TP
.B PAGER
Wenn die Umgebungsvariable
.B PAGER
gesetzt ist, so wird dieser Wert als Name des Programms benutzt, mit dem
die Handbuch-Seiten angezeigt werden sollen. Standardmig wird
.B @pager@
verwendet.
.TP
.B LANG
Wenn die Umgebungsvariable
.B LANG
gesetzt ist, gibt ihr Inhalt den Namen des Unterverzeichnisses 
an, wo zuerst nach der Handbuch-Seite gesucht werden soll.  
So zB bewirkt der Shell-Befehl `LANG=dk man 1 foo', da 
.B man
zuerst in ...dk/man1/foo.1 nach der Handbuchseite fr 'foo' sucht, und
wenn es dort nicht fndig wird, dann in ...man1/foo.1, wobei '...'
ein Verzeichnis aus dem Suchpfad bedeutet.
.TP
.B "NLSPATH, LC_MESSAGES, LANG"
Die Umgebungsvariablen
.B NLSPATH
und
.B LC_MESSAGES
(oder
.B LANG
falls erstere nicht existiert) spielen bei der Suche nach dem Message
Katalog eine Rolle (englische Messages sind fest einkompiliert, daher
ist auch kein Katalog fr sie notwendig).  Beachten Sie, da auch
Programme wie
.B col(1),
das von
.B man
aufgerufen wird, noch zustzliche Variablen wie LC_CTYPE benutzen.
.TP
.B PATH
.B PATH
wird bei der Konstruktion des vorgegebenen Suchpfades fr Handbuchseiten
verwendet.
.TP
.B SYSTEM
.B SYSTEM
wird verwendet, um einen alternativen Systemnamen herauszufinden
(sinnvoll zusammen mit der
.B \-m 
Option).
.SH "SIEHE AUCH"
apropos(1), whatis(1), less(1), groff(1).
.SH BUGS
Die
.B \-t
Option kann nur auf System verwendet werden, auf denen ein troff-Programm
installiert ist.
