/*
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%                                                                             %
%                                                                             %
%           IIIII  DDDD   EEEEE  N   N  TTTTT  IIIII  FFFFF  Y   Y            %
%             I    D   D  E      NN  N    T      I    F       Y Y             %
%             I    D   D  EEE    N N N    T      I    FFF      Y              %
%             I    D   D  E      N  NN    T      I    F        Y              %
%           IIIII  DDDD   EEEEE  N   N    T    IIIII  F        Y              %
%                                                                             %
%                                                                             %
%               Identify an Image Format and Characteristics.                 %
%                                                                             %
%                                                                             %
%                           Software Design                                   %
%                             John Cristy                                     %
%                            September 1994                                   %
%                                                                             %
%                                                                             %
%  Copyright (C) 2003 ImageMagick Studio, a non-profit organization dedicated %
%  to making software imaging solutions freely available.                     %
%                                                                             %
%  Permission is hereby granted, free of charge, to any person obtaining a    %
%  copy of this software and associated documentation files ("ImageMagick"),  %
%  to deal in ImageMagick without restriction, including without limitation   %
%  the rights to use, copy, modify, merge, publish, distribute, sublicense,   %
%  and/or sell copies of ImageMagick, and to permit persons to whom the       %
%  ImageMagick is furnished to do so, subject to the following conditions:    %
%                                                                             %
%  The above copyright notice and this permission notice shall be included in %
%  all copies or substantial portions of ImageMagick.                         %
%                                                                             %
%  The software is provided "as is", without warranty of any kind, express or %
%  implied, including but not limited to the warranties of merchantability,   %
%  fitness for a particular purpose and noninfringement.  In no event shall   %
%  ImageMagick Studio be liable for any claim, damages or other liability,    %
%  whether in an action of contract, tort or otherwise, arising from, out of  %
%  or in connection with ImageMagick or the use or other dealings in          %
%  ImageMagick.                                                               %
%                                                                             %
%  Except as contained in this notice, the name of the ImageMagick Studio     %
%  shall not be used in advertising or otherwise to promote the sale, use or  %
%  other dealings in ImageMagick without prior written authorization from the %
%  ImageMagick Studio.                                                        %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Identify describes the format and characteristics of one or more image
%  files.  It will also report if an image is incomplete or corrupt.
%
%
*/

/*
  Include declarations.
*/
#include "studio.h"
#include "command.h"
#include "delegate.h"
#include "log.h"
#include "magic.h"
#include "module.h"
#include "render.h"
#include "resource.h"
#include "utility.h"
#include "version.h"

/*
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%                                                                             %
%                                                                             %
%   I d e n t i f y U s a g e                                                 %
%                                                                             %
%                                                                             %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  IdentifyUsage() displays the program command syntax.
%
%  The format of the IdentifyUsage method is:
%
%      void IdentifyUsage()
%
%
*/
static void IdentifyUsage(void)
{
  const char
    **p;

  static const char
    *options[]=
    {
      "-authenticate value  decrypt image with this password",
      "-debug events        display copious debugging information",
      "-density geometry    horizontal and vertical density of the image",
      "-depth value         image depth",
      "-format \"string\"     output formatted image characteristics",
      "-help                print program options",
      "-interlace type      None, Line, Plane, or Partition",
      "-limit type value    Disk, Map, or Memory resource limit",
      "-list type           Color, Delegate, Format, Magic, Module, Resource, or Type",
      "-log format          format of debugging information",
      "-size geometry       width and height of image",
      "-sampling-factor geometry",
      "                     horizontal and vertical sampling factor",
      "-verbose             print detailed information about the image",
      "-version             print version information",
      "-virtual-pixel method",
      "                     Constant, Edge, Mirror, or Tile",
      (char *) NULL
    };

  (void) printf("Version: %.1024s\n",GetMagickVersion((unsigned long *) NULL));
  (void) printf("Copyright: %.1024s\n\n",GetMagickCopyright());
  (void) printf("Usage: %.1024s [options ...] file [ [options ...] "
    "file ... ]\n",SetClientName((char *) NULL));
  (void) printf("\nWhere options include:\n");
  for (p=options; *p != (char *) NULL; p++)
    (void) printf("  %.1024s\n",*p);
  Exit(0);
}

/*
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%                                                                             %
%                                                                             %
%  M a i n                                                                    %
%                                                                             %
%                                                                             %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
*/
int main(int argc,char **argv)
{
  char
    *option,
    *text;

  ExceptionInfo
    exception;

  ImageInfo
    *image_info;

  register int
    i;

  unsigned int
    status;

  InitializeMagick(*argv);
  ReadCommandlLine(argc,&argv);
  for (i=1; i < argc; i++)
  {
    option=argv[i];
    if ((strlen(option) == 1) || ((*option != '-') && (*option != '+')))
      continue;
    if (LocaleCompare("debug",option+1) == 0)
      (void) SetLogEventMask(argv[++i]);
    if (LocaleCompare("help",option+1) == 0)
      IdentifyUsage();
    if (LocaleCompare("list",option+1) == 0)
      {
        if (*option == '-')
          {
            i++;
            if (i == argc)
              MagickFatalError(OptionFatalError,"MissingListName",option);
            option=argv[i];
            switch (*option)
            {
              case 'C':
              case 'c':
              {
                if (LocaleCompare("Color",option) == 0)
                  {
                    (void) ListColorInfo((FILE *) NULL,&exception);
                    break;
                  }
                MagickFatalError(OptionFatalError,"UnrecognizedListType",
                  option);
              }
              case 'D':
              case 'd':
              {
                if (LocaleCompare("Delegate",option) == 0)
                  {
                    (void) ListDelegateInfo((FILE *) NULL,&exception);
                    break;
                  }
                MagickFatalError(OptionFatalError,"UnrecognizedListType",
                  option);
              }
              case 'F':
              case 'f':
              {
                if (LocaleCompare("Format",option) == 0)
                  {
                    (void) ListMagickInfo((FILE *) NULL,&exception);
                    break;
                  }
                MagickFatalError(OptionFatalError,"UnrecognizedListType",
                  option);
              }
              case 'M':
              case 'm':
              {
                if (LocaleCompare("Magic",option) == 0)
                  {
                    (void) ListMagicInfo((FILE *) NULL,&exception);
                    break;
                  }
#if defined(HasMODULES)
                if (LocaleCompare("Module",option) == 0)
                  {
                    (void) ListModuleInfo((FILE *) NULL,&exception);
                    break;
                  }
#endif /* HasMODULES */
                MagickFatalError(OptionFatalError,"UnrecognizedListType",
                  option);
              }
              case 'R':
              case 'r':
              {
                if (LocaleCompare("Resource",option) == 0)
                  {
                    (void) ListMagickResourceInfo((FILE *) NULL,&exception);
                    break;
                  }
                MagickFatalError(OptionFatalError,"UnrecognizedListType",
                  option);
              }
              case 'T':
              case 't':
              {
                if (LocaleCompare("Type",option) == 0)
                  {
                    (void) ListTypeInfo((FILE *) NULL,&exception);
                    break;
                  }
                MagickFatalError(OptionFatalError,"UnrecognizedListType",
                  option);
              }
              default:
                MagickFatalError(OptionFatalError,"UnrecognizedListType",
                  option);
            }
            Exit(0);
          }
        break;
      }
    if (LocaleCompare("version",option+1) == 0)
      {
        (void) fprintf(stdout,"Version: %.1024s\n",
          GetMagickVersion((unsigned long *) NULL));
        (void) fprintf(stdout,"Copyright: %.1024s\n\n",GetMagickCopyright());
        Exit(0);
      }
    if (LocaleCompare("?",option+1) == 0)
      IdentifyUsage();
  }
  status=ExpandFilenames(&argc,&argv);
  if (status == False)
    MagickFatalError(ResourceLimitFatalError,"MemoryAllocationFailed",
      (char *) NULL);
  if (argc < 2)
    IdentifyUsage();
  GetExceptionInfo(&exception);
  image_info=CloneImageInfo((ImageInfo *) NULL);
  text=(char *) NULL;
  status=IdentifyImageCommand(image_info,argc,argv,&text,&exception);
  if (exception.severity != UndefinedException)
    CatchException(&exception);
  if (text != (char *) NULL)
    {
      (void) fputs(text,stdout);
      (void) fputc('\n',stdout);
      LiberateMemory((void **) &text);
    }
  DestroyImageInfo(image_info);
  DestroyExceptionInfo(&exception);
  DestroyMagick();
  for (i=0; i < argc; i++)
    LiberateMemory((void **) &argv[i]);
  LiberateMemory((void **) &argv);
  Exit(!status);
  return(False);
}
