unit DocumentDlg;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, ComCtrls, iniFiles;

const
  LF: string = #13#10;
  CR = #13;
  NL = #10;

type
  TDocumentDialog = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    TabRegister: TPageControl;
    Global: TTabSheet;
    Page: TTabSheet;
    Layout: TTabSheet;
    TitleSheet: TTabSheet;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    TableOfContents: TCheckBox;
    InputFiles: TCheckBox;
    DocumentClass: TComboBox;
    FontSize: TComboBox;
    Language: TComboBox;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    PaperSize: TComboBox;
    TopMargin: TEdit;
    LeftMargin: TEdit;
    TextWidth: TEdit;
    TextHeight: TEdit;
    TwoSidedLayout: TCheckBox;
    TwoColumnsLayout: TCheckBox;
    LeftHeader: TEdit;
    Label11: TLabel;
    Label12: TLabel;
    RightHeader: TEdit;
    Label13: TLabel;
    ColumnSeparation: TEdit;
    Label14: TLabel;
    RulerSize: TEdit;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Title: TEdit;
    Author1: TEdit;
    Author2: TEdit;
    Date: TEdit;
    Label4: TLabel;
    PageStyle: TComboBox;
    Paragraphs: TTabSheet;
    ParSkip: TEdit;
    ParIndent: TEdit;
    Label5: TLabel;
    Label19: TLabel;
    LineSpace: TEdit;
    Label20: TLabel;
    Graphics: TCheckBox;
    procedure OKBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
  public
    part1: String;
    part2: String;
  end;

var
  DocumentDialog: TDocumentDialog;

implementation

uses Frame;

{$R *.DFM}

procedure TDocumentDialog.OKBtnClick(Sender: TObject);
var strUseGraphics : string;
begin
  part1 :=  '\documentclass['
          + FontSize.Text + ','
          + PaperSize.Text;

  if Graphics.Checked then
    strUseGraphics := '\usepackage{graphics}' + LF
  else
    strUseGraphics := '';

  if TwoColumnsLayout.Checked then
    part1 := part1 + ',twocolumn';

  if TwoSidedLayout.Checked then
    part1 := part1 + ',twoside';

  part1 := part1 + ']'
          + '{' + DocumentClass.Text + '}' + LF
          +'\usepackage{t1enc}' + LF
          +'\usepackage[latin1]{inputenc}' + LF
          +'\usepackage[' + Language.Text + ']{babel}' + LF
          + strUseGraphics
          +'\pagestyle{' + PageStyle.Text + '}' + LF;

  if TwoColumnsLayout.Checked and (ColumnSeparation.Text <> '') then
    part1 := part1 + '\columnsep' + ColumnSeparation.Text + LF;

  if TwoColumnsLayout.Checked and (RulerSize.Text <> '') then
    part1 := part1 + '\columnseprule' + RulerSize.Text + LF;

  if   (PageStyle.Text = 'headings')
    or (PageStyle.Text = 'myheadings') then
  begin
    if   (DocumentClass.Text = 'book')
      or TwoSidedLayout.Checked then
    begin
      part1 := part1 + '\markboth{' + LeftHeader.Text + '}'
                              + '{' + RightHeader.Text + '}' + LF;
    end
    else
      part1 := part1 + '\markright{' + RightHeader.Text + '}' + LF;
  end;

  if TopMargin.Text <> '' then
    part1 := part1 + '\topmargin' + TopMargin.Text + LF;

  if LeftMargin.Text <> '' then
    part1 := part1 + '\oddsidemargin' + LeftMargin.Text + LF;

  if TextWidth.Text <> '' then
    part1 := part1 + '\textwidth' + TextWidth.Text + LF;

  if TextHeight.Text <> '' then
    part1 := part1 + '\textheight' + TextHeight.Text + LF;

  if ParSkip.Text <> '' then
    part1 := part1 + '\setlength{' + '\parskip}' + '{' + ParSkip.Text + '}' + LF;

  if ParIndent.Text <> '' then
    part1 := part1 + '\setlength{' + '\parindent}' +'{' + ParIndent.Text + '}' + LF;

  part1 := part1 + LF + '\begin{document}' + LF;

  if LineSpace.Text <> '' then
    part1 := part1 + '\baselineskip' + LineSpace.Text + LF;

  part1 := part1 + LF;

  if   (Title.Text <> '')
    or (Author1.Text <> '')
    or (Author2.Text <> '')
    or (Date.Text <> '') then
  begin
  part1 :=  part1
          + '\title{' + Title.Text + '}' + LF
          + '\author{' + Author1.Text;
  if Author2.Text <> '' then
    part1 := part1 + ' \and ' + Author2.Text + '}' + LF
  else
    part1 := part1 + '}' + LF;

  part1 := part1 + '\maketitle' + LF + LF;
  end;

  if TableOfContents.Checked then
    part1 := part1 + '\tableofcontents' + LF ;

  part2 := '';

  if InputFiles.Checked then
  begin
    part1 := part1 + LF + '\input{';
    part2 := 'filename}';
  end;

  part2 := part2 + LF + LF + '\end{document}';
end;


procedure TDocumentDialog.FormCreate(Sender: TObject);
var iniFile: TIniFile;
begin
  iniFile := TIniFile.Create (FrameForm.iniFileName);

  DocumentClass.Text := iniFile.ReadString ('Document', 'Class', 'article');
  FontSize.Text := iniFile.ReadString ('Document', 'FontSize', '12pt');
  Language.Text := iniFile.ReadString ('Document', 'Language', 'english');
  TableOfContents.Checked := iniFile.ReadBool ('Document', 'TOC', false);
  InputFiles.Checked := iniFile.ReadBool ('Document', 'InputFiles', false);
  Graphics.Checked := iniFile.ReadBool ('Document', 'Graphics', false);
  PaperSize.Text := iniFile.ReadString ('Document', 'PaperSize', 'a4paper');
  TopMargin.Text := iniFile.ReadString ('Document', 'TopMargin', '');
  LeftMargin.Text := iniFile.ReadString ('Document', 'LeftMargin', '');
  TextWidth.Text := iniFile.ReadString ('Document', 'TextWidth', '');
  TextHeight.Text := iniFile.ReadString ('Document', 'TextHeight', '');
  ParSkip.Text := iniFile.ReadString ('Document', 'ParSkip', '');
  ParIndent.Text := iniFile.ReadString ('Document', 'ParIndent', '');
  LineSpace.Text := iniFile.ReadString ('Document', 'LineSpace', '');
  PageStyle.Text := iniFile.ReadString ('Document', 'PageStyle', 'plain');
  TwoSidedLayout.Checked := iniFile.ReadBool ('Document', 'TwoSided', false);
  LeftHeader.Text := iniFile.ReadString ('Document', 'LeftHeader', '');
  RightHeader.Text := iniFile.ReadString ('Document', 'RightHeader', '');
  TwoColumnsLayout.Checked := iniFile.ReadBool ('Document', 'TwoColumns', false);
  ColumnSeparation.Text := iniFile.ReadString ('Document', 'ColumnSeparation', '');
  RulerSize.Text := iniFile.ReadString ('Document', 'RulerSize', '');
  Title.Text := iniFile.ReadString ('Document', 'Title', '');
  Author1.Text := iniFile.ReadString ('Document', 'Author1', '');
  Author2.Text := iniFile.ReadString ('Document', 'Author2', '');
  Date.Text := iniFile.ReadString ('Document', 'Date', '');

  iniFile.Free;
end;

procedure TDocumentDialog.FormDestroy(Sender: TObject);
var iniFile: TIniFile;
begin
  if FrameForm.lockIniFile = false then //*DS* ini file may be locked in network environment
  begin
    iniFile := TIniFile.Create (FrameForm.userIniFileName);

    iniFile.WriteString ('Document', 'Class', DocumentClass.Text);
    iniFile.WriteString ('Document', 'FontSize', FontSize.Text);
    iniFile.WriteString ('Document', 'Language', Language.Text);
    iniFile.WriteBool ('Document', 'TOC', TableOfContents.Checked);
    iniFile.WriteBool ('Document', 'InputFiles', InputFiles.Checked);
    iniFile.WriteBool ('Document', 'Graphics', Graphics.Checked);    
    iniFile.WriteString ('Document', 'PaperSize', PaperSize.Text);
    iniFile.WriteString ('Document', 'TopMargin', TopMargin.Text);
    iniFile.WriteString ('Document', 'LeftMargin', LeftMargin.Text);
    iniFile.WriteString ('Document', 'TextWidth', TextWidth.Text);
    iniFile.WriteString ('Document', 'TextHeight', TextHeight.Text);
    iniFile.WriteString ('Document', 'ParSkip', ParSkip.Text);
    iniFile.WriteString ('Document', 'ParIndent', ParIndent.Text);
    iniFile.WriteString ('Document', 'LineSpace', LineSpace.Text);
    iniFile.WriteString ('Document', 'PageStyle', PageStyle.Text);
    iniFile.WriteBool ('Document', 'TwoSided', TwoSidedLayout.Checked);
    iniFile.WriteString ('Document', 'LeftHeader', LeftHeader.Text);
    iniFile.WriteString ('Document', 'RightHeader', RightHeader.Text);
    iniFile.WriteBool ('Document', 'TwoColumns', TwoColumnsLayout.Checked);
    iniFile.WriteString ('Document', 'ColumnSeparation', ColumnSeparation.Text);
    iniFile.WriteString ('Document', 'RulerSize', RulerSize.Text);
    iniFile.WriteString ('Document', 'Title', Title.Text);
    iniFile.WriteString ('Document', 'Author1', Author1.Text);
    iniFile.WriteString ('Document', 'Author2', Author2.Text);
    iniFile.WriteString ('Document', 'Date', Date.Text);

    iniFile.Free;
  end;
end;

end.
