#ifndef __TURLWINDOW_H
//	Avoid include redundancy
#define __TURLWINDOW_H

//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Include File:	turlwind.h
//	Purpose:	Header file for URL window class
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created

//	Constant defines
#define Uses_TWindow
#define Uses_TEvent

//	Required includes
#include"turlview.h"

//	Class declarations
class TURLWindow : public TWindow	{
private:
	TURLView *TURLV;
	void OwnerClose();
	void URLoader(const char *cp_URL, const char *cp_Index = NULL);
	TNSCollection *TNSCp_visited;
	signed short int Number(signed short int ssi_Win = -1);
public:
	TURLWindow(const char *cp_URL = "");
	TURLWindow(const TNSCollection *TNSCp_cloneHistory, const char
		*cp_cloneURL = "");
	~TURLWindow();
	virtual void handleEvent(TEvent &TE_event);
	virtual void dragView(TEvent& TE_event, unsigned char uc_mode,
		TRect& TR_limits, TPoint TP_minSize, TPoint TP_maxSize);
	void IndexInit();
	void IndexQuery();
	Boolean B_isIndex;
};

//	Global variable declarations

//	Macros

#endif // __TURLWINDOW_H
