.\"	$Source: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/AS.ms,v $
.\"	$Author: jtkohl $
.\"	$Header: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/AS.ms,v 1.43 90/12/19 17:05:51 jtkohl Exp $
.\"
.ds R# "$Id: AS.ms,v 1.43 90/12/19 17:05:51 jtkohl Exp $
.N: sec 1 foo53 "Message Exchanges"
.LP
The following sections describe the interactions between network
clients and servers and the messages involved in those exchanges.
.N: sec 2 as "The Authentication Service Exchange"
.TS
center;
c s s
l l l.
Summary
\fIMessage direction	Message type	Section\fR
1. Client to Kerberos	KRB_AS_REQ	~sec kdc_req_def~
2. Kerberos to client	KRB_AS_REP or	~sec kdc_rep_def~
	KRB_ERROR	~sec krb_error_def~
.TE
.PP
The Authentication Service (AS) Exchange between the client and
the Kerberos Authentication Server is usually
initiated by a client when it wishes to
obtain authentication credentials for a given server but currently holds
no credentials.
The client's secret key is used for encryption and decryption.  This
exchange is
typically used at the initiation of a login session,
to obtain credentials for a Ticket-Granting Server, which
will subsequently be used obtain credentials for other
servers (see section ~sec tgs-exch~) without requiring further use of the
client's secret key.
This exchange is also used 
to request credentials for services which
must not be mediated through
the Ticket-Granting Service, but rather require a principal's
secret key, such as the password-changing service\**.
.FS
The password-changing request must not be honored unless
the requester can provide the old password (the user's current
secret key).
Otherwise, it would be possible for someone
to walk up to an unattended session and change
another user's password.
.FE
.PP
The exchange consists of two messages: KRB_AS_REQ 
from the client to Kerberos, and
KRB_AS_REP or KRB_ERROR in reply.
The formats for these messages are described in sections
~sec kdc_rep_def~ and ~sec krb_error_def~.
.PP
In the request, the client sends (in cleartext) its own identity and
the identity of the server for which it is requesting credentials.
The response, KRB_AS_REP, contains a ticket for the client to present to the
server, and a session key that will be shared by the client and the
server.  The session key and additional information are encrypted in
the client's secret key.  The KRB_AS_REP message contains
information which can be used to detect replays, and to associate it
with the message to which it replies.  Various errors can occur; these are
indicated by an error response (KRB_ERROR) instead of the KRB_AS_REP
response.  The error message is not encrypted.  The KRB_ERROR message also
contains information which can be used to associate it
with the message to which it replies.  The lack of encryption in the
KRB_ERROR message precludes the ability to detect replays or
fabrications of such messages.
.PP
In the normal case the authentication server does not know
whether the client is actually the principal named in the request.  It simply
sends a reply without knowing or caring whether they are the same.
This is acceptable because nobody but the principal whose identity was
given in the request will be able to use the reply. Its critical
information is encrypted in that principal's key.  The initial request
supports an optional field that can be used to pass additional
information that might be needed for the initial exchange.  This field
may be used for pre-authentication if desired, but the mechanism is not
currently specified.
.N: sec 3 foo3 "Generation of KRB_AS_REQ message"
.PP
The client may specify a number of options in the initial request.
Among these options are whether the requested ticket is to be
renewable, proxiable, or forwardable; whether it should be postdated
or allow postdating of derivative tickets; and whether a renewable
ticket will be accepted in lieu of a non-renewable ticket if
the requested ticket expiration date cannot be satisfied
by a non-renewable ticket (due to configuration constraints; see section
~sec db_spec~).  See section ~sec as_req_g_pc~ for pseudocode.
.PP
The client prepares the KRB_AS_REQ message and sends it to the KDC.
.N: sec 3 foo4 "Receipt of KRB_AS_REQ message"
.PP
If all goes well, processing the KRB_AS_REQ message will result
in the creation of a ticket for the client to present to the server.
The format for the ticket is described in section ~sec ticket_def~.  The
contents
of the ticket are determined as follows.
.N: sec 3 foo5 "Generation of KRB_AS_REP message"
.PP
The authentication server looks up the client and server principals
named in the KRB_AS_REQ
in its database, extracting their respective keys.
If the server cannot accommodate the requested encryption type, an error
message with code KDC_ERR_ETYPE_NOSUPP is returned.
Otherwise it generates a "random" session key\**.
.FS
"Random" means that, among other things, it should be impossible
to guess the next session key based on knowledge of past
session keys.  This can only be achieved in a pseudo-random
number generator if it is based on cryptographic principles.  It would
be more desirable to use a truly random number generator, such as one
based on measurements of random physical phenomena.
.FE
.PP
If the requested start time is absent or indicates a time in the past, 
then the start time of the ticket
is set to the authentication server's current time.  
If it 
indicates a time in the future, but the POSTDATED option
has not been specified, then the error KDC_ERR_CANNOT_POSTDATE is returned.
Otherwise the
requested start time is checked against the policy of the local realm
(the administrator might decide to prohibit certain types or ranges of
postdated tickets), and if
acceptable, the ticket's start time is set as requested and  the INVALID
flag is set in the new ticket. The postdated ticket must be validated
before use by presenting it to the KDC after the start time has been
reached.
.LP
.KS
The expiration time of the ticket will be set to the
minimum of the following:
.IP \(bu 1
The expiration time (endtime) requested in the KRB_AS_REQ message.
.IP \(bu
The ticket's start time plus the maximum allowable lifetime associated with the
client principal (the authentication server's database includes a
maximum ticket lifetime field in each principal's record; see section
~sec db_spec~).
.IP \(bu
The ticket's start time plus the maximum allowable lifetime associated
with the server principal.
.IP \(bu
The ticket's start time plus the maximum lifetime set by the policy of the local realm.
.KE
.PP
If the requested expiration time minus the start time (as determined
above) is less than a site-determined minimum lifetime,
an error message with code KDC_ERR_NEVER_VALID is returned.
If the requested expiration time for the ticket exceeds what was
determined as above, and if the "RENEWABLE-OK" option was requested, then the
"RENEWABLE" flag is set in the new ticket, and the
\fBrenew-till\fP value is set as if the "RENEWABLE" option were requested
(the field and option names are described fully in section ~sec kdc_req_def~).
.PP
.KS
If the RENEWABLE option has been requested or if the RENEWABLE-OK option
has been set and a renewable ticket is to be issued, then the \fBrenew-till\fP
field is set to the minimum of:
.IP \(bu 1
Its requested value.
.IP \(bu
The start time of the ticket plus the minimum of the two maximum
renewable lifetimes associated with the principals' database entries.
.IP \(bu
The start time of the ticket plus the maximum renewable lifetime set
by the policy of the local realm.
.KE
.PP
The flags field of the new ticket will have the following
options set if they have been requested and if the policy of the local
realm allows:
FORWARDABLE, MAY-POSTDATE, POSTDATED, PROXIABLE, RENEWABLE. If the new
ticket is postdated (the start time is in the future), its INVALID
flag will also be set.
.PP
If all of the above succeed, the server formats a KRB_AS_REP message
(see section ~sec kdc_rep_def~), copying the addresses in the request
into the caddr of the response, placing any required pre-authentication
data into the pa-data of the response, and
encrypts the ciphertext part in the client's key using the requested
encryption method, and sends it to the client.
See section ~sec as_rep_g_pc~ for pseudocode.
.N: sec 3 foo6 "Generation of KRB_ERROR message"
.PP
Several errors can occur, and the Authentication Server responds
by returning an error message, KRB_ERROR, to the client, with the
\fBerror-code\fP and \fBe-text\fP fields set to appropriate values.
The error message contents and details are described in Section
~sec krb_error_def~.
.N: sec 3 foo7 "Receipt of KRB_AS_REP message"
.PP
If the reply message type is KRB_AS_REP, then the client
verifies that the \fBcname\fP and \fBcrealm\fP fields in the
cleartext portion of the reply match what
it requested.  If any \fBpadata\fP fields are present, they may be used
to derive the proper secret key to decrypt the message.
The client decrypts the encrypted part of the response using
its secret key, verifies that the \fBnonce\fP in the encrypted part matches
the nonce it supplied in its request (to detect replays).  It
also verifies that the \fBsname\fP and \fBsrealm\fP in the
response match those in the request, and
that the host address field is also correct.  It then stores the
ticket, session key, 
start and expiration times, and other information for later use.  The
\fBkey-expiration\fP field from the encrypted part of the response may be checked to notify the 
user of impending key expiration (the client program could then suggest
remedial action, such as a password change).
.PP
Proper decryption of the KRB_AS_REP message is \fInot\fP sufficient to
verify the identity of the user; the user and an attacker could
cooperate to generate a KRB_AS_REP format message which decrypts
properly but is not from the proper KDC.  If the host wishes to verify
the identity of the user, it must require the user to present
application credentials which can be verified using a securely-stored
secret key.  If those credentials can be verified, then the identity of
the user can be assured.
See section ~sec as_rep_v_pc~ for pseudocode.
.N: sec 3 foo8 "Receipt of KRB_ERROR message"
.PP
If the reply message type is KRB_ERROR, then the client interprets it as an
error and performs whatever application-specific tasks are necessary
to recover.  
