.\"	$Source: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/Interop.ms,v $
.\"	$Author: jtkohl $
.\"	$Header: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/Interop.ms,v 1.2 90/12/19 17:06:15 jtkohl Exp $
.\"
.ds R# "$Id: Interop.ms,v 1.2 90/12/19 17:06:15 jtkohl Exp $
.N: sec 1 interoperability "Interoperability requirements"
.PP
Version 5 of the Kerberos protocol supports a myriad of options.
Among these are multiple encryption and checksum types, alternative
encoding schemes for the transited field, optional mechanisms for
pre-authentication, the handling of tickets with no addresses, options
for mutual authentication, user to user authentication, support for
proxies, forwarding, postdating, and renewing tickets, the format of
realm names, and the handling of authorization data.
.PP
In order to ensure the interoperability of realms, it is necessary to
define a minimal configuration which must be supported by all
implementations.  This minimal configuration is subject to change as
technology does.  For example, if at some later date it is discovered
that one of the required encryption or checksum algorithms is not
secure, it will be replaced.
.N: sec 2 interop_spec_1 "Specification 1"
.PP
This section defines the first specification of these options.
Implementations which are configured in this way can be said to support
Kerberos Version 5 Specification 1 (5.1).
.SH
Encryption and checksum methods
.LP
The following encryption and checksum mechanisms must be supported.
Implementations may support other mechanisms as well, but the
additional mechanisms may only be used when communicating with
principals known to also support them:
.nf
Encryption: DES-CBC-CRC
Checksums: CRC-32 and DES-MAC
.fi
.SH
Realm Names
.LP
All implementations must understand hierarchical realms in both the
Internet Domain and the X.500 style.  When a ticket granting ticket
for an unknown realm is requested, the KDC must be able to determine
the names of the intermediate realms between the KDCs realm and the
requested realm.
.SH
Transited field encoding
.LP
DOMAIN-X500-COMPRESS (described in section ~sec transited_spec~) must be
supported.  Alternative encodings may be supported, but they may be
used only when that encoding is supported by ALL intermediate realms.
.SH
Pre-authentication methods
.LP
The TGS-REQ method must be supported.  The TGS-REQ method is not used on the
initial request.

.SH
Mutual authentication
.LP
Mutual authentication (via the KRB_AP_REP message) must be supported.

.SH
Ticket addresses and flags
.LP
All KDC's must pass on tickets that carry no addresses (i.e. if a TGT
contains no addresses, the KDC will return derivative tickets), but each
realm may set its own policy for issuing such tickets, and each
application server will set its own policy with respect to accepting
them.  By default, servers should not accept them.
.PP
Proxies and forwarded tickets must be supported.  Individual realms and
application servers can set their own policy on when such tickets will
be accepted.
.PP
All implementations must recognize renewable and postdated tickets, but
need not actually implement them.  If these options are not supported,
the starttime and endtime in the ticket shall specify a ticket's entire
useful life.  When a postdated ticket is decoded by a server, all
implementations shall make the presence of the postdated flag visible to
the calling server.
.SH
User-to-user authentication
.LP
Support for user to user authentication (via the ENC-TKT-IN-SKEY KDC
option) is not required.
.SH
Authorization data
.LP
Implementations must pass all authorization data subfields from
ticket-granting tickets to any derivative tickets unless directed to
suppress a subfield as part of the definition of that registered
subfield type (it is never incorrect to pass on a subfield, and no
registered subfield types presently specify suppression at the KDC).
.PP
Implementations must make the contents of any authorization data
subfields available to the server when a ticket is used.
Implementations are not required to allow clients to specify the
contents of the authorization data fields.
.N: sec 2 rec_values "Recommended KDC values"
.LP
Following is a list of recommended values for a KDC implementation,
based on the list of suggested configuration constants (see section ~sec
site_constants~).
.IP "\fBminimum lifetime\fP" 2in
5 minutes
.IP "\fBmaximum renewable lifetime\fP" 2in
1 week
.IP "\fBmaximum ticket lifetime\fP" 2in
1 day
.IP "\fBempty addresses\fP" 2in
Not allowed.
.IP "\fBproxiable, etc.\fP" 2in
Allowed.
