.\"	$Source: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/KDC_spec.ms,v $
.\"	$Author: jtkohl $
.\"	$Id: KDC_spec.ms,v 1.5 90/12/19 17:06:17 jtkohl Exp Locker: jtkohl $
.\"
.ds R# "$Id: KDC_spec.ms,v 1.5 90/12/19 17:06:17 jtkohl Exp Locker: jtkohl $
.N: sec 2 foo36 "Specifications for the AS and TGS exchanges"
.PP
This section specifies the format of the messages used in exchange
between the client and the Kerberos server.  The format of possible error
messages appears in section ~sec krb_error_def~.
.N: sec 3 kdc_req_def "KRB_KDC_REQ definition"
.PP
The KRB_KDC_REQ message has no type of its own.  Instead, its type is
one of KRB_AS_REQ or KRB_TGS_REQ depending on whether the request is
for an initial ticket or an additional ticket.  In either case, the
message is sent from the client to the Authentication Server to
request credentials for a service.
.PP
The message fields are:
.KS
.TS
center;
lb l l.
KDC-REQ ::=	[APPLICATION 10 or 12\(dg] SEQUENCE {
	pvno[1]	INTEGER,
	msg-type[2]	INTEGER,
	padata[3]	SEQUENCE OF PA-DATA OPTIONAL,
	req-body[4]	KDC-REQ-BODY
}
.TE
.FS \(dg
[APPLICATION 10 or 12] is not valid ASN.1 notation. 
The two types of messages (AS-REQ and TGS-REQ) have different
application codes, but the format for the remainder of the
message is identical.  
.FE
.KE
.TS
center;
lb l l.
PA-DATA ::=	SEQUENCE {
	padata-type[1]	INTEGER,
	pa-data[2]	OCTET STRING,
		-- might be encoded AP-REQ
}
.sp
KDC-REQ-BODY ::=	SEQUENCE {
	 kdc-options[0]	KDCOptions,
	 cname[1]	PrincipalName OPTIONAL,
		-- Used only in AS-REQ
	 realm[2]	Realm, -- Server's realm
		-- Also client's in AS-REQ
	 sname[3]	PrincipalName,
	 from[4]	KerberosTime OPTIONAL,
	 till[5]	KerberosTime,
	 rtime[6]	KerberosTime OPTIONAL,
	 nonce[7]	INTEGER,
	 etype[8]	SEQUENCE OF INTEGER, -- EncryptionType, in preference order
	 addresses[9]	HostAddresses OPTIONAL,
	 enc-authorization-data[10]	EncryptedData OPTIONAL,
		-- Encrypted AuthorizationData encoding
	 additional-tickets[11]	SEQUENCE OF Ticket OPTIONAL
}
.TE
The fields in this message are:

.IP \fBpvno\fP 10
This field is included in each message, and specifies the protocol
version number.  This document specifies protocol version 5.  

.IP \fBmsg-type\fP 10
This field indicates the type of a protocol message.  It will almost
always be the same as the application identifier associated with a
message.  It is included to make the identifier more readily
accessible to the application.  For the KDC-REQ message, this type will
be KRB_AS_REQ or KRB_TGS_REQ.

.IP \fBpadata\fP 10
The padata (pre-authentication data) field contains a sequence of
authentication information which may be needed before credentials can be
issued or decrypted.  In the case of requests for additional tickets
(KRB_TGS_REQ), this field will include an element with \fBpa-type\fP of
PA-TGS-REQ and \fBdata\fP of an authentication header (ticket-granting
ticket and authenticator).  The checksum in the authenticator (which
must be collision-proof) is to be computed over the KDC-REQ-BODY
encoding.  In most requests for initial authentication (KRB_AS_REQ) and
most replies (KDC-REP), the \fBpadata\fP field will be left out.  This
field may also contain information needed by certain extensions to the
Kerberos protocol.  For example, it might be used to initially verify
the identity of a client before any response is returned, or it might
contain information needed to help the KDC or the client select the key
needed for generating or decrypting the response.  The latter cases
would be useful for supporting the use of certain "smartcards" with
Kerberos.  The details of such extensions are not presently specified.

.IP \fBpadata-type\fP 10
.br
The \fBpadata-type\fP element of the \fBpadata\fP field indicates the
way that the \fBpa-data\fP element is to be interpreted.  Negative values
of \fBpadata-type\fP are reserved for unregistered use; non-negative values
are used for a registered interpretation of the element type.

.IP \fBreq-body\fP 10
This field is a placeholder delimiting
the extent of the remaining fields.  If a checksum is to be calculated
over the request, it is calculated over an encoding of the KDC-REQ-BODY
sequence which is enclosed within the \fBreq-body\fP field.

.IP \fBkdc-options\fP 10 
.br
This field appears in the KRB_AS_REQ and KRB_TGS_REQ
requests to
the KDC and indicates the flags that the client wants set on the
tickets as well as other information that is to modify the behavior of
the KDC.  Where appropriate, the name of an option may be the same as
the flag that is set by that option.  Although in most case, the bit
in the options field will be the same as that in the flags field, this
is not guaranteed, so it is not acceptable to simply copy the options
field to the flags field.  There are various checks that must be made
before honoring an option anyway.

The kdc_options field is a bit-field, where the selected options are
indicated by the bit being set (1), and the unselected options and
reserved fields being reset (0).
The encoding of the bits is specified in section ~sec asn1_base~.  The
options are described in more detail above in section ~sec flag_stuff~.
The meanings of the options are:
.TS
expand;
l l lw(4i).
.KS
\fIBit(s)	Name	Description\fP
.sp
0	RESERVED	T{
Reserved for future expansion of this field.
T}
.KE
.sp
1	FORWARDABLE	T{
The FORWARDABLE option indicates that the ticket to be issued is to
have its forwardable flag set.  It may only be set on the initial
request, or in a subsequent request if the ticket-granting ticket on
which it is based is also forwardable.
T}
.sp
2	FORWARDED	T{
The FORWARDED option is only specified in a request to the ticket-granting
server and will only be honored if the ticket-granting ticket in the
request has its FORWARDABLE bit set.
This option indicates that this is a request for forwarding.
The address(es) of the host from
which the resulting ticket is to be valid are included in the
addresses field of the request.
T}
.sp
3	PROXIABLE	T{
The PROXIABLE option indicates that the ticket to be issued is to
have its proxiable flag set.  It may only be set on the initial
request, or in a subsequent request if the ticket-granting ticket on
which it is based is also proxiable.
T}
.sp
4	PROXY	T{
The PROXY option indicates that this is a request for a proxy.
This option
will only be honored if the ticket-granting ticket in the
request has its PROXIABLE bit set.
The address(es) of the host from
which the resulting ticket is to be valid are included in the
addresses field of the request.
T}
.sp
5	ALLOW-POSTDATE	T{
The ALLOW-POSTDATE option indicates that the ticket to be issued is to
have its MAY-POSTDATE flag set.  It may only be set on the initial
request, or in a subsequent request if the ticket-granting ticket on
which it is based also has its MAY-POSTDATE flag set.
T}
.sp
6	POSTDATED	T{
The POSTDATED option indicates that this is a request for a postdated ticket.
This option
will only be honored if the ticket-granting ticket on
which it is based has its MAY-POSTDATE flag set.  The resulting ticket
will also have its INVALID flag set, and that flag may be reset by a
subsequent request to the KDC after the starttime in the ticket has
been reached.
T}
.sp
7	UNUSED	T{
This option is presently unused.
T}
.sp
8	RENEWABLE 	T{
The RENEWABLE option indicates that the ticket to be issued is to
have its RENEWABLE flag set.  It may only be set on the initial
request, or when the ticket-granting ticket on which the request is
based is also renewable.  If this option is requested, then
the \fBrtime\fP field in the request contains the desired absolute
expiration time for the ticket.
T}
.sp
9-26	RESERVED	T{
Reserved for future use.
T}
.sp
27	RENEWABLE-OK	T{
The RENEWABLE-OK option indicates that a renewable ticket will be
acceptable if a ticket with the requested life cannot otherwise be
provided.  If a ticket with the requested life cannot be provided,
then a renewable ticket may be issued with a \fBrenew-till\fP equal to the
the requested endtime.  The value of the \fBrenew-till\fP field may still be
limited by local limits, or limits selected by the individual
principal or server.
T}
.sp
28	ENC-TKT-IN-SKEY	T{
This option is used only by the ticket-granting service.
The ENC-TKT-IN-SKEY option indicates that the ticket for the end
server is to be encrypted in the session key from the additional
ticket-granting ticket provided.   
T}
.sp
29	RESERVED	T{
Reserved for future use.
T}
.sp
30	RENEW	T{
This option is used only by the ticket-granting service.
The RENEW option indicates that the present request is for a renewal.
The ticket provided is encrypted in the secret key for the server
on which it is valid.  This option will only be honored if the ticket
to be renewed has its RENEWABLE flag set and if the time in its
\fBrenew-till\fP field has not passed.  The ticket to be renewed is passed
in the \fBpadata\fP field as part of the authentication header.
T}
.sp
31	VALIDATE	T{
This option is used only by the ticket-granting service.  The VALIDATE
option indicates that the request is to validate a postdated
ticket.  It will only be honored if the ticket presented is postdated,
presently has its INVALID flag set, and would be otherwise usable at
this time.  A ticket cannot be validated before its \fBstarttime\fP.
The ticket presented for validation is encrypted in the key of the
server for which it is valid and is passed in the \fBpadata\fP field as
part of the authentication header.
T}
.TE

.IP "\fBcname\fP and \fBsname\fP" 10
.br
These fields are the same as those described for the ticket in section
~sec ticket_def~.

.IP "\fBenc-authorization-data\fP" 10
.br
The \fBenc-authorization-data\fP, if present (and it can only be present
in the TGS_REQ form), is an encoding of the desired
\fBauthorization-data\fP encrypted under the sub-session key which
appears in the authenticator in the KRB_AP_REQ in the pa-data field.

.IP \fBrealm\fP 10
This field specifies the realm part of the server's principal
identifier.  In the AS exchange, this is also the realm part of the
client's principal identifier.

.IP \fBfrom\fP 10 
This field is included in the KRB_AS_REQ and KRB_TGS_REQ ticket
requests when the requested ticket is to be postdated. It specifies
the desired start time for the requested ticket.  


.IP \fBtill\fP 10
This field contains the expiration date requested by the client in a
ticket request.

.IP \fBrtime\fP 10
This field is the requested \fBrenew-till\fP time sent from a client to the
KDC in a ticket request.  It is optional.

.IP \fBnonce\fP 10
This field is part of the KDC request and response.  It it intended to
hold a random number generated by the client.  If the same number is
included in the encrypted response from the KDC, it provides evidence
that the response is fresh and has not been replayed by an attacker.
Nonces must never be re-used.  Ideally, it should be generated randomly,
but if the correct time is known, it may suffice\**.
.FS
Note, however, that if the time is used as the nonce, one must
make sure that the workstation time is monotonically increasing.  If
the time is ever reset backwards, there is a small, but finite,
probability that a nonce will be reused.
.FE

.IP \fBetype\fP 10
This field specifies the desired encryption algorithm to be used in the
response.

.IP \fBaddresses\fP 10
This field is included in the initial request for tickets, and
optionally included in requests for additional tickets from the
ticket-granting server.  It  
specifies the addresses from which the requested ticket is to be
valid.  Normally it includes the addresses for the client's
host.  If a proxy is requested, this field will contain other
addresses.  The contents of this field are usually copied by the KDC into the
\fBcaddr\fP field of the resulting ticket.

.IP \fBadditional-tickets\fP 10
.br
Additional tickets may be optionally included in a request to the
ticket-granting server. If the ENC-TKT-IN-SKEY option has been
specified, then the session key from the additional ticket will be used
in place of the server's key to encrypt the new ticket.  If more than
one option which requires additional tickets has been specified, then
the additional tickets are used in the order specified by the ordering
of the options bits (see kdc-options, above).

.PP
The application code will be either ten (10) or twelve (12) depending
on whether the request is for an initial ticket (AS-REQ) or for an
additional ticket (TGS-REQ).
.PP
The optional fields (\fBaddresses, authorization-data\fP and
\fBadditional-tickets\fP) are only included if necessary to perform the
operation specified in the \fBkdc-options\fP field.
.PP
It should be noted that in KRB_TGS_REQ, the protocol version number
appears twice and two different message types appear:  the KRB_TGS_REQ
message contains these fields as does the authentication header
(KRB_AP_REQ) that is passed in the \fBpadata\fP field.
.N: sec 3 kdc_rep_def "KRB_KDC_REP definition"
.PP
The KRB_KDC_REP message format is used for the reply from the KDC for
either an initial (AS) request or a subsequent (TGS) request.  There
is no message type for KRB_KDC_REP.  Instead, the type will be either
KRB_AS_REP or KRB_TGS_REP.  The key used to encrypt the ciphertext
part of the reply depends on the message type.  For KRB_AS_REP, the
ciphertext is encrypted in the client's secret key, and the client's
key version number is included in the key version number for the
encrypted data.  For KRB_TGS_REP, the ciphertext is encrypted in the
session key from the ticket-granting ticket used in the request.  In
that case, no version number will present in the EncryptedData sequence.
.PP
The KRB_KDC_REP message contains the following fields:
.KS
.TS
center;
lb l l.
KDC-REP ::=	[APPLICATION 11 or 13\(dg] SEQUENCE {
	pvno[0]	INTEGER,
	msg-type[1]	INTEGER,
	padata[2]	PA-DATA OPTIONAL,
	crealm[3]	Realm,
	cname[4]	PrincipalName,
	ticket[5]	Ticket,		-- Ticket
	enc-part[6]	EncryptedData	-- EncKDCRepPart
}
.TE
.FS \(dg
[APPLICATION 11 or 13] is not valid ASN.1 notation. 
The two types of messages (AS-REQ and TGS-REQ) have different
application codes, but the format of the remainder of the
message is identical (before encryption of the encrypted part).  
.FE
.KE
.KS
.TS
center;
lb l l.
EncKDCRepPart ::=	[APPLICATION 25 or 26\(dd] SEQUENCE {
	key[0]	EncryptionKey,
	last-req[1]	LastReq,
	nonce[2]	INTEGER,
	key-expiration[3]	KerberosTime OPTIONAL,
	flags[4]	TicketFlags,
	authtime[5]	KerberosTime,
	starttime[6]	KerberosTime OPTIONAL,
	endtime[7]	KerberosTime,
	renew-till[8]	KerberosTime OPTIONAL,
	srealm[9]	Realm,
	sname[10]	PrincipalName,
	caddr[11]	HostAddresses OPTIONAL
}
.TE
.FS \(dd
An application code in the encrypted part of a
message provides an additional check that the message was decrypted
properly.
.FE
.KE
.IP "\fBpvno\fP and \fBmsg-type\fP" 10
.br
These fields are described above in section ~sec kdc_req_def~.
\fBmsg-type\fP is either KRB_AS_REP or KRB_TGS_REP.

.IP \fBpadata\fP
This field is described in detail above.  One possible use for this
field is to encode an alternate "mix-in" string to be used with a
string-to-key algorithm (such as is described in ~sec des-cbc-crc~).
This ability is useful to ease transitions if a realm name needs to
change (e.g. when a company is acquired); in such a case all existing
password-derived entries in the KDC database would be flagged as needing a
special mix-in string until the next password change.

.IP "\fBcrealm, cname, srealm\fP and \fBsname\fP" 10
.br
These fields are the same as those described for the ticket in section
~sec ticket_def~.

.IP \fBticket\fP
The newly-issued ticket, from section ~sec ticket_def~.

.IP \fBenc-part\fP 10
This field is a place holder for the ciphertext and related
information that forms the encrypted part of a message.  The
description of the encrypted part of the message follows each
appearance of this field.
The encrypted part is encoded as described in section ~sec enc_spec_def~.  

.IP "\fBkey\fP" 10
This field is the same as described for the ticket in section
~sec ticket_def~.

.IP \fBlast-req\fP 10 
This field is returned by the KDC and
specifies the time(s) of the last request by a principal.  Depending on
what information is available, this might be the last time that a
request for a ticket-granting ticket was made, or the last time that a
request based on a ticket-granting ticket was successful.  It also
might cover all servers for a realm, or just the particular server.
Some implementations may display this information to the user to aid in
discovering unauthorized use of one's identity.  It is similar in spirit to
the last login time displayed when logging into timesharing systems.

.IP \fBnonce\fP 10
This field is described above in section ~sec kdc_req_def~.

.IP \fBkey-expiration\fP 10
.br
The \fBkey-expiration\fP field is part of the response from the KDC and
specifies the time that the client's secret key is due to expire.  The
expiration might be the result of password aging or an account expiration.
This field
will usually be left out of the TGS reply since the response to the
TGS request is encrypted in a session key and no client information need
be retrieved from the KDC database.  It is up to the
application client (usually the login program) to take appropriate
action (such as notifying the user) if the expiration time is imminent.  

.IP "\fBflags, authtime, starttime, endtime, renew-till\fP and \fBcaddr\fP" 10
.br
These fields are duplicates of those found in the encrypted portion of
the attached ticket (see section ~sec ticket_def~), provided so the
client may verify they match the intended request and to assist in
proper ticket caching.  If the message is of type KRB_TGS_REP, the
\fBcaddr\fP field will only be filled in if the request was for a proxy
or forwarded ticket, or if the user is substituting a subset of the
addresses from the ticket granting ticket.  If the client-requested
addresses are not present or not used, then the addresses contained in
the ticket will be the same as those included in the ticket-granting
ticket.

