.\"	$Source: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/KRB_SAFE.ms,v $
.\"	$Author: jtkohl $
.\"	$Header: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/KRB_SAFE.ms,v 1.28 90/12/19 17:06:31 jtkohl Exp $
.\"
.ds R# "$Id: KRB_SAFE.ms,v 1.28 90/12/19 17:06:31 jtkohl Exp $
.N: sec 2 krb_safe "The KRB_SAFE Exchange"
.PP
The KRB_SAFE message may be used by clients requiring the ability to
detect modifications of messages they exchange.  It achieves this by
including a keyed collision-proof checksum of the user data and
some control information.  The checksum is keyed with an encryption key
(usually the last key negotiated via subkeys, or the session key if no
negotiation has occured).
.N: sec 3 generate_krb_safe "Generation of a KRB_SAFE message"
.LP
When an application wishes to send a KRB_SAFE message, it collects its
data and the appropriate control information and computes a checksum
over them.  The checksum algorithm should be some sort of
keyed one-way hash function (such as the RSA-MD4-DES checksum
algorithm specified in section ~sec rsa_md4_des~, or the DES MAC),
generated using the session key.  Different algorithms may be selected
by changing the checksum type in the message.  \fBUnkeyed or
non-collision-proof checksums are not suitable for this use.\fP
.PP
The control information for the KRB_SAFE message includes both a
timestamp and a sequence number.  The designer of an application using
the KRB_SAFE message must choose at least one of the two mechanisms.
This choice should be based on the needs of the application protocol.
.PP
Sequence numbers are useful when all messages sent will be received by
one's peer.  Connection state is presently required to maintain the
session key, so maintaining the next sequence number should not present
an additional problem.
.PP
If the application protocol is expected to tolerate lost messages
without them being resent, the use of the timestamp is the appropriate
replay detection mechanism.  Using timestamps is also the appropriate
mechanism for multi-cast protocols where all of one's peers share a
common subsession key, but some messages will be sent to a subset of
one's peers.
.PP
After computing the checksum, the client then transmits the information
and checksum to the recipient in the message format specified in section
~sec krb_safe_def~.
.N: sec 3 foo48 "Receipt of KRB_SAFE message"
.LP
When an application receives a KRB_SAFE message, it verifies it as follows.
If any error occurs, an error code is reported for use by the application.
.PP
The message is first checked by verifying
that the protocol version and type fields match the current version and
KRB_SAFE, respectively.  A mismatch generates a KRB_AP_ERR_BADVERSION or
KRB_AP_ERR_MSG_TYPE error.  The application verifies that the checksum
used is a collision-proof keyed checksum, and if it is not, a
KRB_AP_ERR_INAPP_CKSUM is generated.
The recipient verifies that the operating system's report of the
sender's address matches the sender's address in the message, and (if a
recipient address is specified or the recipient requires an address) that
one of the recipient's addresses appears as the recipient's address in
the message.  A failed match for either case generates a
KRB_AP_ERR_BADADDR error.
Then the timestamp and usec and/or the sequence number fields are
checked.  If timestamp and usec are expected and not present, or they
are present but not
current, the KRB_AP_ERR_SKEW error is generated.  If the server name, along with the client name, time and microsecond
fields from the Authenticator match any recently-seen such tuples,
the KRB_AP_ERR_REPEAT error is generated.
.\" XXX what about self-messages?  Cliff's comments on shared caches, etc.
If an incorrect
sequence number is included, or a sequence number is expected but not
present, the KRB_AP_ERR_BADORDER error is generated.
If neither a timestamp and usec or a sequence number is present, a
KRB_AP_ERR_MODIFIED error is generated.
Finally, the checksum is computed over the data and control information,
and if it doesn't match the received checksum, a KRB_AP_ERR_MODIFIED error is
generated.
.PP
If all the checks succeed, the application is assured that the message was
generated by its peer and was not modified in transit.
