.\"	$Source: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/TGS.ms,v $
.\"	$Author: jtkohl $
\"	$Header: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/TGS.ms,v 1.44 91/02/18 11:45:25 jtkohl Exp $
.\"
.ds R# "$Id: TGS.ms,v 1.44 91/02/18 11:45:25 jtkohl Exp $
.N: sec 2 tgs-exch "The Ticket-Granting Service (TGS) Exchange"
.TS
center;
c s s
l l l.
Summary
\fIMessage direction	Message type	Section\fR
1. Client to Kerberos	KRB_TGS_REQ	~sec kdc_req_def~
2. Kerberos to client	KRB_TGS_REP or	~sec kdc_rep_def~
	KRB_ERROR	~sec krb_error_def~
.TE
.PP
The TGS exchange between a client and the
Kerberos Ticket-Granting Server is initiated by a client when it wishes
to obtain
authentication credentials for a given server (which might be registered in a
remote realm), when it wishes to renew
or validate an existing ticket, or when it wishes to obtain a proxy
ticket.  In the first case, the client must
already have acquired a ticket for the Ticket-Granting Service using
the AS exchange (the ticket-granting ticket is usually obtained when a
client initially authenticates to the system, such as when a user logs in).
The message format for the TGS exchange is almost identical to that for the AS exchange.  The primary difference is that encryption and decryption in the TGS
exchange does not take place under the client's key.  Instead, the
session key from the ticket-granting ticket or renewable ticket is used.
As is the case for all application servers, expired tickets are not
accepted by the TGS, so once a renewable or ticket-granting ticket
expires, the client must use a separate exchange to obtain valid tickets.
.PP
The TGS exchange consists of two messages: A request (KRB_TGS_REQ)
from the client to the Kerberos Ticket-Granting Server, and a reply
(KRB_TGS_REP or KRB_ERROR).  The TGS request includes information
authenticating the client plus a request for credentials.  The
authentication information consists of the authentication header
(KRB_AP_REQ) which includes the client's previously obtained
ticket-granting, renewable, or invalid ticket.  In the ticket-granting
ticket and proxy cases, the request may include one or more of: a list
of network
addresses, a collection of typed authorization data to be sealed in the ticket
for authorization use by the application server, or additional tickets (the
use of which are described later).  The TGS reply (KRB_TGS_REP) contains
the requested credentials, encrypted in the session key from the
ticket-granting ticket or renewable ticket.  The KRB_ERROR message
contains an error code
and text explaining what went wrong.  The KRB_ERROR message is not
encrypted.  The KRB_TGS_REP message contains
information which can be used to detect replays, and to associate it
with the message to which it replies.  The KRB_ERROR message also
contains information which can be used to associate it
with the message to which it replies, but the lack of encryption in the
KRB_ERROR message precludes the ability to detect replays or
fabrications of such messages.
.N: sec 3 foo58 "Generation of KRB_TGS_REQ message"
.PP
Before sending a request to the ticket-granting service, the client
must determine in which realm the application server is registered\**.
.FS
This can be accomplished in several ways.  It might be known
beforehand (since the realm is part of the principal identifier), or it
might be
stored in a nameserver.  Presently, however, this information is
obtained from a configuration file.  If the realm to be used
is obtained from a nameserver, there is a danger of being spoofed if
the nameservice providing the realm name is not authenticated.  This
might result in the use of a realm which has been compromised, and
would result in an attacker's ability to compromise the authentication
of the application server to the client.
.FE
If the client does not already possess a ticket-granting ticket for
the appropriate realm, then one must be obtained.  This is first
attempted by requesting a ticket-granting ticket for the destination
realm from the local Kerberos server (using the TGS request message
recursively).  The Kerberos server may return a TGT for the desired
realm in which case one can proceed.  Alternatively, the Kerberos
server may return a TGT for a realm which is "closer" to the desired
realm (further along the standard hierarchical path), in which case this step must be repeated with a Kerberos server
in the realm specified in the returned TGT.  If neither are returned,
then the request must be retried with a Kerberos server for a realm
higher in the hierarchy.  This request will itself require a
ticket-granting ticket for the higher realm which must be obtained by
recursively applying these directions.
.PP
Once the client obtains a ticket-granting ticket for the appropriate
realm, it determines which Kerberos servers serve that realm, and
contacts one.  The list might be obtained through a configuration file or
network service; as long as the secret keys exchanged by realms are kept
secret, only denial of service results from a false Kerberos server. 
.PP
As in the AS exchange, the client may specify a number of options in the
TGS request.
The client prepares the KRB_TGS_REQ message, providing an authentication
header as an element of the \fBpadata\fP field, and including the same fields
as used in the KRB_AS_REQ message along with several optional fields: the
\fBenc-authorization-data\fP field for application server use and additional
tickets
required by some options.  If the \fBenc-authorization-data\fP is present,
it must be encrypted in a sub-session key included in the
authenticator portion of the authentication header.
.PP
Once prepared, the message is sent to a
Kerberos server for the destination realm.
See section ~sec tgs_req_g_pc~ for pseudocode.
.N: sec 3 foo59 "Receipt of KRB_TGS_REQ message"
.PP
The TGS request is processed in a manner similar to the AS request,
but there are many additional checks to be performed.  
First, the Kerberos server must determine which server the
accompanying ticket is for and it must select the
appropriate key to decrypt it.  For a normal TGS request,
it will be for the ticket granting service, and the TGS's key will be used.  If the TGT was issued by
another realm, then the appropriate inter-realm key must be used.  If
the accompanying ticket is not a ticket granting ticket, but is for an
application server in the current realm,
and the RENEW, VALIDATE, or PROXY options are specified in the
request, then the KDC will decrypt the ticket in the authenticator
using the key of the server to which it was issued.
If no ticket can be found in the \fBpadata\fP field, the
KDC_ERR_PADATA_TYPE_NOSUPP error is returned.
.PP
Once the accompanying ticket has been decrypted, 
the user-supplied checksum in the Authenticator 
must be verified against the contents of the request,
and the message rejected if the checksums do not match (with an error
code of KRB_AP_ERR_MODIFIED) or if the
checksum is not keyed or not collision-proof (with an error code of
KRB_AP_ERR_INAPP_CKSUM).  If the checksum type is not supported, the
KDC_ERR_SUMTYPE_NOSUPP error is returned.
If the \fBauthorization-data\fP are present, they are decrypted using
the sub-session key from the Authenticator.
.PP
If any of the decryptions indicate failed integrity checks, the
KRB_AP_ERR_BAD_INTEGRITY error is returned.
.N: sec 3 generate_tgs_rep "Generation of KRB_TGS_REP message"
.PP
The KRB_TGS_REP message shares its format with the
KRB_AS_REP (KRB_KDC_REP), but with its type field set to KRB_TGS_REP.  The
detailed specification is in section ~sec kdc_rep_def~.
.PP
The response will include a ticket for the requested server.  The
Kerberos database is queried to retrieve the record for the
requested server (including the key with which the ticket will be
encrypted).  If the request is for a ticket granting ticket for
a remote realm, and if no key is shared with the requested realm, then
the Kerberos server will select the realm "closest" to the
requested realm with which it does share a key, and use that
realm instead.  This is the only case where the response from the KDC
will be for a different server than that requested by the client.
.PP 
By default, the address field, the client's name and realm, the list
of transited realms, the time of initial authentication, the
expiration time, and the authorization data of the newly-issued ticket
will be copied from the ticket-granting ticket (TGT) or renewable
ticket.  If the transited field needs to be updated, but the transited
type is not supported, the KDC_ERR_TRTYPE_NOSUPP error is returned.
.PP
If the request specifies an endtime, then the
endtime of the new ticket
is set to the minimum of (a) that request, (b) the endtime from the TGT,
and (c) the starttime of the TGT plus the minimum of the maximum life for
the application server
and the maximum life for the local realm (the maximum life for the
requesting principal was already applied when the TGT was issued).  If
the new ticket is to be a
renewal,
then the endtime above is replaced by the minimum of (a) the value
of the renew_till field of the ticket and (b) the
starttime for the new ticket plus the life (endtime-starttime) of the
old ticket.
.PP
If the FORWARDED option has been requested, then the resulting ticket
will contain the addresses specified by the client.  This option will
only be honored if the FORWARDABLE flag is set in the TGT.
The PROXY option is similar;  the resulting ticket
will contain the addresses specified by the client.  It will be honored
only if the PROXIABLE flag in the TGT is set.  The PROXY option
will not be honored on requests for additional ticket-granting
tickets.
.PP
If the requested start time is absent or indicates a time in the past,
then the start time of the ticket is set to the authentication
server's current time.  If it indicates a time in the future, but the
POSTDATED option has not been specified or the MAY-POSTDATE flag is not
set in the TGT, then the error
KDC_ERR_CANNOT_POSTDATE is returned.  Otherwise, if the
ticket-granting ticket has the MAY-POSTDATE flag set, then the
resulting ticket will be postdated and the requested starttime is
checked against the policy of the local realm. If acceptable, the
ticket's start time is set as requested, and the INVALID flag is set.
The postdated ticket must be validated before use by presenting it to
the KDC after the starttime has been reached.  However, in no case may
the starttime, endtime, or renew-till time of a newly-issued postdated
ticket extend beyond the renew-till time of the ticket-granting ticket.
.PP
If the ENC-TKT-IN-SKEY option has been specified, and if an additional ticket has
been included in the request, then the KDC will  verify that the
principal identifier of the server in the ticket matches the requested
server in the KDC request (to make sure someone doesn't insert a
different ticket in the request), decrypt
the additional ticket using the key for the server to which it was issued,
verify that it is a ticket-granting ticket, and use the session key
from the additional ticket to encrypt the new ticket it will issue instead
of encrypting the new ticket in the key of the server for which it is
to be issued\**.
.FS
This allows easy implementation of the Davis & Swick proposal
.[ [
DavisSwick
.]]
to
use ticket-granting ticket session keys in lieu of secret server keys
in situations where such secret keys could be easily compromised.
.FE
.PP
If the name of the server in the ticket that is presented to the KDC as
part of the authentication header is not that of the ticket-granting server
itself, and the server is registered in the realm of the KDC,
If the RENEW option is requested, then the KDC will
verify that the RENEWABLE flag is set in the ticket and that the
renew_till time is still in the future.
If the VALIDATE option is rqeuested, the KDC will check that the
starttime has passed and the INVALID flag is set.
If the PROXY option is requested, then the KDC will check that the
PROXIABLE flag is set in the ticket.
If the tests succeed, the KDC will issue the appropriate new ticket.
.PP
Whenever a request is made to the ticket-granting server, the
presented ticket(s)
is(are) checked against a hot-list of tickets which have
been canceled.  This hot-list might be implemented by storing a range of
issue dates for "suspect tickets"; if a presented ticket had an authtime
in that range, it would be rejected.
In this way, a stolen ticket-granting ticket or
renewable ticket cannot
be used to gain additional tickets (renewals or otherwise) once the
theft has been reported.  Any normal ticket obtained before it was
reported stolen will still be valid (because they require no
interaction with the KDC), but only until their normal expiration time.
.PP
The ciphertext part of the response in the KRB_TGS_REP message is encrypted in
the session key from the ticket-granting ticket instead of the
client's secret key.  Furthermore, the client's key's expiration date
and the key version number fields are left out since these values are
stored along with the client's database record, and that record is not
needed to satisfy a request based on a ticket-granting ticket.
See section ~sec tgs_rep_g_pc~ for pseudocode.
.N: sec 4 transited_spec "Encoding the transited field"
.PP
If the identity of the server in the TGT that is presented to the KDC as
part of the authentication header is that of the ticket-granting service, but
the TGT was issued from another realm,
the KDC will look up the inter-realm key shared with that
realm and use that key to decrypt the ticket.  If the ticket is
valid, then the KDC will honor the request, subject to the constraints
outlined above in the section describing the AS exchange.  The realm
part of the 
client's identity will be taken from the ticket-granting ticket.
The name of the realm that issued the ticket-granting ticket will be
added to the transited field of the ticket to be issued.  This is
accomplished by reading the transited field from the ticket-granting
ticket, adding the new realm, then constructing and writing out its
encoded (shorthand) form (this may involve a rearrangement of the
existing encoding).
.PP
Note that the ticket-granting service does not add
the name of its own realm.  Instead, its responsibility is to add the
name of the previous realm.  This prevents a malicious Kerberos from
intentionally leaving out its own name (it could, however, omit other
realms' names).
.PP
The names of neither the local realm nor the principal's realm are to
be included in the transited field.  They appear elsewhere in the
ticket and both are known to have taken part in authenticating the
principal.  Since the endpoints are not included, both local and
single-hop inter-realm authentication result in a transited field that
is empty.
.PP
Because the name of each realm transited is added to this field, it
might potentially be very long.  To decrease the length of this field,
its contents are encoded.  The initially supported encoding is
optimized for the normal case of inter-realm communication: a
hierarchical arrangement of realms using either domain or X.500 style
realm names.  This encoding (called DOMAIN-X500-COMPRESS) is now described.
.PP
Realm names in the transited field are separated by a ",".  The ",", "\\",
trailing "."s, and leading spaces (" ") are special characters,
and if they are part of a realm name, they must be quoted in the
transited field by preceding them with a "\\".
.PP
A realm name ending with a "." is interpreted as
being prepended to the previous realm.  For example, we can encode
traversal of EDU, MIT.EDU, ATHENA.MIT.EDU, WASHINGTON.EDU, and
CS.WASHINGTON.EDU as:
.nf
.ti +.5i
"EDU,MIT.,ATHENA.,WASHINGTON.EDU,CS.".
.fi
Note that if ATHENA.MIT.EDU, or CS.WASHINGTON.EDU were endpoints, that
they would not be included in this field, and we would have:
.nf
.ti +.5i
"EDU,MIT.,WASHINGTON.EDU"
.fi
A realm name beginning with a "/" is interpreted as being appended to
the previous realm\**.
.FS
For the purpose of appending, the realm preceding the first listed
realm is considered to be the null realm ("").
.FE
If it is to stand by itself, then it should be
preceded by a space (" ").  For example, we can encode traversal of
/COM/HP/APOLLO, /COM/HP, /COM, and /COM/DEC as:
.nf
.ti +.5i
"/COM,/HP,/APOLLO, /COM/DEC".
.fi
Like the example above, if /COM/HP/APOLLO and /COM/DEC are endpoints, they
they would not be included in this field, and we would have:
.nf
.ti +.5i
"/COM,/HP"
.fi
.PP
A null subfield preceding or following a "," indicates that all realms
between the previous realm and the next realm have been traversed\**.
.FS
For the purpose of interpreting null subfields, the client's realm is
considered to precede those in the transited field, and the server's
realm is considered to follow them.
.FE
Thus, "," means that all realms along the path between the client and
the server have been traversed. ",EDU, /COM," means that that all
realms from the client's realm up to EDU (in a domain style hierarchy)
have been traversed, and that everything from /COM down to the
server's realm in an X.500 style has also been traversed.  This could
occur if the EDU realm in one hierarchy shares an inter-realm key
directly with the /COM realm in another hierarchy.
.N: sec 3 foo61 "Receipt of KRB_TGS_REP message"
.LP
When the KRB_TGS_REP is received by the client, it is processed in the
same manner as the KRB_AS_REP processing described above.
The primary difference is that the ciphertext part of the response
must be decrypted using the session key from the ticket-granting
ticket rather than the client's private key.
See section ~sec tgs_rep_v_pc~ for pseudocode.
