@device[postscript]
@make[report]
@DefineFont(HeadingFont,
      P=<RawFont "NewCenturySchlbkBoldItalic">,
      B=<RawFont "NewCenturySchlbkBold">,
      I=<RawFont "NewCenturySchlbkBoldItalic">,
      R=<RawFont "NewCenturySchlbkRoman">)
@Counter(MajorPart,TitleEnv HD0,ContentsEnv tc0,Numbered [@I],
          IncrementedBy Use,Announced)
@Counter(Chapter,TitleEnv HD1,ContentsEnv tc1,Numbered [@1. ],
          IncrementedBy Use,Referenced [@1],Announced)
@Counter(Appendix,TitleEnv HD1,ContentsEnv tc1,Numbered [@A. ],
          IncrementedBy,Referenced [@A],Announced,Alias Chapter)
@Counter(UnNumbered,TitleEnv HD1,ContentsEnv tc1,Announced,Alias 
           Chapter)
@Counter(Section,Within Chapter,TitleEnv HD2,ContentsEnv tc2,
          Numbered [@#@:.@1 ],Referenced [@#@:.@1],IncrementedBy
          Use,Announced)
@Counter(AppendixSection,Within Appendix,TitleEnv HD2,
          ContentsEnv tc2,
          Numbered [@#@:.@1 ],Referenced [@#@:.@1],IncrementedBy 
          Use,Announced)
@Counter(SubSection,Within Section,TitleEnv HD3,ContentsEnv tc3,
          Numbered [@#@:.@1 ],IncrementedBy Use,
          Referenced [@#@:.@1 ])
@Counter(AppendixSubSection,Within AppendixSection,TitleEnv HD3,
          ContentsEnv tc3,
          Numbered [@#@:.@1 ],IncrementedBy Use,
          Referenced [@#@:.@1 ])
@Counter(Paragraph,Within SubSection,TitleEnv HD4,ContentsEnv tc4,
          Numbered [@#@:.@1 ],Referenced [@#@:.@1],
          IncrementedBy Use)
@modify(CopyrightNotice, Fixed -1 inch, Flushright)
@Modify(Titlebox, Fixed 3.0 inches)
@Modify(hd1, below .2 inch, facecode B, size 16, spaces kept, pagebreak off)
@Modify(hd2, below .2 inch, facecode B, size 14, spaces kept)
@Modify(hd3, below .2 inch, facecode B, size 12, spaces kept)
@Modify(Description, Leftmargin +20, Indent -20,below 1 line, above 1 line)
@Modify(Tc1, Above .5,  Facecode B)
@Modify(Tc2, Above .25, Below .25, Facecode R)
@Modify(Tc3,Facecode R)
@Modify(Tc4,Facecode R)
@Modify(Itemize,Above 1line,Below 1line)
@Modify(Insert,LeftMargin +2, RightMargin +2)
@libraryfile[stable]
@Style(Font NewCenturySchoolBook, size 11)
@Style(Spacing 1.1, indent 0)
@Style(leftmargin 1.0inch)
@Style(justification no)
@Style(BottomMargin 1.5inch)
@Style(ChangeBarLocation Right)
@Style(ChangeBars=off)
@pageheading[immediate]
@pagefooting[immediate, left = "MIT Project Athena", center = "@value(page)",
right = "December 9, 1987"]
@set[page = 1]
@blankspace[.5 inches]
@begin[group, size 20]
@begin(center)
@b[Kerberos Operation Notes]

@b[DRAFT]
@end[center]
@end(group)

@chapter[Preparing the Master Database and Server]

Assuming you have installed the Kerberos adminstrative
programs in an appropriate place,
use the @i[kdb_init] program to create and initialize
the principal database.
This program asks you to supply the system's
realm name and the database's master password.
Do not forget this password.
If you do, the database becomes useless.

Use @i[kdb_init] as follows:
@tabset[3inches]
@begin[example]
host# @b[kdb_init]
Realm name: @p[REALMNAME]@\@p[<-- Enter your system's realm name.]
You will be prompted for the database Master Password.
It is important that you NOT FORGET this password.
Enter Password: @\@p[<-- Enter the master password]
Verifying, please re-enter Enter Password: 
@end[example]

@section[Storing the Master Password]

The @i[kstash] command "stashes" the master password in a secret
place so that the @i[kerberos] and @i[admin_server] servers can
be started automatically during an automatic reboot of the
master server.
Other administrative programs use this hidden password so that they
can access the master database without someone having to manually
provide the master password.
The command prompts you twice for the master password:
@begin[example]
@tabset[3inches]
host# @b[kstash]

Current Kerberos master key version is 1
Enter current Kerberos master key: @\@p[<-- Enter the master password.]
Verifying, please re-enter 
Enter current Kerberos master key: host#@\@p[<-- Should have a newline here.]
@end[example]

@chapter[Using kdb_edit to Add Users to the Master Database]

The @i[kdb_edit] program is used to add new users and services
to the master database, and to modify existing database information.
The program prompts you to enter a principal's @b[name] and @b[instance].

A principal name is either a username or a service program's name.
An instance further qualifies the principal.
If the principal is a service,
the instance specifies the name of the machine on which that
service runs.
If the principal is a username that has general user privileges,
the instance is usually set to null.
Eventually you will be able to create users with @b[admin] instances.
These users will then be able to use the @i[kadmin] program
to modify the Kerberos master database over the network.

The following example shows how to use @i[kdb_edit] to
add the user @i[wave] to the Kerberos database.
@begin[example]
@tabset[3inches]
host# @b[kdb_edit]

Opening database...
Current Kerberos master key version is 1
Enter current Kerberos master key: 
Verifying, please re-enter 
Enter current Kerberos master key: 
master key entered.  BEWARE!

Previous or default values are in [brackets] ,
enter return to leave the same, or new value.

Principal name: @b[wave]@\@p[<-- Enter the username.]
Instance:@\@p[<-- Enter a null instance.]

<Not found>, Create [y] ? @b[y]@\@p[<-- The user-instance does not exist.]
@\@p[    Enter y to create the user-instance.]
Principal: wave  Instance:  m_key_v: 1
New Password: @\@p[<-- Enter the user-instance's password.]
Verifying, please re-enter 
New Password:
Principal's new key version = 1
Expiration date (enter dd-mm-yy) [ 12/31/99 ] ? 
Max ticket lifetime (*5 minutes) [ 255 ] ? 
Attributes [ 0 ] ? 
Edit O.K.

Principal name:@\@p[<-- Enter a newline to exit the program.]
@end[example]

@Chapter[Starting the Kerberos Server]

Change directories to the directory in which you have installed
the server program @i[kerberos],
and start the program as a background process:
@begin[example]
host# @b[kerberos &]
@end[example]

@chapter[Installing the Sample Application Server and Clinet]

This release of Kerberos comes with a sample application
server and an corresponding client program.
You will find this software in the @b[$OBJDIR]@i[/appl/sample] directory.
The file @i[sample_client] contains the client program's executable
code, the file @i[sample_server] contains the server's executable.

The programs are rudimentary.
@begin[itemize]
The user starts @i[sample_client] and provides as an argument
to the command the name of the server machine.
For instance:
@begin[example]
host% @b[sample_client]  @p[servername]
@end[example]

@i[Sample_client] contacts the server machine and
authenticates the user to @i[sample_server].

@i[Sample_server] authenticates itself to @i[sample_client],
then returns a message to the client program.
This message contains diagnostic information
that includes the user's username, the Kerberos realm,
the user's workstation address.

@i[Sample_client] displays the server's message on the user's
terminal screen.
@end[itemize]

Suppose you install @i[sample_server] on the machine
@i[ARIADNE.OCEAN.EDU].
Suppose the local Kerberos realm is PACIFIC.OCEAN.EDU.
Your username is @i[francis],
and you are logged in to a workstation with the network address
18.72.1.3.
Here's how you enter the @i[sample_client] command,
and here's what the program displays:
@begin[example]
host% @b[sample_client   ariadne]
The server says:
You are francis.@@PACIFIC.OCEAN.EDU (local name francis),
 at address 18.72.1.3, version VERSION9, cksum 997
@end[example]

Of course none of this works until you install the sample programs
and add the appropriate entries to the Kerberos database.

@section[The Installation Process]

In general,
you use the following procedure to install a Kerberos-authenticated
server-client system.
@begin[enumerate]
Add the appropriate entry to the Kerberos database.

Create a @i[/etc/srvtab] file for the server machine.

Install the service program and the @i[/etc/srvtab]
file on the service machine.

Install the client progam on the system's workstations
and update each workstation's @i[/etc/services] file appropriately.
@end[enumerate]

The procedure used to install @i[sample_server] differs slightly
from that listed above because @i[sample_server]
does not start on its own and run continuously.
Instead, @i[sample_server] takes requests via the
@i[inetd] program.
@i[Inetd] starts @i[sample_server] each time
a client process contacts the server machine.
@i[Sample_server] processes the request,
halts, then starts again when @i[inetd] receives another
@i[sample_client] request.
When you install the on the server,
you must add a @i[sample_server] entry to the server machine's
@i[/etc/inetd.conf] file.

The following description assumes that you are installing
@i[sample_server] on the machine @i[ARIADNE.OCEAN.EDU].
Here's the process, step by step:
@begin[enumerate]
Login as or @i[su] to root on the Kerberos server machine.
Use the @i[kdb_edit] program to create an entry for
@i[sample_server] in the Kerberos database:
@begin[example]
host# @b[kdb_edit]

Opening database...
Current Kerberos master key version is 1
Enter current Kerberos master key: @p[Enter Master Password.] 
Verifying, please re-enter 
Enter current Kerberos master key:
master key entered.  BEWARE!
Previous or default values are in [brackets] ,
enter return to leave the same, or new value.

Principal name: @b[sample_server]
Instance: @b[ariadne] @p[Instances cannot have periods in them.]

<Not found>, Create [y] ? @b[y]

Principal: sample_server  Instance: ariadne m_key_v: 1
New Password:    @p[Enter RANDOM to get random password.]
Verifying, please re-enter 
New Password:    @p[Enter RANDOM again.]
Random password [y] ? @b[y]

Principal's new key version = 1
Expiration date (enter dd-mm-yy) [ 12/31/99 ] ? 
Max ticket lifetime (*5 minutes) [ 255 ] ? 
Attributes [ 0 ] ? 
Edit O.K.than there were space for

Principal name:  @p[Enter newline to exit kdb_edit.]
@end[example]

Use the @i[ext_srvtab] program to create a @i[srvtab] file
for @i[sample_server]'s host machine:
@begin[example]
host# @b[ext_srvtab  ariadne]

Enter current Kerberos master key: 
Verifying, please re-enter 
Enter current Kerberos master key: 
Master key verified.

Generating 'ariadne-new-srvtab'....
@end[example]
Transfer this file to @i[ariadne] and install it as
@i[/etc/srvtab].  This file should be readable only by root.

Add the following line to the @i[/etc/services] file on
@i[ariadne], and on all machines that
will run the @i[sample_client] program:
@begin[example]
sample     906/tcp       # kerberos sample app server
@end[example]

Add the following line to the @i[/etc/inetd.conf]
file on @i[sample_server]'s machine:
@begin[example]
sample  stream  tcp     nowait  switched  root
/site/kerberos/appl/sample/sample_server   sample_server
@end[example]
(This information should be placed on one line.)

Restart @i[inetd] by sending the current @i[inetd] process
a hangup signal:
@begin[example]
host# @b[kill  -HUP   @p(process_id_number)]
@end[example]

The @i[sample_server] is now ready to take @i[sample_client] requests.
@end[enumerate]


