.\"	$Source: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/Overview.ms,v $
.\"	$Author: jtkohl $
.\"	$Id: Overview.ms,v 1.42 91/02/18 11:44:47 jtkohl Exp $
.\"
.ds R# "$Id: Overview.ms,v 1.42 91/02/18 11:44:47 jtkohl Exp $
.PP
.TS
expand;
l r.
Network Working Group	John Kohl
Request for Comments: DRAFT 3	B. Clifford Neuman
	MIT Project Athena
	\n(dy \*(MO 19\n(yr
.TE
.sp 3
.ce 2
The Kerberos\(tm  Network Authentication Service
.FS
Project Athena, Athena, Athena MUSE, Discuss, Hesiod, Kerberos,
Moira, and Zephyr are trademarks of the Massachusetts Institute of
Technology (MIT).  No commercial use of these trademarks may be made
without prior written permission of MIT.
.FE
.sp
DRAFT
.fi
.SH
STATUS OF THIS MEMO
.PP
This DRAFT document gives an overview and specification of the Version
5 protocol for the Kerberos network authentication system.  Version 4,
described elsewhere
.[ [
KTech
.]]
.[
KUsenix
.]],
is presently in production use at MIT's Project Athena, and at other
Internet sites.  Distribution of this memo is unlimited.
.SH
OVERVIEW
.XS
Overview
.XE
.PP
This DRAFT RFC describes the concepts and model upon which the
Kerberos network authentication system is based.  It also specifies
the present proposal for Version 5.
.PP
The motivations, goals, assumptions, and rationale behind most design
decisions are treated cursorily; they are fully described for the
previous version in the Kerberos portion of the Athena Technical Plan
.[ [
KTech
.]].
The protocols are under review, and are not proposed as an Internet
standard at this time.
Comments are encouraged.
Requests for additions to an electronic mailing list on Kerberos discussions,
.C kerberos@athena.mit.edu,
may be addressed to
.C kerberos\-request@athena.mit.edu.
This mailing list is gatewayed onto the Usenet as the group
.C comp.protocols.kerberos.
Requests for further information, including documents and code
availability, may be sent to 
.C info\-kerberos@athena.mit.edu.

.SH
BACKGROUND
.XS
Background
.XE
.PP
The Kerberos model is based in part on Needham and Schroeder's trusted
third-party authentication protocol
.[ [
ACMNeedham
.]]
and on modifications suggested by
Denning and Sacco
.[ [
Denning
.]].
The original design and implementation of Kerberos Versions 1 through 4
was the work of two former Project
Athena staff members, Steve Miller of Digital Equipment Corporation
and Clifford Neuman (now of the
University of Washington), along with Jerome Saltzer, Technical Director
of Project Athena, and Jeffrey Schiller, MIT Campus Network Manager.
Many other members of Project Athena have also contributed to the work on
Kerberos.  Version 4 is publicly available, and has seen wide use across
the Internet community.
.PP
Version 5 (described in this document) has evolved from Version 4 based
on new requirements and desires for features not available in Version 4.
.N: sec 1 foo51 "Introduction"
.PP
Kerberos provides a means of verifying the identities of principals,
(e.g. a workstation user or a network server) on an open (unprotected)
network.  This is accomplished without relying on authentication by the
host operating system, without basing trust on host addresses\**,
.FS
Note, however, that many applications use Kerberos'
functions only upon
the \fBinitiation\fP of a stream-based network connection, and assume the
absence of any ``hijackers'' who might subvert such a connection.  Such
use implicitly trusts the host addresses involved.
.FE
without requiring physical security of all the hosts on the
network, and under the assumption that packets traveling along the
network can be read, modified, and inserted at will.  Kerberos performs
authentication under these conditions as a trusted third-party
authentication service by using conventional (shared secret key\**)
cryptography.
.FS
\fISecret\fP and \fIprivate\fP are often used interchangeably in the
literature.
In our usage, it takes two (or more) to share a secret, thus a shared
DES key is a \fIsecret\fP key.  Something is only private when no one
but its owner knows it.  Thus, in public key cryptosystems, one has a
public and a \fIprivate\fP key.
.FE
.PP
The authentication process proceeds as follows: A client sends a
request to the authentication server (AS) requesting "credentials" for
a given server.  The AS responds with these credentials, encrypted
in the client's key.  The credentials consist of 1) a "ticket" for the
server and 2) a temporary encryption key (often called a "session key").  The client
transmits the ticket (which contains the client's identity and a copy
of the session key, all encrypted in the server's key) to the server.  The
session key (now shared by the
client and server) is used to authenticate the client, and may
optionally be used to
authenticate the server.  It may also be used to encrypt further
communication between the two parties.
.PP
The implementation consists of one or more authentication servers
running on physically secure hosts.  The authentication servers
maintain a database of principals (i.e., users and servers) and their
secret keys.  Code libraries provide encryption and implement the Kerberos
protocol.  In order to add authentication to its transactions, a
typical network application adds one or two calls to the Kerberos
library, which results in the transmission of the necessary messages to
achieve authentication.
.PP
The Kerberos protocol consists of several sub-protocols (or exchanges).
There are two methods by which a client can ask a Kerberos server for
credentials.  In the first approach, the client sends a cleartext
request for a ticket for the desired server to the AS.  The reply is
sent encrypted in the client's secret 
key.  Usually this request is for a ticket-granting ticket (TGT) which
can later be used with the ticket-granting server (TGS).  In the second
method, the client sends a request to the TGS.  The client sends the TGT
to the TGS in the same manner as if it were contacting any other application
server which requires Kerberos credentials.  The reply is encrypted in
the session key from the TGT.
.PP
Once obtained, credentials may be used to verify the identity of the
principals in a transaction, to ensure the integrity of messages
exchanged between them, or to preserve privacy of the messages.  The
application is free to choose whatever protection may be necessary.
.PP
To verify the identities of the principals in a transaction, the
client transmits the ticket to the server.  Since the ticket is sent in
the clear, and might be intercepted and reused by an attacker,
additional information is sent to prove that the message was
originated by the principal to whom the ticket was issued.  This
information (called the \fIauthenticator\fP) is encrypted in the session
key, and
includes a timestamp.  The timestamp proves that the message was
recently generated and is not a replay.  Encrypting the authenticator
in the session key proves that it was generated by a party possessing
the session key.  Since no one except the requesting principal and the
server know the session key (it is never sent over the network in the
clear) this guarantees the identity of the client.
.PP
The integrity of the messages exchanged between principals can also be
guaranteed using the session key (passed in the ticket and contained
in the credentials).  This approach affords detection not only of
replay, but also of message stream modification.  This is
accomplished by generating and transmitting a collision-proof
checksum (elsewhere 
called a hash or digest function) of the
client's message.  The checksum is keyed with the session key.
Privacy and integrity of the messages exchanged between principals can be 
secured by encrypting the data to be passed using the session key
passed in the ticket, and contained in the credentials.
.PP
The authentication exchanges mentioned above require read-only access to
the Kerberos database.
Sometimes, however, the entries in the database must be modified, such as
when adding new principals or changing a principal's key.
This is done using a protocol between a client and a third Kerberos
server, the Kerberos Administration Server (KADM).  The administration
protocol is not described in this document.  There is also a protocol
for maintaining multiple copies of the Kerberos database, but this can
be considered an implementation detail and may vary to support different
database technologies.
.N: sec 2 foo991 "Inter-Realm Operation"
.PP
The Kerberos protocol is designed to operate across organizational
boundaries.  A client in one organization can be authenticated to a
server in another.  Each organization wishing to run a Kerberos
server establishes its own "realm".  The name of the realm in which a
client is registered is part of the client's name, and can be used by the
end service to decide whether to honor a request.
.PP
By establishing "inter-realm" keys, the administrators of two realms
can allow a client authenticated in the local realm to use its
authentication remotely.  The exchange of inter-realm keys (a separate
key may be used for each direction) registers
the ticket-granting service of each realm as a principal in the
other realm.
A client is then able to obtain a ticket-granting ticket
for the remote realm's ticket-granting service from its local realm.
When that ticket-granting ticket is
used, the remote ticket-granting service uses the inter-realm key (which
usually differs from its own normal TGS key) to
decrypt the ticket-granting ticket, and is thus certain that it was
issued by the client's local Kerberos.  Tickets issued by the remote
ticket-granting service will indicate that the client was
authenticated in its local realm.
.PP
A realm is said to \fIcommunicate\fP with another realm if the two realms
share an inter-realm key, or if the local realm shares an inter-realm
key with an intermediate realm that communicates with the remote
realm.  An \fIauthentication path\fP
is the sequence of intermediate realms
that are transited in communicating from one realm to another.
.PP
Realms are typically organized hierarchically.  Each realm shares a key
with its parent and a different key with each child.
If an inter-realm key is not
directly shared by two realms, the hierarchical organization allows an
authentication path to be easily constructed.  If a hierarchical
organization is not used, it may be necessary to consult some database
in order to construct an authentication path between realms.
.PP
Although realms are typically hierarchical, intermediate
realms may be bypassed to achieve inter-realm authentication through
alternate authentication paths (these might be established to make
communication between two realms more efficient).  It is important for the end
service to know which realms were transited when deciding how much faith
to place in the authentication process.  To facilitate this decision, a
field in each ticket contains the names of the realms that
were involved in authenticating the client.
.N: sec 2 environ "Environmental assumptions"
.LP
Kerberos imposes a few assumptions on the environment in which it can
properly function:
.IP \(bu
"Denial of service" attacks are not solved with Kerberos.  There are
places in these protocols where an intruder can prevent an application
from participating in the proper authentication steps.  Detection and
solution of such attacks (some of which can appear to be not-uncommon
"normal" failure modes for the system) is usually best left to
the human administrators and users.
.IP \(bu
Principals must keep their secret keys secret.  If an intruder somehow
steals a principal's key, it will be able to masquerade as that
principal or convince the principal that it is some server the principal
desires to contact.
.IP \(bu
Each host on the network must have a clock which is "loosely
synchronized" to the time of the other hosts; this synchronization is
used to reduce the bookkeeping needs of application servers when they do
replay detection.  (The degree of required "looseness" can be configured
on a per-server basis.)
.IP \(bu
Principal identifiers are not recycled on a short-term basis.  A typical
mode of access control will use access control lists (ACLs) to grant
permissions to particular princpals, and these ACL entries are often
hard to discover until it's too late.  By not re-using principal
identifiers, the danger of inadvertent access is removed.
.N: sec 2 foo52 "Glossary of terms"
.LP
Below is a list of terms used throughout this document.

.IP \fBAuthentication\fP 20
Verifying the claimed identity of a principal.

.IP "\fBAuthentication header\fP"
A record containing a Ticket and an Authenticator to be presented to a
server as part of the authentication process.

.IP "\fBAuthentication path\fP"
A sequence of intermediate realms transited in the authentication
process when communicating from one realm to another.

.IP \fBAuthenticator\fP
A record containing information that can be shown to
have been recently generated using the session key known only by the 
client and server.

.IP \fBAuthorization\fP
The process of determining whether a client may use a
service,  which objects the client is allowed to access, and the 
type of access allowed for each.

.IP \fBCapability\fP
A token that grants the bearer permission to access an object or
service.  In Kerberos, this might be a ticket whose use is restricted
by the contents of the authorization data field, but which lists no network
addresses, together with the session key necessary to use the ticket.

.IP \fBCiphertext\fP
The output of an encryption function.  Encryption transforms plaintext
into ciphertext.

.IP \fBClient\fP
A process that makes use of a network service, on behalf of a
user.  Note that in some cases a \fBServer\fP may itself be a client of
some other server (e.g. a print server may be a client of a file server).

.IP \fBCredentials\fP
A ticket plus the secret session key necessary to
successfully use that ticket in an authentication exchange.

.IP \fBKDC\fP
Key Distribution Center, a network service that supplies
tickets and temporary session keys; or an
instance of that service or the host on which it runs.
The KDC services both initial ticket and ticket-granting ticket
requests.
The initial ticket portion is sometimes referred to as the
Authentication Server (or service).
The ticket-granting ticket portion is sometimes referred to as the
ticket-granting server (or service).

.IP \fBKerberos\fP
Aside from the 3-headed dog guarding Hades, the name given
to Project Athena's authentication service, the protocol used by that
service, or the code used to implement the authentication service.

.IP \fBPlaintext\fP
The input to an encryption function or the output of a decryption
function.  Decryption transforms ciphertext into plaintext.

.IP \fBPrincipal\fP
A uniquely named client or server instance that participates in
a network communication.

.IP "\fBPrincipal identifier\fP"
The name used to uniquely identify each different
principal.

.IP \fBSeal\fP
To encipher a record containing several fields, in such a way
that the fields cannot be individually replaced without either
knowledge of the encryption key or leaving evidence of tampering.

.IP "\fBSecret key\fP"
An encryption key shared by a principal and the KDC,
distributed outside the bounds of the system, with a long lifetime.
In the case of a human user's principal, the secret key is derived from a
password.

.IP \fBServer\fP
A particular Principal which provides a resource to network clients.

.IP \fBService\fP
A resource provided to network clients; often provided by more than one
server (for example, remote file service).

.IP "\fBSession key\fP"
A temporary encryption key used between two principals,
with a lifetime limited to the duration of a single communications
"session".

.IP \fBTicket\fP
A record that helps a client authenticate itself to a server; it contains
the client's identity, a session key, a timestamp, and other
information, all sealed using the server's secret key.  It only serves to
authenticate a client when presented along with a fresh Authenticator.
