.\"	$Source: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/TAC.ms,v $
.\"	$Author: jtkohl $
.\"	$Id: TAC.ms,v 1.37 91/02/18 11:44:53 jtkohl Exp $
.\"
.ds R# "$Id: TAC.ms,v 1.37 91/02/18 11:44:53 jtkohl Exp $
.N: sec 2 foo54 "Tickets and Authenticators"
.PP
This section describes the format and encryption parameters for
tickets and authenticators.  When a ticket or
authenticator is included in a protocol message it is treated as an
opaque object.
.N: sec 3 ticket_def "Tickets"
.PP
A ticket is a record that helps a client authenticate to a service.  A
Ticket contains the following information:
.TS
center;
lb l l.
Ticket ::=	[APPLICATION 1] SEQUENCE {
	tkt-vno[0]	INTEGER,
	realm[1]	Realm,
	sname[2]	PrincipalName,
	enc-part[3]	EncryptedData	-- EncTicketPart
}
-- Encrypted part of ticket
EncTicketPart ::=	[APPLICATION 3] SEQUENCE {
	flags[0]	TicketFlags,
	key[1]	EncryptionKey,
	crealm[2]	Realm,
	cname[3]	PrincipalName,
	transited[4]	TransitedEncoding,
	authtime[5]	KerberosTime,
	starttime[6]	KerberosTime OPTIONAL,
	endtime[7]	KerberosTime,
	renew-till[8]	KerberosTime OPTIONAL,
	caddr[9]	HostAddresses OPTIONAL,
	authorization-data[10]	AuthorizationData OPTIONAL
}
-- encoded Transited field
TransitedEncoding ::=	SEQUENCE {
	tr-type[0]	INTEGER,
		-- must be a registered value
	contents[1]	OCTET STRING
}
.TE
The encoding of \fBEncTicketPart\fP is encrypted in the key shared by
Kerberos and the end server (the server's secret key).  See section ~sec
enc_spec~
for the format of the ciphertext.
.IP \fBtkt-vno\fP 10
This field specifies the version number for the ticket format.  This
document describes version number 5.

.IP \fBrealm\fP 10
This field specifies the realm that issued a ticket.  It also serves to
identify the realm part of the server's principal identifier.  Since a
Kerberos server can only issue tickets for servers within its realm, the
two will always be identical.

.IP \fBsname\fP 10
This field specifies the name part of the server's identity.

.IP \fBenc-part\fP 10
This field holds the encrypted encoding of the \fBEncTicketPart\fP
sequence.

.IP \fBflags\fP 10
This field indicates which of various options were
used or requested when the ticket was issued.  It is a bit-field,
where the selected options are indicated by the bit being set (1), and
the unselected options and reserved fields being reset (0).  Bit 0 is
the most significant bit.  The encoding of the bits is specified in
section ~sec asn1_base~.  The flags are described in more detail above
in section ~sec flag_stuff~.  The meanings of the flags are:

.TS
expand;
l l lw(4i).
.KS
\fIBit(s)	Name	Description\fP
.sp
0	RESERVED	T{
Reserved for future expansion of this field.
T}
.KE
.sp
1	FORWARDABLE	T{
The FORWARDABLE flag is normally only interpreted by the TGS,
and can be ignored by end servers.
When set, this flag tells the ticket-granting
server that it is OK to issue a new ticket-granting ticket with a
different network address based on the presented ticket.
T}
.sp
2	FORWARDED	T{
When set, this flag indicates that the ticket has either
been forwarded or was issued based on authentication
involving a forwarded ticket-granting ticket.
T}
.sp
3	PROXIABLE	T{
The PROXIABLE flag is normally only interpreted by the TGS, and can be
ignored by end servers.  The PROXIABLE flag has an interpretation
identical to that of the FORWARDABLE flag, except that the PROXIABLE
flag tells the ticket-granting server that only non-ticket-granting
tickets may be issued with different network addresses.
T}
.sp
4	PROXY	T{
When set, this flag indicates that a ticket is a proxy.
T}
.sp
5	MAY-POSTDATE	T{
The MAY-POSTDATE flag is normally only interpreted by the TGS,
and can be ignored by end servers.
This flag tells the ticket-granting server that a postdated ticket may
be issued based on this ticket-granting ticket.
T}
.sp
6	POSTDATED	T{
This flag indicates that this ticket has been postdated.  The
end-service can check the \fBauthtime\fP field to see when the original
authentication occurred.
T}
.sp
7	INVALID	T{
This flag indicates that a ticket is invalid, and it must be validated
by the KDC before use.  Application servers must
reject tickets which have this flag set.
T}
.sp
8	RENEWABLE 	T{
The RENEWABLE flag is normally only interpreted by the TGS,
and can usually be ignored by end servers (some particularly careful
servers may wish to disallow renewable tickets).
A renewable ticket can be used to obtain a replacement ticket
that expires at a later date.
T}
.sp
9	INITIAL	T{
This flag indicates that this ticket was issued using the AS protocol,
and not issued based on a ticket-granting ticket.
T}
.sp
10-31	RESERVED	T{
Reserved for future use.
T}
.TE

.IP \fBkey\fP 10
This field exists in the ticket and the KDC response and is used to
pass the session key from Kerberos to the application server and the
client.  The field's encoding is described in
section ~sec enc_spec_def~.
.IP \fBcrealm\fP 10
This field contains the name of the realm in which the client is
registered and in which initial authentication took place.

.IP \fBcname\fP 10
This field contains the name part of the client's principal identifier.

.IP \fBtransited\fP 10
This field lists the names of the Kerberos realms that took part in
authenticating the user to whom this ticket was issued.  It does not
specify the order in which the realms were transited.  See section ~sec
transited_spec~ for details on how this field encodes the traversed realms.

.IP \fBauthtime\fP 10
This field indicates the time of initial authentication for the named
principal.  It is the time of issue for the original ticket on which
this ticket is based.  It is included in the ticket to provide
additional information to the end service, and to provide the necessary
information for implementation of a `hot list' service at the KDC.  An
end service that is
particularly paranoid could refuse to accept tickets for which the
initial authentication occurred "too far" in the past.  

This field is also returned as part of the response from the KDC.
When returned as part of the response to initial authentication
(KRB_AS_REP), this is the current time on the Kerberos server\**.
.FS
This time value might be used (at the host's option) to adjust the
workstation's clock.  HOWEVER, this is not recommended, since the client
cannot determine that such a KRB_AS_REP actually came from the proper
KDC in a timely manner unless the enclosed ticket can be used in
communication with a server whose secrets are uncompromised.
.FE

.IP \fBstarttime\fP 10
This field in the ticket specifies the time after which the ticket is valid.
Together with \fBendtime\fP, this field specifies the life of the ticket.
If it is absent from the ticket, its value should be treated as that of
the \fBauthtime\fP field.

.IP \fBendtime\fP 10
This field contains the time after which the ticket will not be honored
(its expiration time).  Note that individual services may place their own
limits on the life of a ticket and may reject tickets which have not
yet expired.  As such, this is really an upper bound on the expiration
time for the ticket.

.IP \fBrenew-till\fP 10
This field is only present in tickets that have the RENEWABLE flag set
in the \fBflags\fP field.  It indicates the maximum \fBendtime\fP that
may be included in a renewal.  It can be thought of as the absolute
expiration time for the ticket, including all renewals.

.IP \fBcaddr\fP 10
This field in a ticket contains zero (if omitted) or more (if present)
host addresses.  These are the addresses from which the ticket can be
used.  If there are no addresses, the ticket can be used from any
location.  The decision by the KDC to issue or by the end server to
accept zero-address tickets is a policy decision and is left to the
Kerberos and end-service administrators; they may refuse to issue or
accept such tickets.  The suggested and default policy, however, is that
such tickets will only be issued or accepted when additional information
that can be used to restrict the use of the ticket is included in the
authorization_data field.  Such a ticket is a capability.

Network addresses are included in the ticket to make it harder for an
attacker to use stolen credentials.  Because the session key is not
sent over the network in cleartext, credentials can't be stolen simply
by listening to the network; an attacker has to gain access to the
session key (perhaps through operating system security breaches or a
careless user's unattended session) to make use of stolen tickets.

It is important to note that the network address from which a
connection is received cannot be reliably determined.  Even if it
could be, an attacker who has compromised the client's workstation
could use the credentials from there.  Including the network addresses
only makes it more difficult, not impossible, for an attacker to
walk off with stolen credentials and then use them from a "safe"
location.

.IP \fBauthorization-data\fP 10
.br
The \fBauthorization-data\fP field is used to pass authorization data from
the principal on whose behalf a ticket was issued to the application service.
If no authorization data is included, this field will be left out.
The
data in this field are specific to the end service.  It is expected
that the field will contain the names of service specific objects, and
the rights to those objects.  The format for this field is described
in section ~sec asn1_base~.
Although Kerberos is not concerned with the format of the contents of
the subfields, it
does carry type information (\fBad-type\fP).
.sp
By using the \fBauthorization_data\fP field, a principal is able to
issue a proxy that is 
valid for a specific purpose.  For example, a client wishing to print
a file can obtain a file server proxy to be passed to the print
server.  By specifying the name of the file in the \fBauthorization_data\fP
field, the file server knows that the print server can only use the
client's rights when accessing the particular file to be printed.
.sp
It is interesting to note that if one specifies the \fBauthorization-data\fP
field of a proxy and leaves the host addresses blank, the resulting
ticket and session key can be treated as a
capability.  See
.[ [
PBAANeuman
.]]
for some suggested uses of this field.
.sp
The \fBauthorization-data\fP field is optional and does not have to be
included in a ticket.
.N: sec 3 auth_def "Authenticators"
.PP
An authenticator is a record sent with a ticket to a server to certify
the client's knowledge of the encryption key in the ticket, to help
the server detect replays, and to help choose a "true session key" to use
with the particular session.
The encoding is
encrypted in the ticket's session key shared by the client and the server:
.TS
center;
lb l l.
-- Unencrypted authenticator
Authenticator ::=	[APPLICATION 2] SEQUENCE  {
	authenticator-vno[0]	INTEGER,
	crealm[1]	Realm,
	cname[2]	PrincipalName,
	cksum[3]	Checksum OPTIONAL,
	cusec[4]	INTEGER,
	ctime[5]	KerberosTime,
	subkey[6]	EncryptionKey OPTIONAL,
	seq-number[7]	INTEGER OPTIONAL
}
.TE
.IP \fBauthenticator-vno\fP 10
.br
This field specifies the version number for the format of the
authenticator.  This document specifies version 5.

.IP "\fBcrealm\fP and \fBcname\fP" 10
.br
These fields are the same as those described for the ticket in section
~sec ticket_def~.

.IP \fBcksum\fP 10
This field contains a checksum of the 
the application data that accompanies the KRB_AP_REQ.

.IP \fBcusec\fP 10
This field contains the microsecond part of the client's timestamp.  Its
value (before encryption) ranges from 0 to 999999.  It often appears
along with \fBctime\fP.  The two fields are used together to specify a
reasonably accurate timestamp.

.IP \fBctime\fP 10
This field contains the current time on the client's host.

.IP \fBsubkey\fP 10
This field contains the client's choice for an encryption key which is
to be used to protect this specific application session.

.IP \fBseq-number\fP 10
This optional field includes the initial sequence number to be used by
the KRB_PRIV or KRB_SAFE messages when sequence numbers are used to
detect replays (It may also be used by application specific messages).
When included in the authenticator this field specifies the initial
sequence number for messages from the client to the server.  When
included in the AP-REP message, the initial sequence number is that
for messages from the server to the client.  When used in KRB_PRIV or
KRB_SAFE messages, it is incremented by one after each message is sent.

For sequence numbers to adequately support the detection of replays
they should be non-repeating, even across connection boundaries.  The
initial sequence number should be random and uniformly distributed
across the full space of possible sequence numbers, so that it cannot be
guessed by an attacker and so that it and the successive sequence
numbers do not repeat other sequences.
