.\"	$Source: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/Tickets.ms,v $
.\"	$Author: jtkohl $
.\"	$Id: Tickets.ms,v 1.1 90/12/19 17:07:38 jtkohl Exp $
.\"
.ds R# "$Id: Tickets.ms,v 1.1 90/12/19 17:07:38 jtkohl Exp $
.N: sec 1 flag_stuff "Ticket flag uses and requests"
.LP
Each Kerberos ticket contains a set of flags which are used to indicate
various attributes of that ticket.  Most flags may be requested by a
client when the ticket is obtained; some are automatically turned on and
off by a Kerberos server as required.
The following sections explain what the various flags mean, and gives
some examples of reasons to use such a flag.
.N: sec 2 initial_flag "Initial tickets"
.PP
The INITIAL flag indicates that a ticket was issued using the AS protocol
and not issued based on a ticket-granting ticket.  Application servers that
want to require the knowledge of a client's secret key (e.g. a
password-changing program) can insist that this flag be set in any
tickets they accept, and thus be assured that the client's key was
recently presented to the application client.
.N: sec 2 invalid_flag "Invalid tickets"
.PP
The INVALID flag indicates that a ticket is invalid.  Application
servers must reject tickets which have this flag set.  A postdated
ticket will usually be issued in this form.  Invalid tickets must be
validated by the KDC before use, by presenting them to the KDC in a TGS
request with the VALIDATE option specified.  The KDC will only validate tickets
after their \fBstarttime\fP has passed.  The validation is required so
that postdated tickets which have been stolen before their
\fBstarttime\fP can be rendered permanently invalid (through a hot-list
mechanism).
.\" XXX ref for hot-list
.N: sec 2 renewable_flag "Renewable tickets"
.PP
Applications may desire to hold tickets which can be valid for long
periods of time.  However, this can expose their credentials to
potential theft for equally long periods, and those stolen credentials
would be valid until the expiration time of the ticket(s).  Simply using
short-lived tickets and obtaining new ones periodically would require
the client to have long-term access to its secret key, an even greater risk.
Renewable
tickets can be used to mitigate the consequences of theft.  Renewable
tickets have two "expiration times": the first is when the current
instance of the ticket expires, and the second is the latest permissible
value for an individual expiration time.  An application client must
periodically (i.e. before it expires) present a renewable ticket to the
KDC, with the RENEW option set in the KDC request.
The KDC will issue a new ticket with a new session key and a later
expiration time.  All other fields of the ticket are left unmodified by
the renewal process.  When the latest permissible expiration time
arrives, the ticket expires permanently.  At each renewal, the KDC may
consult a hot-list to determine if the ticket had been reported stolen
since its last renewal; it will refuse to renew such stolen tickets, and
thus the usable lifetime of stolen tickets is reduced.
.PP
The RENEWABLE flag in a ticket is normally only interpreted by the
ticket-granting service (discussed below in section ~sec tgs-exch~).  It
can usually be ignored by application servers.  However, some
particularly careful application servers may wish to disallow renewable
tickets.  If a renewable ticket is not renewed by its expiration time,
the KDC will not renew the ticket.  The RENEWABLE flag is reset by
default, but a client may request it be set by setting the RENEWABLE
option in the AS request.  If it is set, then the \fBrenew-till\fP field
in the ticket contains the time after which the ticket may not be renewed.
.N: sec 2 postdated_tickets "Postdated tickets"
.PP
Applications may occasionally need to obtain tickets for use much later,
e.g. a batch submission system would need tickets to be valid at the
time the batch job is serviced.  However, it is dangerous to hold valid
tickets in a batch queue, since they will be on-line longer and more
prone to theft.  Postdated tickets provide a way to obtain these tickets
from the KDC at job submission time, but to leave them "dormant" until
they are activated and validated by a further request of the KDC.  If
a ticket theft were reported in the interim, the KDC would refuse to
validate the ticket, and the thief will be foiled.
.PP
The MAY-POSTDATE flag in a ticket is normally only interpreted by the
ticket-granting service. It can be ignored by application servers.  This
flag must be set in a ticket-granting ticket in order to issue a
postdated ticket based on the presented ticket.  It is reset by default;
it may be requested by a client by setting the ALLOW-POSTDATE option in
the AS request.
This flag does not allow a client to obtain a postdated ticket-granting
ticket; Postdated ticket-granting tickets can only by obtained by
requesting the postdating in the KRB_AS_REQ message.  The life
(\fBendtime\fP-\fBstarttime\fP) of a postdated ticket will be the
remaining life of the ticket-granting ticket at the time of the request,
unless the RENEWABLE option is also set, in which case it can be the
full life of the ticket-granting ticket.  The KDC may limit how far in
the future a ticket may be postdated.
.PP
The POSTDATED flag indicates that a ticket has been postdated.  The
application server can check the \fBauthtime\fP field in the ticket to
see when the original authentication occurred.  Some services may choose
to reject postdated tickets, or they may only accept them within a
certain period after the original authentication.  When the KDC issues a
POSTDATED ticket, it will also be marked as INVALID, so that the
application client must present the ticket to the KDC to be validated
before use.
.N: sec 2 proxy_flag "Proxiable and proxy tickets"
.PP
At times it may be necessary for a principal to allow a service to
perform an operation on its behalf.  The service must be able to take on
the identity of the client, but only for a particular purpose.  A
principal can allow a service to take on the principal's identity for a
particular purpose by granting it a proxy.
.PP
The PROXIABLE flag in a ticket is normally only interpreted by the
ticket-granting service. It can be ignored by application servers.  When
set, this flag tells the ticket-granting server that it is OK to issue a
new ticket (but not a ticket-granting ticket) with a different network
address based on this ticket.  This flag is set by default.
.PP
This flag allows a client to pass a proxy to a server to perform a
remote request on its behalf, e.g. a print service client can give the
print server a proxy to access the client's files on a particular file
server in order to satisfy a print request.
.PP
In order to complicate the use of stolen credentials, Kerberos tickets
are usually valid from only those network addresses specifically
included in the ticket\**.
.FS
It is permissible to request or issue tickets with no network addresses
specified, but we do not recommend it.
.FE
For this reason, a client wishing to grant a
proxy must request a new ticket valid for the network address of the
service to be granted the proxy.
.PP
The PROXY flag is set in a ticket by the TGS when it issues a proxy
ticket.  Application servers may check this flag and require additional
authentication from the agent presenting the proxy in order to provide
an audit trail.
.N: sec 2 forw_flag "Forwardable tickets"
.PP
Authentication forwarding is an instance of the proxy case where
the service is granted complete use of the client's identity.  An
example where it might be used is when a user logs in to a
remote system and wants authentication to work from that system as if
the login were local.
.PP
The FORWARDABLE flag in a ticket is normally only interpreted by the
ticket-granting service.  It can be ignored by application servers.  The
FORWARDABLE flag has an interpretation similar to that of the PROXIABLE
flag, except ticket-granting tickets may also be issued with different
network addresses.  This flag is reset by default, but users may request
that it be set when they request their initial ticket-granting ticket,
by setting the FORWARDABLE option in the AS request.
.PP
This flag allows for authentication forwarding without requiring the
user to enter a password again.  If the flag is not set, then
authentication forwarding is not permitted, but the same end result can
still be achieved if the user engages in the AS exchange with the
requested network addresses.
.PP
The FORWARDED flag is set by the TGS when a client presents a ticket
with the FORWARDABLE flag set and requests it be set by specifying the
FORWARDED KDC option and supplying a set of addresses for the new
ticket.  It is also set in all tickets issued based on tickets with the
FORWARDED flag set.
Application servers may wish to process FORWARDED tickets
differently than non-FORWARDED tickets.
.N: sec 2 weird_kdc_options "Other KDC options"
.PP
There are two additional options which may be set in a client's request
of the KDC.
.PP
The RENEWABLE-OK option indicates that the client will
accept a renewable ticket if a ticket with the requested life cannot
otherwise be provided.  If a ticket with the requested life cannot be
provided, then the KDC may issue a renewable ticket with a
\fBrenew-till\fP equal to the the requested endtime.  The value of the
\fBrenew-till\fP field may still be adjusted by site-determined limits
or limits imposed by the individual principal or server.
.PP
The ENC-TKT-IN-SKEY option is honored only by the ticket-granting
service.  It indicates that the to-be-issued ticket for the end server
is to be encrypted in the session key from the additional
ticket-granting ticket provided with the request.  See
section ~sec generate_tgs_rep~ for specific details.
