.\"	$Source: /afs/athena.mit.edu/astaff/project/krb5/doc/protocols/kerberos/RCS/specs.ms,v $
.\"	$Author: jtkohl $
.\"	$Id: specs.ms,v 1.12 91/04/24 10:14:50 jtkohl Exp Locker: jtkohl $
.\"
.ds R# "$Id: specs.ms,v 1.12 91/04/24 10:14:50 jtkohl Exp Locker: jtkohl $
.N: sec 1 general_defs "Message Specifications"
.PP
The following sections describe the exact contents and encoding of
protocol messages and objects.  The ASN.1 base definitions are
presented in the first subsection.  The remaining subsections specify the
protocol objects (tickets and authenticators) and messages.
Specification of encryption and checksum techniques, and the fields
related to them, appear in section ~sec enc_spec~.
.N: sec 2 asn1_DER "ASN.1 Distinguished Encoding Representation"
.PP
All uses of ASN.1 in Kerberos shall use the Distinguished Encoding
Representation of the data elements.
.N: sec 2 asn1_base "ASN.1 Base Definitions"
.PP
The following ASN.1 base definitions are used in the rest of this
section.
Note that since the underscore character (_) is not permitted in ASN.1
names, the hyphen (-) is used in its place for the purposes of ASN.1 names.
.TS
center;
lb l l.
Realm ::=	GeneralString
PrincipalName ::=	SEQUENCE OF GeneralString
.TE
Kerberos realms are encoded as GeneralStrings.  Realms shall not contain
a character with the code 0 (the ASCII NUL).
A PrincipalName is a
sequence of components, each encoded as a GeneralString.
Taken together, a PrincipalName and a Realm form a principal identifier.
Most realms will usually consist of several components separated by
periods (.), in the style of Internet Domain Names.
Most PrincipalNames will have only a few components (typically one or two).
.TS
center;
lb l l.
KerberosTime ::=	GeneralizedTime
	-- Specifying UTC time zone (Z)
.TE
The timestamps used in Kerberos are encoded as \fBGeneralizedTime\fRs.
An encoding shall specify the UTC time zone (Z) and shall not include any
fractional portions of the seconds.  It further shall not include any
separators.  Example: The only valid format for UTC time 6 minutes, 27
seconds after 9 pm on 6 November 1985 is 
.B 19851106210627Z.
.TS
center;
lb l l.
HostAddress ::=	SEQUENCE  {
	addr-type[0]			INTEGER,
	address[1]			OCTET STRING
}
.sp
HostAddresses ::=	SEQUENCE OF SEQUENCE {
	addr-type[0]	INTEGER,
	address[1]	OCTET STRING
}
.TE
The host adddress encodings consists of two fields:
.IP \fBaddr-type\fP 10
This field  specifies the
type of address that follows.  Pre-defined values for this field are
specified in section ~sec hostaddrs~.

.IP \fBaddress\fP 10
This field encodes a single address of type \fBaddr-type\fP. 
.LP
The two forms differ slightly. \fBHostAddress\fP contains exactly one
address; \fBHostAddresses\fP contains a sequence of possibly many
addresses.
.TS
center;
lb l l.
AuthorizationData ::=	SEQUENCE OF SEQUENCE {
	ad-type[0]	INTEGER,
	ad-data[1]	OCTET STRING
}
.TE
.IP \fBad-data\fP 10
This field contains authorization data to be interpreted according to
the value of the corresponding \fBad-type\fP field.
.IP \fBad-type\fP 10
This field specifies the format for the
\fBad-data\fP subfield.
All negative values are reserved for local use.  Non-negative values are
reserved for registered use.
.TS
center;
lb l l.
APOptions ::=	BIT STRING {
	reserved(0),
	use-session-key(1),
	mutual-required(2)
}
.TE
.TS
center;
lb l l.
TicketFlags ::=	BIT STRING {
	reserved(0),
	forwardable(1),
	forwarded(2),
	proxiable(3),
	proxy(4),
	may-postdate(5),
	postdated(6),
	invalid(7),
	renewable(8),
	initial(9),
}
.TE
.TS
center;
lb l l.
KDCOptions ::=	BIT STRING {
	reserved(0),
	forwardable(1),
	forwarded(2),
	proxiable(3),
	proxy(4),
	allow-postdate(5),
	postdated(6),
	unused7(7),
	renewable(8),
	unused9(9),
	renewable-ok(27),
	enc-tkt-in-skey(28),
	renew(30),
	validate(31)
}
.TE
.TS
center;
lb l l.
LastReq ::=	SEQUENCE OF SEQUENCE {
	lr-type[0]	INTEGER,
	lr-value[1]	KerberosTime
}
.TE
.IP \fBlr-type\fP 10
This field indicates how the following \fBlr-value\fP
field is to be interpreted.  Negative values indicate that the
information pertains only to the responding server.  Non-negative values
pertain to all servers for the realm.
.sp
If the \fBlr-type\fP field is zero (0), then no information is conveyed
by the \fBlr-value\fP subfield.
If the absolute value of the \fBlr-type\fP field is one (1), then the
\fBlr-value\fP subfield is the time of last initial request for a TGT.
If it is two (2), then the \fBlr-value\fP subfield is the time of last
initial request.  If it is three (3), then the \fBlr-value\fP subfield
is the time of issue for the newest ticket-granting ticket used.  If
it is four (4), then the \fBlr-value\fP subfield is the time of the last
renewal.  If it is five (5), then the \fBlr-value\fP subfield is the time of
last request (of any type).

.IP \fBlr-value\fP 10
This field contains the time of the last request.  The time must be
interpreted according to the contents of the accompanying \fBlr-type\fP
subfield.
.PP
See section ~sec enc_spec~ for the definitions of Checksum, ChecksumType,
EncryptedData, EncryptionKey, EncryptionType, and KeyType.
