/*
 *                                        _
 * Copyright (c) 1990,1991,1992,1993 Stig Ostholm.
 * All Rights Reserved
 *
 *
 * The author takes no responsibility of actions caused by the use of this
 * software and does not guarantee the correctness of the functions.
 *
 * This software may be freely distributed and modified for non-commercial use
 * as long as the copyright notice is kept. If you modify any of the files,
 * pleas add a comment indicating what is modified and who made the
 * modification.
 *
 * If you intend to use this software for commercial purposes, contact the
 * author.
 *
 * If you find any bugs or porting problems, please inform the author about
 * the problem and fixes (if there are any).
 *
 *
 * Additional restrictions due to national laws governing the use, import or
 * export of cryptographic software is the responsibility of the software user,
 * importer or exporter to follow.
 *
 *
 *                                              _
 *                                         Stig Ostholm
 *                                         Chalmers University of Technology
 *                                         Department of Computer Engineering
 *                                         S-412 96 Gothenburg
 *                                         Sweden
 *                                         ----------------------------------
 *                                         Email: ostholm@ce.chalmers.se
 *                                         Phone: +46 31 772 1703
 *                                         Fax:   +46 31 772 3663
 */

#include	"des.h"
#include	"config.h"
#include	"version.h"

/*
 * des_key_sched
 *
 *	Generates a key schedule from a key.
 *
 *	result  0 => the key was generated.
 *	result -1 => the key has correct parity.
 *	result -2 => the key is weak:
 *
 */

int	des_key_sched(
#ifdef __STDC__
	des_cblock		*key,
	des_key_schedule	schedule)
#else
	key, schedule)
des_cblock 		*key;
des_key_schedule	schedule;
#endif
{
	if (! des_check_key_parity(key))
		return -1;	/* The key has the wrong parity. */
	if (des_is_weak_key(key))
		return -2;	/* The key is weak		 */

	VOID des_sched(key, schedule);

	return 0;
}
