/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/*
 * Read the standard input, which is assumed to be an RFC822 email
 * message, outputting the message headers including the blank line on
 * stderr and outputting the message body on stdout.
 *
 * In addition, look for lines in the message body that begin with "#".
 * For each such line prefix an additional "#".
 */

#include <stdio.h>

main()
{
    char buf[BUFSIZ];
    int part = 0;

    while (fgets(buf, sizeof buf, stdin) != (char *)0)
	switch (part) {
	case 1:			/* body */
	    fprintf(stdout, "%s%s", *buf == '#' ? "#" : "", buf);
	    continue;

	default:
	    switch (*buf) {
	    case '-':
	    case '\n':
		part = 1;

		/* fall through */

	    default:
		fprintf(stderr, "%s", buf);
		continue;
	    }
	}

    fflush(stdout);
    fflush(stderr);

    exit(0);
}
