/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include "config.h"
#include <stdio.h>
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "crypto.h"
#include "new.h"

static int fd_datain = 0;	/* stdin */
static int fd_hdrout = 2;	/* stderr */

static int fd_errout = 2;	/* stderr */
static int fd_userout = -1;
static int fd_userne = -1;

static struct bbuf *data_in()
{
    return(cbfdread(fd_datain));
}

static int header_out(buf)
struct bbuf *buf;
{
    return(cbfdwrite(fd_hdrout, buf));
}

static error_out(bbuf)
struct bbuf *bbuf;
{
    return(cbfdwrite(fd_errout, bbuf));
}

static user_out(bbuf)
struct bbuf *bbuf;
{
    return(cbfdwrite(fd_userout, bbuf));
}

static struct bbuf *user_ne()
{
    return(cbfdneread(fd_userne));
}


main(argc, argv)
int     argc;
char  **argv;
{
    struct cbstruct   iocbs;
    char            **origuser = NULLVP,
                    **defaultalias = NULLVP,
                    **localopts = NULLVP,
                    **fileopt = NULLVP,
                     *pu = NULLCP;
    FILE             *houtfile = (FILE *)0,
                     *dinfile = (FILE *)0;
    int               hashalg = MD5,
                      ret = NOTOK;

    /*  Initialize TIS/PEM  */

    if (pem_init(argc, argv, &localopts) != OK) {
	fprintf(stderr, "%s: initialization failure\n", argv[0]);
	goto cleanup;
    }

    /* help if necessary */

    if (argc == 2 && !strcasecmp (argv[1], "help")) {
	(void) fprintf(stderr, "TIS/PEM %s\n%s\n\n", VERSION, COPYRIGHT);
	(void) fprintf(stderr, "%s %s %s %s\n\n",
		       "Usage:", myname, "[sig-alias <alias>] ",
		       "[data-in <filename>] [header-out <filename>]");
	exit(1);
    }

    /*  Get user's record */

    if ((defaultalias = tag_user(user_tailor, "sig-alias")) == NULLVP) {
	fprintf(stderr, "%s: no alias for signing (sig-alias)\n", myname);
	exit(1);
    }

    rewind_indexfile();
    if ((origuser = get_tv_user("alias", *(defaultalias+1))) == NULLVP) {
        fprintf(stderr,"%s: unable to find user with sig-alias \"%s\"\n",
		myname, *(defaultalias+1));
	goto cleanup;
    }

    /* Set up minimal call back struct */

    BZERO(&iocbs, sizeof(struct cbstruct));
    iocbs.in_data = data_in;
    iocbs.out_hdrs = header_out;
    iocbs.out_errs = error_out;

    /* open data-in and header-out if we're not using the defaults
     *
     * also, if we use files, then allow for interacting with user in
     * case it is needed to get password for private key.
     */

    if ((fileopt = tag_user(localopts, "data-in")) != NULLVP)
	if ((dinfile = fopen(*(fileopt+1), "r")) != (FILE *)0) {
	    fd_datain = fileno(dinfile);
	    fd_userout = 1;
	    fd_userne = 0;
	    iocbs.out_user = user_out;
	    iocbs.ne_user = user_ne;
	    pu = pretty_user(origuser);
	    printf("\nSigning as %s.\n", pu);
	    FREE(pu);
	}
	else {
	    fprintf(stderr, "%s: unable to open data-in file %s\n",
		    myname, *(fileopt+1));
	    goto cleanup;
	}

    if ((fileopt = tag_user(localopts, "header-out")) != NULLVP)
	if ((houtfile = fopen(*(fileopt+1), "w")) != (FILE *)0) 
	    fd_hdrout = fileno(houtfile);
	else {
	    fprintf(stderr, "%s: unable to open header-out file %s\n",
		    myname, *(fileopt+1));
	    goto cleanup;
	}

    /* Generate the signature */

    if (pem_sign(origuser, hashalg, &iocbs) != OK) {
	fprintf(stderr, "%s: unable to sign data\n", myname);
	goto cleanup;
    }

    ret = OK;

 cleanup:

    if (dinfile != (FILE *)0)
	fclose (dinfile);
    if (houtfile != (FILE *)0)
	fclose (houtfile);

    exit(ret);
    
}

/****************************************************************************/


