/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "cert.h"
#include "util.h"

tobesigned_cert(ecert, tobesigned, mode)
struct bbuf **ecert;
struct tobesigned **tobesigned;
int mode;
{
    struct certificate *cert= NULL_CERT;

    if (ecert == (struct bbuf **)0) {
        return(NOTOK);
    }

    if (tobesigned == (struct tobesigned **)0) {
	return(NOTOK);
    }
    if (decode_cert(*ecert, &cert) != OK) {
        return(NOTOK);
    }


    switch (mode) {
    case READ:
	if (cert -> tobesigned == (struct tobesigned *)0) {
	    return(NOTOK);
	}

	if (*tobesigned != (struct tobesigned *)0) {
	    (void) free_tobesigned_cert(*tobesigned);
	    *tobesigned = (struct tobesigned *)0;
	}

	if ((*tobesigned = dup_tobesigned_cert(cert->tobesigned))
	    == (struct tobesigned *)0)
	    return(NOTOK);

	break;

    case WRITE:
	if (cert -> tobesigned != (struct tobesigned *)0) {
	    (void) free_tobesigned_cert(cert -> tobesigned);
	    cert -> tobesigned = (struct tobesigned *)0;
	}

	if (*tobesigned == (struct tobesigned *)0) {
	    return(NOTOK);
	}

	if ((cert -> tobesigned = alloc_tobesigned_cert())
	    == (struct tobesigned *)0)
	    return(NOTOK);

	BCOPY((char *)*tobesigned, (char *)cert -> tobesigned,
	      sizeof(struct tobesigned));

        if (encode_cert(cert, ecert) != OK) {
            return(NOTOK);
        }
 
	break;

    default:
	return(NOTOK);
    }

    return(OK);
}
