/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "cert.h"
#include "util.h"

valid_cert(ecert, begin, end, mode)
struct bbuf **ecert;
long int *begin;
long int *end;
int mode;
{
    struct certificate *cert= NULL_CERT;

    if (ecert == (struct bbuf **)0) {
        return(NOTOK);
    }

    if (begin == (long int *)0) {
	return(NOTOK);
    }

    if (end == (long int *)0) {
	return(NOTOK);
    }
    if (decode_cert(*ecert, &cert) != OK) {
        return(NOTOK);
    }

    switch (mode) {
    case READ:
	if (cert -> tobesigned == (struct tobesigned *)0) {
	    return(NOTOK);
	}

	if (cert -> tobesigned -> valid == (struct valid *)0) {
	    return(NOTOK);
	}

	*begin = cert -> tobesigned -> valid -> begin;
	*end = cert -> tobesigned -> valid -> end;
	break;

    case WRITE:
	if (cert -> tobesigned == (struct tobesigned *)0) {
	    if ((cert -> tobesigned = alloc_tobesigned_cert())
		== (struct tobesigned *)0)
		return(NOTOK);
	}

	if (cert -> tobesigned -> valid != (struct valid *)0) {
	    (void) free_valid_cert(cert -> tobesigned -> valid);
	    cert -> tobesigned -> valid = (struct valid *)0;
	}

	if ((cert -> tobesigned -> valid = alloc_valid_cert()) 
	    == (struct valid *)0)
	    return(NOTOK);

	cert -> tobesigned -> valid -> begin = *begin;
	cert -> tobesigned -> valid -> end = *end;
        if (encode_cert(cert, ecert) != OK) {
            return(NOTOK);
        }
	break;

    default:
	return(NOTOK);
    }

    return(OK);
}
