/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/*****************************************************************************
 * decode_rcl.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "crl.h"
#include "util.h"

int decode_rcl(ercl, drcl, rlength)
struct bbuf *ercl;
struct rcl_entry **drcl;
int *rlength;
{
    int length, llen, dp;
    struct bbuf *bb = NULLBB;
    struct rcl_entry *trcl= NULL_RCL_ENTRY;
    int retval = NOTOK;

    /* CHECK PARAMETERS */
    if (ercl == (struct bbuf *)0 || drcl == (struct rcl_entry **)0 ||  
	rlength == (int *)0)
        goto cleanup;

    if (*drcl != NULL_RCL_ENTRY) {
	(void) free_rcl(*drcl);
	*drcl = NULL_RCL_ENTRY;
    }

    /* CHECK FOR ENCODED DATA */
    if (ercl->data == (unsigned char *)0) 
        goto cleanup;

    if (ercl->length < 2) {
        retval = ASN1_ERR01;
        goto cleanup;
    }

    /* CHECK FOR UNIVERSAL CONSTRUCTED SEQUENCE */
    if (ercl->data[0] != (CLASS_UNIV|FORM_CONS|CONS_SEQ)) {
        retval = ASN1_ERR02;
        goto cleanup;
    }

    /* GET LENGTH */
    if ((retval = decode_len(&(ercl->data[1]), ercl->length-1, &length,
			     &llen)) != OK) {
        goto cleanup;
    }
    *rlength = 1 + llen + length;

    /* CHECK FOR NULL */
    if (!length)
	return(OK);

    /* ALLOCATE TEMPORARY BBUF */
    bb = alloc_bbuf();

    if ((retval = _rclinit(drcl)) != OK)
	goto cleanup;
	
    dp = 1 + llen;
    while (dp < *rlength) {
	bb->data = &(ercl->data[dp]);
	bb->length = *rlength - dp;
	if ((retval = decode_rcl_entry(bb,&trcl,&length)) != OK)
	    goto cleanup;
	dp += length;
	if ((retval = _rclappend(*drcl,trcl)) != OK)
	    goto cleanup;
	else 
	    (void) _rclnext(*drcl);
    }

    if ((retval = _rclend(drcl)) != OK)
	goto cleanup;

    /* retval = OK; */

 cleanup:

    if (bb != NULLBB) {
        bb->data = (unsigned char *)0;
        (void) free_bbuf(bb);
    }

    if (retval != OK) {
	(void) free_rcl(*drcl);
	*drcl = NULL_RCL_ENTRY;
    }

    return(retval);
}

/*****************************************************************************/

int decode_rcl_entry(ercl, drcl, rlength)
struct bbuf *ercl;
struct rcl_entry **drcl;
int *rlength;
{
    int id, length, llen;
    int dp, pl;
    struct bbuf *bb = NULLBB;
    int retval = NOTOK;

    /* CHECK PARAMETERS */
    if (ercl == (struct bbuf *)0) 
        goto cleanup;

    if (drcl == (struct rcl_entry **)0) 
        goto cleanup;

    if (*drcl != NULL_RCL_ENTRY) {
	(void) free_rcl(*drcl);
	*drcl = NULL_RCL_ENTRY;
    }
    if (rlength == (int *)0) {
        goto cleanup;
    }

    /* CHECK FOR ENCODED DATA */
    if (ercl->data == (unsigned char *)0) 
        goto cleanup;

    if (ercl->length < 2) {
        retval = ASN1_ERR01;
        goto cleanup;
    }

    /* CHECK FOR NULL */
    if ((id = ercl->data[0]) == (CLASS_UNIV|FORM_PRIM|PRIM_NULL)) {
	if (ercl->data[1] == 0x00) {
	    *rlength = 2;
	    retval = OK;
            goto cleanup;
        }
    }

    /* CHECK FOR UNIVERSAL CONSTRUCTED SEQUENCE */
    if (id != (CLASS_UNIV|FORM_CONS|CONS_SEQ)) {
        retval = ASN1_ERR02;
        goto cleanup;
    }

    /* GET LENGTH */
    if ((retval = decode_len(&(ercl->data[1]), ercl->length-1, &length,
			     &llen)) != OK)
        goto cleanup;
    retval = NOTOK;
    *rlength = 1 + llen + length;

    /* ALLOCATE TEMPORARY BBUF */
    bb = alloc_bbuf();

    /* DECODE REVOKED CERTIFICATE LIST */
    *drcl = alloc_rcl_entry();
    dp = 1 + llen;
    bb->data = &(ercl->data[dp]);
    bb->length = *rlength - dp;
    if ((retval = decode_ints(bb, &(*drcl)->serial, &pl)) != OK)
	goto cleanup;
    dp += pl;
    bb->data = &(ercl->data[dp]);
    bb->length = *rlength - dp;
    if ((retval = decode_utct(bb, &(*drcl)->date, &pl)) != OK)
	goto cleanup;

    /* retval = OK; */

 cleanup:

    if (bb != NULLBB) {
        bb->data = (unsigned char *)0;
        (void) free_bbuf(bb);
    }

    if (retval != OK) {
	(void) free_rcl(*drcl);
	*drcl = NULL_RCL_ENTRY;
    }

    return(retval);
}

/*****************************************************************************/
