/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "algid.h"
#include "bbuf.h"
#include "crl.h"
#include "util.h"

sig_alg_crl(crl, aid, loc, mode)
struct bbuf **crl;
struct algid **aid;
int loc;
int mode;
{
    struct crl  *dcrl= NULL_CRL;
    int		ret= NOTOK;

    if (crl == (struct bbuf **)0 || *crl == NULLBB) 
	goto cleanup;

    if (aid == (struct algid **)0) 
	goto cleanup;

    if ((loc & INNER) != INNER && (loc & OUTER) != OUTER) 
	goto cleanup;

    if (decode_crl(*crl, &dcrl) != OK) 
	goto cleanup;

    switch (mode) {
    case READ:
	FREE_ALGID(*aid);

	if ((loc & INNER) == INNER && (loc & OUTER) == OUTER) 
	    goto cleanup;

	if ((loc & INNER) == INNER) {
	    if (dcrl->tobesigned == NULL_CRLTOBESIGNED
	        || dcrl->tobesigned->sig_alg == NULL_ALGID) {
	        ret = OK;
	        goto cleanup;
	    }
	    if ((*aid = dup_algid(dcrl->tobesigned->sig_alg)) == NULL_ALGID)
		goto cleanup;
	} else {
	    if (dcrl->sig_alg == NULL_ALGID) {
	        ret = OK;
	        goto cleanup;
	    }
	    if ((*aid = dup_algid(dcrl->sig_alg)) == NULL_ALGID)
		goto cleanup;
	}
	ret = OK;
	break;

    case WRITE:
	if ((loc & INNER) == INNER) {
	    if (dcrl->tobesigned == NULL_CRLTOBESIGNED &&
	        (dcrl->tobesigned = alloc_crltobesigned())
		== NULL_CRLTOBESIGNED)
		goto cleanup;

	    FREE_ALGID(dcrl->tobesigned->sig_alg);
	    if (*aid != NULL_ALGID &&
	        (dcrl->tobesigned->sig_alg = dup_algid(*aid)) == NULL_ALGID)
	        goto cleanup;
	}

	if ((loc & OUTER) == OUTER) {
	    FREE_ALGID(dcrl->sig_alg);
	    if (*aid != NULL_ALGID &&
	        (dcrl->sig_alg = dup_algid(*aid)) == NULL_ALGID)
	        goto cleanup;
	}

        ret = encode_crl(dcrl, crl);
	break;

    default:

	goto cleanup;
    }

 cleanup:

    FREE_CRL(dcrl);
    return(ret);
}
